/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.resourceservices;

import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.resourceservices.ParameterDefinition;
import mil.army.usace.hec.metadata.resourceservices.ParameterLoader;
import rma.services.annotations.ServiceProvider;

@ServiceProvider(path="hec/data/Parameter", position=1, service=ParameterLoader.class)
public class DefaultParameterLoader
implements ParameterLoader {
    private static final Logger LOGGER = Logger.getLogger(DefaultParameterLoader.class.getName());
    private static final String PERCENT = "%  :  %  :  %";
    private static final String AREA = "Area  :  m2  :  ft2";
    private static final String CODE = "Code  :  n/a  :  n/a";
    private static final String CONCENTRATION = "Conc  :  mg/l  :  ppm";
    private static final String CONDUCTIVITY = "Cond  :  umho/cm  :  umho/cm";
    private static final String COUNT = "Count  :  unit  :  unit";
    private static final String CURRENCY = "Currency  :  $  :  $";
    private static final String DEPTH = "Depth  :  mm  :  in";
    private static final String DIRECTION = "Dir  :  deg  :  deg";
    private static final String ELEV = "Elev  :  m  :  ft";
    private static final String ENERGY = "Energy  :  MWh  :  MWh";
    private static final String EVAP = "Evap  :  mm  :  in";
    private static final String EVAP_RATE = "EvapRate  :  mm/day  :  in/day";
    private static final String FLOW = "Flow  :  cms  :  cfs";
    private static final String FROST = "Frost  :  cm     :     in";
    private static final String LENGTH = "Length   :   m      :     ft";
    private static final String OPENING = "Opening  :   m      :     ft";
    private static final String PERC_RATE = "PercRate :   m/s    :     ft/s";
    private static final String PH = "pH      :    su    :      su";
    private static final String POWER = "Power   :    MW    :      MW";
    private static final String PRECIP = "Precip   :   mm     :     in";
    private static final String PRESSURE = "Pres   :     kPa      :   in-hg";
    private static final String RADIATION = "Rad    :     J/m2    :    langley";
    private static final String SPEED = "Speed    :   kph   :      mph";
    private static final String STAGE = "Stage  :     m       :    ft";
    private static final String STOR = "Stor   :     m3     :     ac-ft";
    private static final String TEMP = "Temp    :    C      :     F";
    private static final String THICKNESS = "Thick   :    cm    :      in";
    private static final String TIMING = "Timing   :   sec     :    sec";
    private static final String TURBITITY = "Turb   :     jtu   :      jtu";
    private static final String VOLTAGE = "Volt    :    volt   :     volt";
    private static final String WIDTH = "Width   :    m        :   ft";
    private static final String LOSS_RATE = "LossRate  :  mm/hr   :    in/hr";
    private static final String INIT_DEF = "InitDef  :   mm     :     in";
    private static final String TRAVEL = "Travel    :  km      :    mi";
    private static final String SPIN_RATE = "SpinRate :   rpm   :      rpm";
    private static final String FLOW_PER_AREA = "FlowPerArea : cms/km2  :   cfs/mi2";
    private static final String IRRADIANCE = "Irrad   :    W/m2   :     langley/min";
    private static final String MELT_RATE = "MeltRate :   mm/deg-day : in/deg-day";
    private static final String PENALTY = "Penalty  :   K$   :       K$";
    private static final String FISH = "Fish     :   unit    :    unit";
    private static final String TURB_J = "TurbJ   :    jtu     :    jtu";
    private static final String TURB_N = "TurbN   :    ntu     :    ntu";
    private static final String DIST = "Dist    :    km     :     mi";
    private static final String RATIO = "Ratio   :    n/a   :      n/a";
    private static final String PERC = "Perc   :     mm     :     in";
    private static final String MASS_RATE = "MassRate  :  tonne/day :  ton/day";
    private static final String SED_SIZE = "Sed-Size  :  mm     :     in";
    private static final String BOTTOM_SIZE = "Bottom   :   m    :       ft";
    private static final String DEPOSITION = "Deposition : m3    :      ft3";
    private static final String VOLUME = "Volume   :   m3    :      ft3";
    private static final String SED_LOAD = "SedLoad  :  tonne/day :  ton/day";
    private static final String RATE_OF_RISE = "RateOfRise : m/hr  :      ft/hr";
    private static final String GROWTH = "Growth :  cm/day  :    in/day";
    private static final String TURB_F = "TurbF     :  fnu    :     fnu";
    private static final String DENSITY = "Density   :  g/cm3  :     lb/ft3";
    private static final String EXTINCTION = "Extinction : 1/m   :      1/ft";
    private static final String SHADE_FRAC = "Shade Frac : n/a   :      n/a";
    private static final String SUSP_SOLID = "Susp Solid : g/m3  :      n/a";
    private static final String ATI = "ATI    :     degC-day  :  degF-day";
    private static final String COLD_RATE = "ColdRate  :  mm/deg-day : in/deg-day";
    private static final String COEFF = "Coeff :   n/a  :  n/a";
    private static final String PROBABILITY = "Probability :   n/a  :  n/a";
    private static final String BINARY = "Binary :     n/a    :    n/a";
    private static final String CURRENT = "Current : ampere : ampere";
    private static final String HEAD = "Head : m : ft";
    private static final String HEIGHT = "Height : m : ft";
    private static final String ROTATION = "Rotation  :  deg :  deg";
    private static final String TEXT = "Text : n/a : n/a";
    private static final String GROWTH_RATE = "GrowthRate : cm/day : in/day";
    private static final String AIR_TEMP = "AirTemp : C : F";
    private static final String COLD_CONTENT = "Cold Content : mm : in";
    private static final String INTERCEPTION = "interception : mm : in";
    private static final String LIQUID_WATER = "liquid Water : mm : in";
    private static final String LWASS = "LWASS : mm : in";
    private static final String SWE = "SWE : mm : in";
    private static final String AREA_BASIN = "Area    :   Basin       :   km2     :   mi2";
    private static final String AREA_IMPACTED = "Area    :   Impacted    :   ha      :   acre";
    private static final String AREA_RESERVOIR = "Area    :   Reservoir   :   ha      :   acre";
    private static final String AREA_SURFACE = "Area    :   Surface     :   1000 m2 :   acre";
    private static final String PRM_AREA = "Area : PRM : km2 : 1000 acre";
    private static final String CONC_SALINITY = "Conc    :   Salinity    :   g/l     :   g/l";
    private static final String PRM_STORAGE = "Stor    :   PRM         :   mcm     :   KAF";
    private static final String PRM_FLOW = "Flow    :   PRM         :   mcm/mon :   KAF/mon";
    private static final String PRM_CURRENCY = "Currency:   PRM         :   $/mcm   :   $/KAF";
    private static final String TIMING_OFFSET = "Timing : Offset : hr : hr";
    private static final String TIMING_PERIOD = "Timing : Period : hr : hr";
    private static final String ATI_COLD = "ATI : Cold : degC-day : degF-day";
    private static final String ATI_MELT = "ATI : Melt : degC-day : degF-day";
    private boolean _isEnabled = true;

    public DefaultParameterLoader() {
        LOGGER.log(Level.FINEST, "Empty default ctor for service lookup");
    }

    @Override
    public void setEnabled(boolean tf) {
        this._isEnabled = tf;
    }

    @Override
    public boolean isEnabled() {
        return this._isEnabled;
    }

    public static int getBaseParameterIndex(List<ParameterDefinition> parameterDefinitions, String baseParameter) {
        for (int ii = 0; ii < parameterDefinitions.size(); ++ii) {
            String base = parameterDefinitions.get(ii).getBaseParameter();
            if (baseParameter.length() != base.length() || !baseParameter.equalsIgnoreCase(base)) continue;
            return ii;
        }
        return -1;
    }

    @Override
    public void addParameterDefinitions(List<ParameterDefinition> parameterDefinitions) {
        String[] parameters = new String[]{PERCENT, AREA, CODE, CONCENTRATION, CONDUCTIVITY, COUNT, CURRENCY, DEPTH, DIRECTION, ELEV, ENERGY, EVAP, EVAP_RATE, FLOW, FROST, LENGTH, OPENING, PERC_RATE, PH, POWER, PRECIP, PRESSURE, RADIATION, SPEED, STAGE, STOR, TEMP, THICKNESS, TIMING, TURBITITY, VOLTAGE, WIDTH, LOSS_RATE, INIT_DEF, TRAVEL, SPIN_RATE, FLOW_PER_AREA, IRRADIANCE, MELT_RATE, PENALTY, FISH, TURB_J, TURB_N, DIST, RATIO, PERC, MASS_RATE, SED_SIZE, BOTTOM_SIZE, DEPOSITION, VOLUME, SED_LOAD, RATE_OF_RISE, GROWTH, TURB_F, DENSITY, EXTINCTION, SHADE_FRAC, SUSP_SOLID, ATI, COLD_RATE, COEFF, PROBABILITY, BINARY, CURRENT, HEAD, HEIGHT, ROTATION, TEXT, GROWTH_RATE, AIR_TEMP, COLD_CONTENT, INTERCEPTION, LIQUID_WATER, LWASS, SWE};
        String[] altParameters = new String[]{AREA_BASIN, AREA_IMPACTED, AREA_RESERVOIR, AREA_SURFACE, CONC_SALINITY, PRM_STORAGE, PRM_FLOW, PRM_CURRENCY, PRM_AREA, TIMING_OFFSET, TIMING_PERIOD, ATI_COLD, ATI_MELT};
        for (int i = 0; i < parameters.length; ++i) {
            StringTokenizer st = new StringTokenizer(parameters[i], ":");
            if (st.countTokens() < 2) {
                LOGGER.log(Level.WARNING, "Bad parameter definition, {0}", parameters[i]);
                continue;
            }
            String baseParameter = st.nextToken().trim();
            String subParameter = null;
            String siUnits = st.nextToken().trim();
            String englishUnits = st.hasMoreTokens() ? st.nextToken().trim() : "undef";
            ParameterDefinition parameterDefinition = new ParameterDefinition(this.getLoaderName(), i, baseParameter, subParameter, siUnits, englishUnits);
            parameterDefinitions.add(parameterDefinition);
        }
        for (String altParameter : altParameters) {
            StringTokenizer st = new StringTokenizer(altParameter, ":", false);
            String baseParam = st.nextToken().trim();
            String subParam = st.nextToken().trim();
            String siUnits = st.hasMoreTokens() ? st.nextToken().trim() : "undef";
            String engUnits = st.hasMoreTokens() ? st.nextToken().trim() : "undef";
            ParameterDefinition parameterDefinition = new ParameterDefinition(this.getLoaderName(), null, baseParam, subParam, siUnits, engUnits);
            parameterDefinitions.add(parameterDefinition);
        }
    }

    @Override
    public int getOverwritePriority() {
        return 0;
    }

    @Override
    public String getLoaderName() {
        return DefaultParameterLoader.class.getSimpleName();
    }

    @Override
    public boolean validate() {
        return this._isEnabled;
    }
}

