/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.resourceservices;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.resourceservices.ParameterLoader;
import mil.army.usace.hec.metadata.resourceservices.ParameterResourceReader;
import rma.services.annotations.ServiceProvider;

@ServiceProvider(path="hec/data/Parameter", position=200, service=ParameterLoader.class)
public final class ModelParameterResourceLoader
extends ParameterResourceReader {
    private static final Logger LOGGER = Logger.getLogger(ModelParameterResourceLoader.class.getName());

    public ModelParameterResourceLoader() {
        LOGGER.log(Level.FINEST, "Empty default ctor for service lookup");
    }

    @Override
    public int getOverwritePriority() {
        return super.getOverwritePriority(200);
    }

    @Override
    protected BufferedReader getBufferedReader() {
        String resourceLocation = "hec/heclib/util/parameters_units.def";
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        InputStream resourceAsStream = classLoader.getResourceAsStream(resourceLocation);
        BufferedReader br = null;
        if (resourceAsStream != null) {
            this.logOnce(MessageFormat.format("Reading parameter resource file from classpath: {0}", resourceLocation));
            br = new BufferedReader(new InputStreamReader(resourceAsStream));
        } else {
            LOGGER.log(Level.CONFIG, "Could not find the model parameters resource file on the classpath from location: {0} using the thread context classloader: {1} + from the Thread: {2}", new Object[]{resourceLocation, classLoader, currentThread});
        }
        return br;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

