/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.resourceservices;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Parameter;
import mil.army.usace.hec.metadata.UnitUtil;
import mil.army.usace.hec.metadata.resourceservices.AltParameterUnits;
import mil.army.usace.hec.metadata.resourceservices.ParameterDefinition;
import mil.army.usace.hec.metadata.resourceservices.ParameterLoader;
import rma.util.lookup.Lookup;
import rma.util.lookup.Lookups;

public final class ParameterLookup {
    public static final int UNDEF_ALT_SUBPARAM = 65535;
    private static final Logger LOGGER = Logger.getLogger(ParameterLookup.class.getName());
    private static final List<String> PARAMETERS = new ArrayList<String>();
    private static final List<String> SI_UNITS = new ArrayList<String>();
    private static final List<String> ENG_UNITS = new ArrayList<String>();
    private static final List<List<AltParameterUnits>> ALT_PARAM_UNITS = new ArrayList<List<AltParameterUnits>>();

    private ParameterLookup() {
        throw new AssertionError((Object)"Utility class");
    }

    /*
     * WARNING - void declaration
     */
    static void loadParameters(List<ParameterDefinition> masterDefinitions, Map<ParameterDefinition, List<AltParameterUnits>> subParameterDefinitions) {
        void var9_20;
        int n;
        Integer unassignedIndex;
        Integer baseParameterIndex;
        Lookup parameterLookups = Lookups.forPath((String)"hec/data/Parameter");
        Collection parameterLoaders = parameterLookups.lookupAll(ParameterLoader.class);
        TreeMap<Integer, List> priorityLoaderMap = new TreeMap<Integer, List>();
        for (ParameterLoader parameterLoader : parameterLoaders) {
            if (!parameterLoader.validate()) continue;
            ArrayList loaderDefinitions = new ArrayList();
            parameterLoader.addParameterDefinitions(loaderDefinitions);
            int n2 = parameterLoader.getOverwritePriority();
            List list = priorityLoaderMap.computeIfAbsent(n2, k -> new ArrayList());
            list.add(loaderDefinitions);
        }
        SequenceGenerator sequence = new SequenceGenerator(0);
        Set entrySet = priorityLoaderMap.entrySet();
        for (Map.Entry entry : entrySet) {
            List list = (List)entry.getValue();
            for (Object loaderDefinitions : list) {
                Iterator iterator = loaderDefinitions.iterator();
                while (iterator.hasNext()) {
                    ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
                    if (parameterDefinition.getBaseParameterIndex() == null) continue;
                    sequence.addSkipNumber(parameterDefinition.getBaseParameterIndex());
                }
            }
        }
        LinkedHashMap<String, ParameterDefinition> baseParameterDefinitions = new LinkedHashMap<String, ParameterDefinition>();
        entrySet = priorityLoaderMap.entrySet();
        for (Map.Entry entry : entrySet) {
            List value = (List)entry.getValue();
            for (List loaderDefinitions : value) {
                ParameterLookup.mergeDefinitions(loaderDefinitions, sequence, baseParameterDefinitions, subParameterDefinitions);
            }
        }
        int n3 = -1;
        for (ParameterDefinition baseParameterDefinition : baseParameterDefinitions.values()) {
            baseParameterIndex = baseParameterDefinition.getBaseParameterIndex();
            unassignedIndex = baseParameterDefinition.getUnassignedIndex();
            if (baseParameterIndex != null && baseParameterIndex > n) {
                n = baseParameterIndex;
                continue;
            }
            if (unassignedIndex == null || unassignedIndex <= n) continue;
            n = unassignedIndex;
        }
        boolean bl = false;
        while (var9_20 <= n) {
            masterDefinitions.add(null);
            ++var9_20;
        }
        for (ParameterDefinition baseParameterDefinition : baseParameterDefinitions.values()) {
            baseParameterIndex = baseParameterDefinition.getBaseParameterIndex();
            unassignedIndex = baseParameterDefinition.getUnassignedIndex();
            if (baseParameterIndex != null) {
                masterDefinitions.set(baseParameterIndex, baseParameterDefinition);
                continue;
            }
            if (unassignedIndex == null) continue;
            masterDefinitions.set(unassignedIndex, baseParameterDefinition);
        }
    }

    private static void mergeDefinitions(List<ParameterDefinition> loaderDefinitions, SequenceGenerator sequence, Map<String, ParameterDefinition> baseParameterDefinitions, Map<ParameterDefinition, List<AltParameterUnits>> subParameterDefinitions) {
        for (ParameterDefinition loaderDefinition : loaderDefinitions) {
            String loaderName = loaderDefinition.getLoaderName();
            Integer loaderBaseParameterIndex = loaderDefinition.getBaseParameterIndex();
            String loaderBaseParam = loaderDefinition.getBaseParameter();
            String loaderSubParam = loaderDefinition.getSubParameter();
            String loaderSiUnits = loaderDefinition.getSiUnits();
            String loaderEngUnits = loaderDefinition.getEnglishUnits();
            boolean hasSubParameter = loaderDefinition.hasSubParameter();
            if (hasSubParameter) {
                List<AltParameterUnits> subParamList;
                ParameterDefinition mappedBaseParamDef = baseParameterDefinitions.get(loaderBaseParam.toUpperCase());
                if (mappedBaseParamDef == null) {
                    mappedBaseParamDef = new ParameterDefinition(loaderName, loaderBaseParameterIndex, loaderBaseParam, null, loaderSiUnits, loaderEngUnits);
                    baseParameterDefinitions.put(loaderBaseParam.toUpperCase(), mappedBaseParamDef);
                    if (loaderBaseParameterIndex == null) {
                        int nextUnassignedIdx = sequence.next();
                        mappedBaseParamDef.setUnassignedIndex(nextUnassignedIdx);
                    }
                }
                if ((subParamList = subParameterDefinitions.get(mappedBaseParamDef)) == null) {
                    subParamList = new ArrayList<AltParameterUnits>();
                    AltParameterUnits newAltParameterUnits = new AltParameterUnits(loaderBaseParam, loaderSubParam, loaderSiUnits, loaderEngUnits);
                    subParamList.add(newAltParameterUnits);
                    subParameterDefinitions.put(mappedBaseParamDef, subParamList);
                    continue;
                }
                AltParameterUnits foundAltParameterUnits = null;
                for (AltParameterUnits altParameterUnits : subParamList) {
                    if (!altParameterUnits.getBaseParameter().equalsIgnoreCase(loaderBaseParam) || !altParameterUnits.getSubParameter().equalsIgnoreCase(loaderSubParam)) continue;
                    foundAltParameterUnits = altParameterUnits;
                    break;
                }
                if (foundAltParameterUnits != null) {
                    foundAltParameterUnits.updateDefinition(loaderDefinition);
                    continue;
                }
                AltParameterUnits newAltParameterUnits = new AltParameterUnits(loaderBaseParam, loaderSubParam, loaderSiUnits, loaderEngUnits);
                subParamList.add(newAltParameterUnits);
                continue;
            }
            ParameterDefinition foundDef = baseParameterDefinitions.get(loaderBaseParam.toUpperCase());
            if (foundDef != null) {
                foundDef.updateDefinition(loaderDefinition);
                continue;
            }
            baseParameterDefinitions.put(loaderBaseParam.toUpperCase(), loaderDefinition);
            if (loaderBaseParameterIndex != null) continue;
            int nextUnassignedIdx = sequence.next();
            loaderDefinition.setUnassignedIndex(nextUnassignedIdx);
        }
    }

    private static void lookupLoadParameters() {
        ArrayList<ParameterDefinition> parameterDefinitions = new ArrayList<ParameterDefinition>();
        HashMap<ParameterDefinition, List<AltParameterUnits>> subParameterDefinitions = new HashMap<ParameterDefinition, List<AltParameterUnits>>();
        ParameterLookup.loadParameters(parameterDefinitions, subParameterDefinitions);
        int size = parameterDefinitions.size();
        if (size < 1) {
            LOGGER.log(Level.WARNING, "No parameter definitions were found, please check the parameter service loader configuration.");
        }
        for (ParameterDefinition parameterDefinition : parameterDefinitions) {
            if (parameterDefinition == null) continue;
            PARAMETERS.add(parameterDefinition.getBaseParameter());
            SI_UNITS.add(parameterDefinition.getSiUnits());
            ENG_UNITS.add(parameterDefinition.getEnglishUnits());
            List altParamUnitList = (List)subParameterDefinitions.get(parameterDefinition);
            if (altParamUnitList != null) {
                ALT_PARAM_UNITS.add(new ArrayList(altParamUnitList));
                continue;
            }
            ALT_PARAM_UNITS.add(new ArrayList());
        }
        if (LOGGER.isLoggable(Level.CONFIG)) {
            String parametersMessage = IntStream.range(0, PARAMETERS.size()).mapToObj(i -> PARAMETERS.get(i) + "\t" + SI_UNITS.get(i) + "\t" + ENG_UNITS.get(i)).collect(Collectors.joining("\n"));
            LOGGER.log(Level.CONFIG, () -> "Loaded parameters:\n" + parametersMessage);
            ArrayList<CallSite> altParamMessages = new ArrayList<CallSite>();
            for (int i2 = 0; i2 < ALT_PARAM_UNITS.size(); ++i2) {
                List<AltParameterUnits> altParameterUnits = ALT_PARAM_UNITS.get(i2);
                for (AltParameterUnits units : altParameterUnits) {
                    altParamMessages.add((CallSite)((Object)(PARAMETERS.get(i2) + "\t" + units.getSubParameter() + "\t" + units.getSiUnits() + "\t" + units.getEnglishUnits())));
                }
            }
            String altParametersMessage = String.join((CharSequence)"\n", altParamMessages);
            LOGGER.log(Level.CONFIG, () -> "Loaded altParameters:\n" + altParametersMessage);
        }
    }

    private static void loadParameters() {
        ParameterLookup.lookupLoadParameters();
    }

    public static String getUnitsStringForSystem(int paramId, int unitSystem) {
        int pId = ParameterLookup.getParamIndex(paramId);
        if (pId < 0 || pId > PARAMETERS.size()) {
            return "undef";
        }
        if (!UnitUtil.isValidUnitsSystem(unitSystem)) {
            throw new IllegalArgumentException("ERROR: <getUnitsStringForSystem()> invalid unit system");
        }
        int altParamIndex = ParameterLookup.getAltSubParamIndex(paramId);
        if (ALT_PARAM_UNITS.get(pId).isEmpty() || altParamIndex == 65535) {
            if (unitSystem == 2) {
                return SI_UNITS.get(pId);
            }
            if (unitSystem == 1) {
                return ENG_UNITS.get(pId);
            }
            return "undef";
        }
        AltParameterUnits units = ALT_PARAM_UNITS.get(pId).get(altParamIndex);
        if (unitSystem == 2) {
            return units.getSiUnits();
        }
        if (unitSystem == 1) {
            return units.getEnglishUnits();
        }
        return "undef";
    }

    public static String parseSubParameter(String parameter) {
        String subParameter = null;
        int index = parameter.indexOf("-");
        subParameter = index != -1 ? parameter.substring(index + 1).trim() : "";
        return subParameter;
    }

    public static int getParamIndex(int paramId) {
        return paramId & 0xFFFF;
    }

    public static int getAltSubParamIndex(int paramId) {
        return paramId >> 16 & 0xFFFF;
    }

    public static String[] getAvailableParameters() {
        return PARAMETERS.toArray(new String[0]);
    }

    public static List<Parameter> getDefaultParameters() {
        return PARAMETERS.stream().map(s -> {
            try {
                return new Parameter((String)s);
            }
            catch (DataSetIllegalArgumentException e) {
                LOGGER.log(Level.FINE, e, () -> "Error in parameter initialization for string: " + s);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static String getParameterForUnitsString(String units) {
        int index = ParameterLookup.getParameterIndexForUnitsString(units);
        if (index < 0 || index >= PARAMETERS.size()) {
            return null;
        }
        return PARAMETERS.get(index);
    }

    private static int getParameterIndexForUnitsString(String units) {
        int i;
        int index = -1;
        String tempUnits = UnitUtil.getUnitsForAlias(units);
        if (tempUnits != null) {
            units = tempUnits;
        }
        block0: for (i = 0; i < ALT_PARAM_UNITS.size(); ++i) {
            for (int j = 0; j < ALT_PARAM_UNITS.get(i).size(); ++j) {
                AltParameterUnits altSubParams = ALT_PARAM_UNITS.get(i).get(j);
                if (!altSubParams.getEnglishUnits().equals(units) && !altSubParams.getSiUnits().equals(units)) continue;
                index = i;
                continue block0;
            }
        }
        if (index < 0) {
            for (i = 0; i < SI_UNITS.size(); ++i) {
                if (!SI_UNITS.get(i).equals(units) && !ENG_UNITS.get(i).equals(units)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public static String[] getAvailableSubParameters(String parameter) {
        String baseParameter = ParameterLookup.parseBaseParameter(parameter);
        int index = ParameterLookup.getBaseParameterIndex(baseParameter);
        if (index == -1 || ALT_PARAM_UNITS.get(index).isEmpty()) {
            return new String[0];
        }
        int numberOfSubParams = ALT_PARAM_UNITS.get(index).size();
        String[] subParams = new String[numberOfSubParams];
        for (int i = 0; i < numberOfSubParams; ++i) {
            AltParameterUnits altSubParams = ALT_PARAM_UNITS.get(index).get(i);
            subParams[i] = altSubParams.getSubParameter();
        }
        return subParams;
    }

    public static String getUnitsForParameter(Parameter param) {
        for (int i = 0; i < SI_UNITS.size(); ++i) {
            if (!param.getBaseParameter().equals(PARAMETERS.get(i))) continue;
            return ParameterLookup.getUnitsStringForSystem(i, param.getSubParameter(), 2);
        }
        return "undef";
    }

    public static String getUnitsStringForSystem(String parameter, int unitSystem) {
        if (!UnitUtil.isValidUnitsSystem(unitSystem)) {
            throw new IllegalArgumentException("ERROR <Parameter.getUnitsStringForSystem(String,int)> : Invalid Unit System ID " + unitSystem);
        }
        String baseParameter = ParameterLookup.parseBaseParameter(parameter);
        String subParameter = ParameterLookup.parseSubParameter(parameter);
        int index = ParameterLookup.getBaseParameterIndex(baseParameter);
        if (index == -1) {
            return "undef";
        }
        return ParameterLookup.getUnitsStringForSystem(index, subParameter, unitSystem);
    }

    public static String getUnitsStringForSystem(String baseParameter, String subParameter, int unitSystem) {
        int baseParamIndex = ParameterLookup.getBaseParameterIndex(baseParameter);
        return ParameterLookup.getUnitsStringForSystem(baseParamIndex, subParameter, unitSystem);
    }

    public static String getUnitsStringForSystem(int baseParamIndex, String subParameter, int unitSystem) {
        if (baseParamIndex < 0 || baseParamIndex > PARAMETERS.size()) {
            return "undef";
        }
        if (ALT_PARAM_UNITS.get(baseParamIndex).isEmpty() || subParameter == null) {
            return unitSystem == 2 ? SI_UNITS.get(baseParamIndex) : ENG_UNITS.get(baseParamIndex);
        }
        for (int j = 0; j < ALT_PARAM_UNITS.get(baseParamIndex).size(); ++j) {
            AltParameterUnits altUnits = ALT_PARAM_UNITS.get(baseParamIndex).get(j);
            if (!subParameter.contains(altUnits.getSubParameter())) continue;
            return unitSystem == 2 ? altUnits.getSiUnits() : altUnits.getEnglishUnits();
        }
        return unitSystem == 2 ? SI_UNITS.get(baseParamIndex) : ENG_UNITS.get(baseParamIndex);
    }

    public static String[] getParameterUnits(int unitSystem) {
        if (unitSystem == 1) {
            return ENG_UNITS.toArray(new String[0]);
        }
        if (unitSystem == 2) {
            return SI_UNITS.toArray(new String[0]);
        }
        return null;
    }

    public static String getBaseParameterProperCase(String baseParameter) {
        int baseParameterIndex = ParameterLookup.getBaseParameterIndex(baseParameter);
        if (baseParameterIndex >= 0) {
            return ParameterLookup.parseBaseParameter(PARAMETERS.get(baseParameterIndex));
        }
        return null;
    }

    public static int getBaseParameterIndex(String baseParameter) {
        for (int i = 0; i < PARAMETERS.size(); ++i) {
            if (PARAMETERS.get(i) == null || PARAMETERS.get(i).isEmpty()) continue;
            String base = ParameterLookup.parseBaseParameter(PARAMETERS.get(i));
            if (baseParameter.length() != base.length() || !baseParameter.equalsIgnoreCase(base)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isValid(String parameter) {
        int baseParameterIndex = ParameterLookup.getBaseParameterIndex(ParameterLookup.parseBaseParameter(parameter));
        return baseParameterIndex >= 0;
    }

    public static boolean isNotValid(String parameter) {
        return !ParameterLookup.isValid(parameter);
    }

    public static String parseBaseParameter(String parameter) {
        int index = parameter.indexOf("-");
        String baseParameter = index != -1 ? parameter.substring(0, index).trim() : parameter.trim();
        return baseParameter;
    }

    public static String getParamString(int paramId) {
        int pId = ParameterLookup.getParamIndex(paramId);
        if (pId < 0 || pId > PARAMETERS.size()) {
            return "undef";
        }
        return PARAMETERS.get(pId);
    }

    public static String getFullParamString(int paramId) {
        int index;
        int pId = ParameterLookup.getParamIndex(paramId);
        if (pId < 0 || pId > PARAMETERS.size()) {
            return "undef";
        }
        Object fullName = PARAMETERS.get(pId);
        String[] params = ParameterLookup.getAvailableSubParameters(ParameterLookup.getParamString(paramId));
        if (params.length > 0 && (index = paramId >> 16 & 0xFFFF) >= 0 && index < params.length) {
            fullName = (String)fullName + "-" + params[index];
        }
        return fullName;
    }

    public static int getParameterId(String baseParameter, String subParameter) {
        int baseParameterIndex = ParameterLookup.getBaseParameterIndex(baseParameter);
        if (baseParameterIndex == -1) {
            return -1;
        }
        int numberOfSubParams = ALT_PARAM_UNITS.get(baseParameterIndex).size();
        for (int i = 0; i < numberOfSubParams; ++i) {
            AltParameterUnits altSubParams = ALT_PARAM_UNITS.get(baseParameterIndex).get(i);
            if (!subParameter.equalsIgnoreCase(altSubParams.getSubParameter())) continue;
            return Parameter.generateParameterId(baseParameterIndex, i);
        }
        return Parameter.generateParameterId(baseParameterIndex, 65535);
    }

    static {
        try {
            ParameterLookup.loadParameters();
        }
        catch (RuntimeException t) {
            LOGGER.log(Level.WARNING, "Error loading Parameters.", t);
        }
    }

    private static class SequenceGenerator {
        int _startingIndex;
        Integer _lastIdx = null;
        SortedSet<Integer> _skipNumbers = new TreeSet<Integer>();

        SequenceGenerator(int startingIndex) {
            this._startingIndex = startingIndex;
        }

        void addSkipNumber(Integer baseParameterIndex) {
            this._skipNumbers.add(baseParameterIndex);
        }

        int next() {
            int currentIdx = this._lastIdx == null ? this._startingIndex : this._lastIdx + 1;
            while (this._skipNumbers.contains(currentIdx)) {
                ++currentIdx;
            }
            this._lastIdx = currentIdx;
            return currentIdx;
        }
    }
}

