/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.resourceservices;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.resourceservices.ParameterDefinition;
import mil.army.usace.hec.metadata.resourceservices.ParameterLoader;
import mil.army.usace.hec.metadata.resourceservices.ParameterLookup;

public abstract class ParameterResourceReader
implements ParameterLoader {
    private static final Set<String> LOG_ONCE = new HashSet<String>();
    private boolean _isEnabled = true;

    @Override
    public void setEnabled(boolean tf) {
        this._isEnabled = tf;
    }

    @Override
    public boolean isEnabled() {
        return this._isEnabled;
    }

    @Override
    public final void addParameterDefinitions(List<ParameterDefinition> parameterDefinitions) {
        try (BufferedReader br = this.getBufferedReader();){
            this.readParameters(br, parameterDefinitions);
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Error reading parameter resource file input stream", ioe);
        }
    }

    @Override
    public final String getLoaderName() {
        return this.getClass().getSimpleName();
    }

    protected void readParameters(BufferedReader br, List<ParameterDefinition> parameterDefinitions) throws IOException {
        String line = null;
        HeaderRecord headerRecord = this.readHeader(br);
        if (!headerRecord.isValid()) {
            return;
        }
        while ((line = br.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, ":");
            if (st.countTokens() < 2) continue;
            String paramStr = st.nextToken().trim();
            String baseParameter = ParameterLookup.parseBaseParameter(paramStr);
            String subParameter = ParameterLookup.parseSubParameter(paramStr);
            String siUnit = st.nextToken().trim();
            String engUnit = st.hasMoreTokens() ? st.nextToken().trim() : "undef";
            ParameterDefinition parameterDefinition = new ParameterDefinition(this.getLoaderName(), null, baseParameter, subParameter, siUnit, engUnit);
            parameterDefinitions.add(parameterDefinition);
        }
    }

    protected HeaderRecord readHeader(BufferedReader br) throws IOException {
        String[] split;
        HeaderRecord headerRecord = new HeaderRecord();
        if (br == null) {
            headerRecord.setValid(false);
            return headerRecord;
        }
        br.readLine();
        String secondLine = br.readLine();
        if (!"=PARAMETER/UNIT".equals(secondLine.trim())) {
            headerRecord.setValid(false);
            return headerRecord;
        }
        String thirdLine = br.readLine();
        if (thirdLine.trim().toUpperCase().startsWith("#position=".toUpperCase()) && (split = thirdLine.split("=")).length == 2) {
            try {
                int position = Integer.parseInt(split[1]);
                headerRecord.setOverwritePriority(position);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return headerRecord;
    }

    protected final void logOnce(String logMessage) {
        if (!LOG_ONCE.contains(logMessage)) {
            LOG_ONCE.add(logMessage);
            this.getLogger().log(Level.INFO, logMessage);
        }
    }

    @Override
    public final boolean validate() {
        boolean isValid = false;
        if (this.isEnabled()) {
            try (BufferedReader br = this.getBufferedReader();){
                HeaderRecord readHeader = this.readHeader(br);
                isValid = readHeader.isValid();
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Error reading parameter resource file input stream", ioe);
            }
        }
        return isValid;
    }

    protected int getOverwritePriority(int defaultValue) {
        int priority = defaultValue;
        try (BufferedReader br = this.getBufferedReader();){
            HeaderRecord readHeader = this.readHeader(br);
            if (readHeader.isValid() && readHeader.getOverwritePriority() != null) {
                Integer overwritePriority = readHeader.getOverwritePriority();
                priority = overwritePriority;
            }
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Error reading parameter resource file input stream", ioe);
        }
        return priority;
    }

    protected abstract BufferedReader getBufferedReader() throws IOException;

    protected abstract Logger getLogger();

    protected static class HeaderRecord {
        private boolean _isValid = true;
        private Integer _overwritePriority = null;

        protected HeaderRecord() {
        }

        public Integer getOverwritePriority() {
            return this._overwritePriority;
        }

        public void setOverwritePriority(Integer overwritePriority) {
            this._overwritePriority = overwritePriority;
        }

        public boolean isValid() {
            return this._isValid;
        }

        public void setValid(boolean isValid) {
            this._isValid = isValid;
        }
    }
}

