/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.resourceservices;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.resourceservices.ParameterLoader;
import mil.army.usace.hec.metadata.resourceservices.ParameterResourceReader;
import rma.services.annotations.ServiceProvider;

@ServiceProvider(path="hec/data/Parameter", position=1000, service=ParameterLoader.class)
public final class ResourceFileParameterLoader
extends ParameterResourceReader {
    private static final Logger LOGGER = Logger.getLogger(ResourceFileParameterLoader.class.getName());

    public ResourceFileParameterLoader() {
        LOGGER.log(Level.FINEST, "Empty default ctor for service lookup");
    }

    @Override
    public int getOverwritePriority() {
        return super.getOverwritePriority(1000);
    }

    @Override
    protected BufferedReader getBufferedReader() throws IOException {
        String propertyKey = "DataSetValidParameterListFile";
        Object fileName = System.getProperty(propertyKey);
        if (fileName == null) {
            LOGGER.log(Level.CONFIG, () -> "Property key: " + propertyKey + " not set. Checking CWMS_HOME");
            String home = System.getProperty("CWMS_HOME");
            if (home != null) {
                fileName = home + "/config/db/definitions/parameters_units.def";
                LOGGER.log(Level.CONFIG, "CWMS_HOME is set to: {0}. Reading parameters file from: {1}", new Object[]{home, fileName});
            } else {
                LOGGER.log(Level.CONFIG, () -> "CWMS_HOME is not set");
            }
        } else {
            LOGGER.log(Level.CONFIG, "Property key: {0} set to: {1}", new Object[]{propertyKey, fileName});
        }
        BufferedReader br = null;
        if (fileName == null) {
            LOGGER.log(Level.CONFIG, "Could not load model parameters resource file from file system. Neither CWMS_HOME nor the system property {0} was defined.", new Object[]{propertyKey});
        } else if (!Files.exists(Paths.get((String)fileName, new String[0]), new LinkOption[0])) {
            LOGGER.log(Level.CONFIG, "Could not find the model parameters resource file from the file system at location: {0}", new Object[]{fileName});
        } else {
            this.logOnce(MessageFormat.format("Reading parameter resource file from file system: {0}", fileName));
            br = new BufferedReader(new FileReader((String)fileName));
        }
        return br;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

