/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.timeseries;

import java.time.Instant;
import java.time.ZoneId;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import mil.army.usace.hec.metadata.Duration;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.LocationID;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.Parameter;
import mil.army.usace.hec.metadata.ParameterType;
import mil.army.usace.hec.metadata.Version;
import mil.army.usace.hec.metadata.location.LocationTemplate;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import rma.util.lookup.Lookup;
import rma.util.lookup.Lookups;

public abstract class AbstractTimeSeriesIdentifier
implements TimeSeriesIdentifier {
    private static final long serialVersionUID = 7486397734803491575L;
    private final OfficeId _officeId;
    private final LocationID _locationID;
    private final Parameter _parameter;
    private final ParameterType _parameterType;
    private final Interval _interval;
    private final Duration _duration;
    private final Version _version;
    private final boolean _active;
    private final int _userPrivilege;
    private Lookup _lookup = null;

    protected AbstractTimeSeriesIdentifier(OfficeId officeId, LocationID locationID, Parameter parameter, ParameterType parameterType, Interval interval, Duration duration, Version version, boolean active, int userPrivilege) {
        this._officeId = officeId;
        this._locationID = locationID;
        this._parameter = parameter;
        this._parameterType = parameterType;
        this._interval = interval;
        this._duration = duration;
        this._version = version;
        this._active = active;
        this._userPrivilege = userPrivilege;
    }

    @Override
    public final int getUserPrivilege() {
        return this._userPrivilege;
    }

    @Override
    public final boolean getActive() {
        return this._active;
    }

    @Override
    public LocationID getLocationId() {
        return this._locationID;
    }

    @Override
    public Duration getDuration() {
        return this._duration;
    }

    @Override
    public final synchronized Lookup getLookup() {
        if (this._lookup == null) {
            this._lookup = Lookups.fixed((Object[])new Object[]{this, new TimeSeriesIdentifierComparator()});
        }
        return this._lookup;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTimeSeriesIdentifier that = (AbstractTimeSeriesIdentifier)obj;
        return Objects.equals(this.getOfficeId(), that.getOfficeId()) && Objects.equals(this.getLocationId(), that.getLocationId()) && Objects.equals(this.getParameter(), that.getParameter()) && Objects.equals(this.getParameterType(), that.getParameterType()) && Objects.equals(this.getVersion(), that.getVersion()) && Objects.equals(this.getInterval(), that.getInterval()) && Objects.equals(this.getDuration(), that.getDuration());
    }

    public final int hashCode() {
        return Objects.hash(this.getOfficeId(), this.getLocationId(), this.getParameter(), this.getParameterType(), this.getVersion(), this.getInterval(), this.getDuration());
    }

    @Override
    public final boolean describesSameDataAs(TimeSeriesIdentifier descriptionTx) {
        return this.getParameter().getBaseParameter().equals(descriptionTx.getParameter().getBaseParameter()) && this.getParameterType().equals(descriptionTx.getParameterType()) && this.describesSameDataAs(descriptionTx.getInterval()) && this.getDuration().equals(descriptionTx.getDuration()) && this.doesIntervalOffsetMatch(descriptionTx);
    }

    @Override
    public final boolean describesSameDataAs(Interval interval) {
        return this.getInterval().equals(interval) || this.getInterval().isIrregular() && interval.isIrregular();
    }

    abstract boolean doesIntervalOffsetMatch(TimeSeriesIdentifier var1);

    @Override
    public final Optional<OfficeId> getOfficeId() {
        return Optional.ofNullable(this._officeId);
    }

    @Override
    public final LocationTemplate getLocationRef() {
        return new LocationTemplate(this.getOfficeId().map(OfficeId::getOfficeId).orElse(""), this._locationID.getLocation());
    }

    @Override
    public final Parameter getParameter() {
        return this._parameter;
    }

    @Override
    public final Version getVersion() {
        return this._version;
    }

    @Override
    public final ParameterType getParameterType() {
        return this._parameterType;
    }

    public final String toString() {
        String delim = ".";
        char[] emptyChar = new char[]{'\u0000'};
        String empty = new String(emptyChar);
        StringBuilder buf = new StringBuilder();
        if (this._locationID != null) {
            buf.append(this._locationID.toString());
        } else {
            buf.append(empty);
        }
        buf.append(delim);
        if (this._parameter != null) {
            buf.append(this._parameter.toString());
        } else {
            buf.append(empty);
        }
        buf.append(delim);
        if (this._parameterType != null) {
            buf.append(this._parameterType.toString());
        } else {
            buf.append(empty);
        }
        buf.append(delim);
        if (this.getInterval() != null) {
            buf.append(this.getInterval().toString());
        } else {
            buf.append(empty);
        }
        buf.append(delim);
        if (this.getDuration() != null) {
            buf.append(this.getDuration().toString());
        } else {
            buf.append(empty);
        }
        buf.append(delim);
        if (this._version != null) {
            buf.append(this._version.toString());
        } else {
            buf.append(empty);
        }
        return buf.toString();
    }

    @Override
    public final String getTimeSeriesId() {
        return this.toString();
    }

    @Override
    public Interval getInterval() {
        return this._interval;
    }

    @Override
    public final boolean isOnInterval(Instant instant) {
        boolean retval = false;
        Optional<ZoneId> intervalZoneId = this.getIntervalZoneId();
        if (intervalZoneId.isPresent()) {
            Interval interval = this.getInterval();
            IntervalOffset offset = this.getIntervalOffset();
            retval = interval.isOnInterval(instant, offset, intervalZoneId.get());
        }
        return retval;
    }

    public static class TimeSeriesIdentifierComparator
    implements Comparator<TimeSeriesIdentifier> {
        @Override
        public int compare(TimeSeriesIdentifier o1, TimeSeriesIdentifier o2) {
            return Comparator.nullsLast(Comparator.comparing(Object::toString, String::compareToIgnoreCase)).compare(o1, o2);
        }
    }
}

