/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.timeseries;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Duration;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.LocationID;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.Parameter;
import mil.army.usace.hec.metadata.ParameterType;
import mil.army.usace.hec.metadata.Version;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.timeseries.AbstractTimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;

public class LocalRegularTimeSeriesIdentifier
extends AbstractTimeSeriesIdentifier {
    public static final String TIME_SERIES_LOOKUP = "hec/metadata/timeseries/localregular";
    private static final long serialVersionUID = 2781301995320927635L;
    private static final Logger LOGGER = Logger.getLogger(LocalRegularTimeSeriesIdentifier.class.getName());
    private IntervalOffset _intervalOffset;

    LocalRegularTimeSeriesIdentifier(OfficeId officeId, LocationID locationID, Parameter parameter, ParameterType parameterType, Interval interval, Duration duration, Version version, IntervalOffset intervalOffset, boolean active, int userPrivilege) {
        super(officeId, locationID, parameter, parameterType, interval, duration, version, active, userPrivilege);
        this._intervalOffset = intervalOffset != null ? intervalOffset : IntervalOffset.undefinedOffset();
    }

    @Override
    boolean doesIntervalOffsetMatch(TimeSeriesIdentifier descriptionTx) {
        boolean retval = false;
        if (descriptionTx instanceof LocalRegularTimeSeriesIdentifier) {
            retval = Objects.equals(this.getIntervalOffset(), descriptionTx.getIntervalOffset());
        }
        return retval;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocalRegularTimeSeriesIdentifier that = (LocalRegularTimeSeriesIdentifier)o;
        return Objects.equals(this._intervalOffset, that._intervalOffset) || this._intervalOffset.isUndefined() || that._intervalOffset.isUndefined();
    }

    @Override
    public IntervalOffset getIntervalOffset() {
        return this._intervalOffset;
    }

    @Override
    public Optional<ZoneId> getIntervalZoneId() {
        return this.getLocationId().getZoneId();
    }

    @Override
    public void updateUndefinedIntervalOffsetWithStartTime(Instant firstTime) throws DataSetIllegalArgumentException {
        if (this.getIntervalOffset().isUndefined() && !NumericalConstants.UNDEFINED_INSTANT.equals(firstTime)) {
            int intervalOffsetFromBaseSec;
            long startMillis = firstTime.toEpochMilli();
            ZoneId zoneId = this.getIntervalZoneId().orElseThrow(() -> new DataSetIllegalArgumentException("Unable to calculate interval offset without a time zone"));
            long timeAtTopInterval = this.getInterval().getTimeOnPreviousOrCurrentInterval(startMillis, null, TimeZone.getTimeZone(zoneId));
            ZonedDateTime firstZonedDateTime = firstTime.atZone(zoneId);
            ZonedDateTime previousInterval = Instant.ofEpochMilli(timeAtTopInterval).atZone(zoneId);
            if (firstZonedDateTime.getOffset().getTotalSeconds() != previousInterval.getOffset().getTotalSeconds()) {
                int yearDiff = firstZonedDateTime.getYear() - previousInterval.getYear();
                int monthDiff = firstZonedDateTime.getMonthValue() - previousInterval.getMonthValue();
                int dayDiff = firstZonedDateTime.getDayOfMonth() - previousInterval.getDayOfMonth();
                int hourDiff = firstZonedDateTime.getHour() - previousInterval.getHour();
                int minuteDiff = firstZonedDateTime.getMinute() - previousInterval.getMinute();
                int secondDiff = firstZonedDateTime.getSecond() - previousInterval.getSecond();
                String offset = yearDiff + "Y" + monthDiff + "M" + dayDiff + "D" + hourDiff + "H" + minuteDiff + "m" + secondDiff + "S";
                intervalOffsetFromBaseSec = -1 * IntervalOffset.fromString(offset).getOffsetSeconds();
            } else {
                intervalOffsetFromBaseSec = (int)ChronoUnit.SECONDS.between(firstZonedDateTime, previousInterval);
            }
            IntervalOffset newOffset = IntervalOffset.fromSeconds(intervalOffsetFromBaseSec);
            this.getInterval().validateOffset(newOffset);
            this._intervalOffset = newOffset;
        }
    }

    @Override
    public String getTimeSeriesLookupPath() {
        return TIME_SERIES_LOOKUP;
    }
}

