/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.timeseries;

import java.time.Instant;
import java.time.ZoneId;
import java.util.Optional;
import mil.army.usace.hec.metadata.Duration;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.LocationID;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.Parameter;
import mil.army.usace.hec.metadata.ParameterType;
import mil.army.usace.hec.metadata.Version;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.timeseries.AbstractTimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;

public class PseudoRegularTimeSeriesIdentifier
extends AbstractTimeSeriesIdentifier {
    public static final String TIME_SERIES_LOOKUP = "hec/metadata/timeseries/pseudoregular";
    private static final long serialVersionUID = 1210779286563122951L;

    PseudoRegularTimeSeriesIdentifier(OfficeId officeId, LocationID locationID, Parameter parameter, ParameterType parameterType, Interval interval, Duration duration, Version version, boolean active, int userPrivilege) {
        super(officeId, locationID, parameter, parameterType, interval, duration, version, active, userPrivilege);
    }

    @Override
    boolean doesIntervalOffsetMatch(TimeSeriesIdentifier descriptionTx) {
        return IntervalOffset.isNoOffset(descriptionTx.getIntervalOffset().getOffsetSeconds());
    }

    @Override
    public Optional<ZoneId> getIntervalZoneId() {
        return Optional.of(NumericalConstants.UTC_ZONEID);
    }

    @Override
    public void updateUndefinedIntervalOffsetWithStartTime(Instant firstTime) {
    }

    @Override
    public String getTimeSeriesLookupPath() {
        return TIME_SERIES_LOOKUP;
    }

    @Override
    public IntervalOffset getIntervalOffset() {
        return IntervalOffset.noOffset();
    }
}

