/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.timeseries;

import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Duration;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.LocationID;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.Parameter;
import mil.army.usace.hec.metadata.ParameterType;
import mil.army.usace.hec.metadata.Version;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.timeseries.AbstractTimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.IntervalOffsetMismatchException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;

public class RegularTimeSeriesIdentifier
extends AbstractTimeSeriesIdentifier {
    public static final String TIME_SERIES_LOOKUP = "hec/metadata/timeseries/regular";
    private static final long serialVersionUID = -7970631623579863796L;
    private static final Logger LOGGER = Logger.getLogger(RegularTimeSeriesIdentifier.class.getName());
    private IntervalOffset _intervalOffset = IntervalOffset.undefinedOffset();

    RegularTimeSeriesIdentifier(OfficeId officeId, LocationID locationID, Parameter parameter, ParameterType parameterType, Interval interval, Duration duration, Version version, IntervalOffset intervalOffset, boolean active, int userPrivilege) {
        super(officeId, locationID, parameter, parameterType, interval, duration, version, active, userPrivilege);
        this._intervalOffset = intervalOffset != null ? intervalOffset : IntervalOffset.undefinedOffset();
    }

    @Override
    boolean doesIntervalOffsetMatch(TimeSeriesIdentifier descriptionTx) {
        boolean retval = false;
        if (descriptionTx instanceof RegularTimeSeriesIdentifier) {
            retval = Objects.equals(this._intervalOffset, ((RegularTimeSeriesIdentifier)descriptionTx)._intervalOffset) || this._intervalOffset.isUndefined() || ((RegularTimeSeriesIdentifier)descriptionTx)._intervalOffset.isUndefined();
        }
        return retval;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegularTimeSeriesIdentifier that = (RegularTimeSeriesIdentifier)o;
        return Objects.equals(this._intervalOffset, that._intervalOffset) || this._intervalOffset.isUndefined() || that._intervalOffset.isUndefined();
    }

    public void checkUtcIntervalOffset(long time) throws IntervalOffsetMismatchException {
        int utcIntervalOffsetSeconds = this._intervalOffset.getOffsetSeconds();
        if (time != Long.MIN_VALUE && !IntervalOffset.isDefined(utcIntervalOffsetSeconds)) {
            long topOfInterval;
            long utcIntervalOffsetMillis = (long)utcIntervalOffsetSeconds * 1000L;
            long offsetStartTime = time - utcIntervalOffsetMillis;
            try {
                topOfInterval = this.getInterval().getTimeOnPreviousOrCurrentInterval(offsetStartTime, null, NumericalConstants.UTC_TZ);
            }
            catch (DataSetIllegalArgumentException e) {
                throw new IntervalOffsetMismatchException(e);
            }
            if (topOfInterval != offsetStartTime) {
                String strTime = NumericalConstants.sdfFULL().format(new Date(time));
                try {
                    topOfInterval = this.getInterval().getTimeOnPreviousOrCurrentInterval(time, null, NumericalConstants.UTC_TZ);
                }
                catch (DataSetIllegalArgumentException e) {
                    throw new IntervalOffsetMismatchException(e);
                }
                int startTimeOffset = (int)((time - topOfInterval) / 1000L);
                String strIncomingIntervalUtcOffset = IntervalOffset.getIntervalOffsetString(startTimeOffset);
                String strIntervalUtcOffset = this._intervalOffset.getIntervalOffsetString();
                String strInterval = this.getInterval().toString();
                String sb = "Time " + strTime + " has interval UTC offset of " + strIncomingIntervalUtcOffset + " for interval " + strInterval + " that does not match expected interval UTC offset of " + strIntervalUtcOffset;
                throw new IntervalOffsetMismatchException(sb);
            }
        }
    }

    private void setUtcIntervalOffset(int offset) throws DataSetIllegalArgumentException {
        IntervalOffset newOffset = IntervalOffset.fromSeconds(offset);
        this.getInterval().validateOffset(newOffset);
        this._intervalOffset = newOffset;
    }

    @Override
    public IntervalOffset getIntervalOffset() {
        return this._intervalOffset;
    }

    @Override
    public Optional<ZoneId> getIntervalZoneId() {
        return Optional.of(NumericalConstants.UTC_ZONEID);
    }

    @Override
    public void updateUndefinedIntervalOffsetWithStartTime(Instant firstTime) throws DataSetIllegalArgumentException {
        if (this._intervalOffset.isUndefined() && !NumericalConstants.UNDEFINED_INSTANT.equals(firstTime)) {
            long startMillis = firstTime.toEpochMilli();
            long timeAtTopInterval = this.getInterval().getTimeOnPreviousOrCurrentInterval(startMillis, null, NumericalConstants.UTC_TZ);
            int intervalOffsetFromUTCBaseSec = (int)((startMillis - timeAtTopInterval) / 1000L);
            this.setUtcIntervalOffset(intervalOffsetFromUTCBaseSec);
        }
    }

    @Override
    public String getTimeSeriesLookupPath() {
        return TIME_SERIES_LOOKUP;
    }
}

