/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.timeseries;

import java.time.Instant;
import java.util.Comparator;
import java.util.Objects;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public final class TimeSeriesExtent
implements Comparable<TimeSeriesExtent> {
    private static final Comparator<TimeSeriesExtent> DEFAULT_COMPARATOR = Comparator.comparing(TimeSeriesExtent::getVersionDate).reversed();
    private final Instant _start;
    private final Instant _end;
    private final Instant _version;
    private final Instant _lastUpdate;

    public TimeSeriesExtent(Instant start, Instant end, Instant version, Instant lastUpdate) {
        this._start = Objects.requireNonNull(start, "start must not be null");
        this._end = Objects.requireNonNull(end, "end must not be null");
        this._version = Objects.requireNonNull(version, "version must not be null");
        this._lastUpdate = Objects.requireNonNull(lastUpdate, "update must not be null");
    }

    public Instant getLastUpdate() {
        return this._lastUpdate;
    }

    public boolean isNotVersioned() {
        return NumericalConstants.isNotVersioned(this._version);
    }

    public Instant getVersionDate() {
        return this._version;
    }

    public Instant getStartDate() {
        return this._start;
    }

    public Instant getEndDate() {
        return this._end;
    }

    @Override
    public int compareTo(TimeSeriesExtent o) {
        return DEFAULT_COMPARATOR.compare(this, o);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeSeriesExtent other = (TimeSeriesExtent)obj;
        return this._end.equals(other._end) && this._start.equals(other._start) && this._lastUpdate.equals(other._lastUpdate) && this._version.equals(other._version);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._end.hashCode();
        result = 31 * result + this._start.hashCode();
        result = 31 * result + this._lastUpdate.hashCode();
        result = 31 * result + this._version.hashCode();
        return result;
    }
}

