/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.timeseries;

import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Duration;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.LocationID;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.Parameter;
import mil.army.usace.hec.metadata.ParameterType;
import mil.army.usace.hec.metadata.Version;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierFactory;

public final class TimeSeriesIdentifierBuilder {
    private OfficeId _officeId;
    private LocationID _locationID;
    private Parameter _parameter;
    private ParameterType _parameterType;
    private Interval _interval;
    private Duration _duration;
    private Version _version;
    private IntervalOffset _intervalOffset;
    private boolean _active;
    private int _userPrivilege;

    public TimeSeriesIdentifierBuilder(TimeSeriesIdentifier original) {
        this._officeId = original.getOfficeId().orElse(null);
        this._locationID = original.getLocationId();
        this._parameter = original.getParameter();
        this._parameterType = original.getParameterType();
        this._interval = original.getInterval();
        this._duration = original.getDuration();
        this._version = original.getVersion();
        this._intervalOffset = original.getIntervalOffset();
        this._active = original.getActive();
        this._userPrivilege = original.getUserPrivilege();
    }

    public TimeSeriesIdentifierBuilder withOfficeId(OfficeId officeId) {
        this._officeId = officeId;
        return this;
    }

    public TimeSeriesIdentifierBuilder withLocationId(LocationID locationID) {
        this._locationID = locationID;
        return this;
    }

    public TimeSeriesIdentifierBuilder withParameter(Parameter parameter) {
        this._parameter = parameter;
        return this;
    }

    public TimeSeriesIdentifierBuilder withParameterType(ParameterType parameterType) {
        this._parameterType = parameterType;
        return this;
    }

    public TimeSeriesIdentifierBuilder withInterval(Interval interval) {
        this._interval = interval;
        return this;
    }

    public TimeSeriesIdentifierBuilder withDuration(Duration duration) {
        this._duration = duration;
        return this;
    }

    public TimeSeriesIdentifierBuilder withVersion(Version version) {
        this._version = version;
        return this;
    }

    public TimeSeriesIdentifierBuilder withIntervalOffset(IntervalOffset intervalOffset) {
        this._intervalOffset = intervalOffset;
        return this;
    }

    public TimeSeriesIdentifierBuilder withActive(boolean active) {
        this._active = active;
        return this;
    }

    public TimeSeriesIdentifierBuilder withUserPrivilege(int userPrivilege) {
        this._userPrivilege = userPrivilege;
        return this;
    }

    public TimeSeriesIdentifier build() throws DataSetIllegalArgumentException {
        return TimeSeriesIdentifierFactory.from(this._officeId, this._locationID, this._parameter, this._parameterType, this._interval, this._duration, this._version, this._intervalOffset, this._active, this._userPrivilege);
    }
}

