/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.timeseries;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Predicate;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Duration;
import mil.army.usace.hec.metadata.DurationFactory;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalFactory;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.LocationID;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.Parameter;
import mil.army.usace.hec.metadata.ParameterType;
import mil.army.usace.hec.metadata.Version;
import mil.army.usace.hec.metadata.timeseries.AbstractTimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.IrregularTimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.LocalRegularTimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.PseudoRegularTimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.RegularTimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierParts;

public final class TimeSeriesIdentifierFactory {
    private TimeSeriesIdentifierFactory() {
        throw new AssertionError((Object)"Utility class");
    }

    public static TimeSeriesIdentifier from(OfficeId officeId, String identifier, ZoneId zoneId) throws DataSetIllegalArgumentException {
        return TimeSeriesIdentifierFactory.from(officeId, identifier, null, zoneId);
    }

    public static TimeSeriesIdentifier from(OfficeId officeId, String identifier, IntervalOffset intervalOffset, ZoneId zoneId) throws DataSetIllegalArgumentException {
        return TimeSeriesIdentifierFactory.from(officeId, identifier, intervalOffset, zoneId, true, 2);
    }

    public static TimeSeriesIdentifier from(OfficeId officeId, String identifier, IntervalOffset intervalOffset, ZoneId zoneId, boolean active, int userPrivilege) throws DataSetIllegalArgumentException {
        Map<TimeSeriesIdentifierParts, String> parse = TimeSeriesIdentifierParts.parse(identifier);
        ArrayList<DataSetIllegalArgumentException> errors = new ArrayList<DataSetIllegalArgumentException>();
        LocationID locationID = new LocationID(parse.get((Object)TimeSeriesIdentifierParts.LOCATION_ID), zoneId);
        if (locationID.getBaseLocation().length() == 0) {
            errors.add(new DataSetIllegalArgumentException("  Base Location ID string is empty."));
        }
        Parameter parameter = null;
        try {
            parameter = new Parameter(parse.get((Object)TimeSeriesIdentifierParts.PARAMETER));
        }
        catch (DataSetIllegalArgumentException e) {
            errors.add(e);
        }
        ParameterType parameterType = null;
        try {
            parameterType = ParameterType.from(parse.get((Object)TimeSeriesIdentifierParts.PARAMETER_TYPE));
        }
        catch (DataSetIllegalArgumentException e) {
            errors.add(e);
        }
        Duration duration = null;
        try {
            String durationName = parse.get((Object)TimeSeriesIdentifierParts.DURATION);
            duration = DurationFactory.findAny(DurationFactory.equalsName(durationName)).orElseThrow(() -> new DataSetIllegalArgumentException("Interval not found in the standard set of durations: " + durationName));
        }
        catch (DataSetIllegalArgumentException e) {
            errors.add(e);
        }
        Version version = new Version(parse.get((Object)TimeSeriesIdentifierParts.VERSION));
        if (version.getVersion() == null || version.getVersion().isEmpty()) {
            errors.add(new DataSetIllegalArgumentException("Time series identifier cannot have an empty version"));
        }
        String intervalPart = parse.get((Object)TimeSeriesIdentifierParts.INTERVAL);
        if (intervalOffset == null) {
            intervalOffset = IntervalFactory.findAny(IntervalFactory.equalsName(intervalPart).and(IntervalFactory.isIrregular().negate())).isPresent() ? IntervalOffset.undefinedOffset() : IntervalOffset.noOffset();
        }
        Interval interval = null;
        try {
            Predicate<Interval> intervalFilter = IntervalFactory.equalsName(intervalPart);
            intervalFilter = intervalOffset.isNoOffset() ? intervalFilter.and(IntervalFactory.isIrregular()) : intervalFilter.and(IntervalFactory.isIrregular().negate());
            interval = IntervalFactory.findAny(intervalFilter).orElseThrow(() -> new DataSetIllegalArgumentException("Interval not found in the standard set of intervals: " + intervalPart));
        }
        catch (DataSetIllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            String msg = "Time Series Identifier is not valid:\n\"" + identifier + "\" ";
            throw new DataSetIllegalArgumentException(msg, errors);
        }
        return TimeSeriesIdentifierFactory.from(officeId, locationID, parameter, parameterType, interval, duration, version, intervalOffset, active, userPrivilege);
    }

    public static TimeSeriesIdentifier from(OfficeId officeId, LocationID locationID, Parameter parameter, ParameterType parameterType, Interval interval, Duration duration, Version version) throws DataSetIllegalArgumentException {
        return TimeSeriesIdentifierFactory.from(officeId, locationID, parameter, parameterType, interval, duration, version, null);
    }

    public static TimeSeriesIdentifier from(OfficeId officeId, LocationID locationID, Parameter parameter, ParameterType parameterType, Interval interval, Duration duration, Version version, IntervalOffset intervalOffset) throws DataSetIllegalArgumentException {
        return TimeSeriesIdentifierFactory.from(officeId, locationID, parameter, parameterType, interval, duration, version, intervalOffset, true, 2);
    }

    public static TimeSeriesIdentifier from(OfficeId officeId, LocationID locationID, Parameter parameter, ParameterType parameterType, Interval interval, Duration duration, Version version, IntervalOffset intervalOffset, boolean active, int userPrivilege) throws DataSetIllegalArgumentException {
        if (intervalOffset != null) {
            interval.validateOffset(intervalOffset);
        }
        AbstractTimeSeriesIdentifier retval = IntervalFactory.irregular().equals(interval) ? new IrregularTimeSeriesIdentifier(officeId, locationID, parameter, parameterType, duration, version, active, userPrivilege) : (interval.isIrregular() ? new PseudoRegularTimeSeriesIdentifier(officeId, locationID, parameter, parameterType, interval, duration, version, active, userPrivilege) : (interval.isRegular() ? new RegularTimeSeriesIdentifier(officeId, locationID, parameter, parameterType, interval, duration, version, intervalOffset, active, userPrivilege) : new LocalRegularTimeSeriesIdentifier(officeId, locationID, parameter, parameterType, interval, duration, version, intervalOffset, active, userPrivilege)));
        return retval;
    }

    public static TimeSeriesIdentifier from(LocationID locationID, Parameter parameter, ParameterType parameterType, Interval interval, Duration duration, Version version) throws DataSetIllegalArgumentException {
        return TimeSeriesIdentifierFactory.from(null, locationID, parameter, parameterType, interval, duration, version);
    }

    public static TimeSeriesIdentifier fromBinary(OfficeId officeId, LocationID locationID, ParameterType parameterType, Interval interval, Duration duration, Version version, IntervalOffset intervalOffset) throws DataSetIllegalArgumentException {
        Parameter binary = new Parameter("Binary");
        return TimeSeriesIdentifierFactory.from(officeId, locationID, binary, parameterType, interval, duration, version, intervalOffset, true, 2);
    }

    public static TimeSeriesIdentifier fromBinary(OfficeId officeId, LocationID locationID, String subParameter, ParameterType parameterType, Interval interval, Duration duration, Version version, IntervalOffset intervalOffset) throws DataSetIllegalArgumentException {
        Parameter binary = new Parameter("Binary", subParameter);
        return TimeSeriesIdentifierFactory.from(officeId, locationID, binary, parameterType, interval, duration, version, intervalOffset, true, 2);
    }

    public static TimeSeriesIdentifier fromText(OfficeId officeId, LocationID locationID, ParameterType parameterType, Interval interval, Duration duration, Version version, IntervalOffset intervalOffset) throws DataSetIllegalArgumentException {
        Parameter binary = new Parameter("Text");
        return TimeSeriesIdentifierFactory.from(officeId, locationID, binary, parameterType, interval, duration, version, intervalOffset, true, 2);
    }

    public static TimeSeriesIdentifier fromText(OfficeId officeId, LocationID locationID, String subParameter, ParameterType parameterType, Interval interval, Duration duration, Version version, IntervalOffset intervalOffset) throws DataSetIllegalArgumentException {
        Parameter binary = new Parameter("Text", subParameter);
        return TimeSeriesIdentifierFactory.from(officeId, locationID, binary, parameterType, interval, duration, version, intervalOffset, true, 2);
    }
}

