/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.timeseries;

import java.util.EnumMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Duration;
import mil.army.usace.hec.metadata.DurationFactory;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalFactory;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.Parameter;
import mil.army.usace.hec.metadata.ParameterType;
import mil.army.usace.hec.metadata.Version;

public enum TimeSeriesIdentifierParts {
    LOCATION_ID,
    PARAMETER,
    PARAMETER_TYPE,
    INTERVAL,
    DURATION,
    VERSION;


    public static Map<TimeSeriesIdentifierParts, String> parse(String descriptionStr) throws DataSetIllegalArgumentException {
        EnumMap<TimeSeriesIdentifierParts, String> retval = new EnumMap<TimeSeriesIdentifierParts, String>(TimeSeriesIdentifierParts.class);
        String delim = ".";
        StringTokenizer st = new StringTokenizer(descriptionStr, delim);
        int countDescItems = st.countTokens();
        if (descriptionStr.endsWith(delim)) {
            ++countDescItems;
        }
        if (countDescItems != 6) {
            throw new DataSetIllegalArgumentException("Time Series Description is not valid:\n" + descriptionStr + "\n  " + countDescItems + " description items are present.\n  Six description items delimited by periods are required.");
        }
        String loc = "";
        if (st.hasMoreTokens()) {
            loc = st.nextToken();
        }
        String param = "";
        if (st.hasMoreTokens()) {
            param = st.nextToken();
        }
        String type = "";
        if (st.hasMoreTokens()) {
            type = st.nextToken();
        }
        String interv = "";
        if (st.hasMoreTokens()) {
            interv = st.nextToken();
        }
        String durat = "";
        if (st.hasMoreTokens()) {
            durat = st.nextToken();
        }
        String ver = "";
        if (st.hasMoreTokens()) {
            ver = st.nextToken();
        }
        retval.put(LOCATION_ID, loc);
        retval.put(PARAMETER, param);
        retval.put(PARAMETER_TYPE, type);
        retval.put(INTERVAL, interv);
        retval.put(DURATION, durat);
        retval.put(VERSION, ver);
        return retval;
    }

    public static String extractLocationId(String timeSeriesId) throws DataSetIllegalArgumentException {
        return TimeSeriesIdentifierParts.parse(timeSeriesId).get((Object)LOCATION_ID);
    }

    public static Parameter extractParameter(String timeSeriesId) throws DataSetIllegalArgumentException {
        return new Parameter(TimeSeriesIdentifierParts.parse(timeSeriesId).get((Object)PARAMETER));
    }

    public static ParameterType extractParameterType(String timeSeriesId) throws DataSetIllegalArgumentException {
        return ParameterType.from(TimeSeriesIdentifierParts.parse(timeSeriesId).get((Object)PARAMETER_TYPE));
    }

    public static Interval extractInterval(String timeSeriesId, IntervalOffset intervalOffset) throws DataSetIllegalArgumentException {
        String intervalName = TimeSeriesIdentifierParts.parse(timeSeriesId).get((Object)INTERVAL);
        Predicate<Interval> intervalFilter = IntervalFactory.equalsName(intervalName);
        intervalFilter = intervalOffset.isNoOffset() ? intervalFilter.and(IntervalFactory.isIrregular()) : intervalFilter.and(IntervalFactory.isIrregular().negate());
        return IntervalFactory.findAny(intervalFilter).orElseThrow(() -> new DataSetIllegalArgumentException("Interval not found in the standard set of intervals: " + intervalName + " with interval offset: " + intervalOffset));
    }

    public static Duration extractDuration(String timeSeriesId) throws DataSetIllegalArgumentException {
        String durationName = TimeSeriesIdentifierParts.parse(timeSeriesId).get((Object)DURATION);
        return DurationFactory.findAny(DurationFactory.equalsName(durationName)).orElseThrow(() -> new DataSetIllegalArgumentException("Interval not found in the standard set of durations: " + durationName));
    }

    public static Version extractVersion(String timeSeriesId) throws DataSetIllegalArgumentException {
        return new Version(TimeSeriesIdentifierParts.parse(timeSeriesId).get((Object)VERSION));
    }
}

