/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.web;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;

public final class MediaType {
    private static final Pattern MEDIA_TYPE_PATTERN = Pattern.compile("^([\\w\\d\\-]+)\\/([\\w\\d\\-\\+\\.]+)");
    private final String _type;
    private final String _subType;
    private static final String APPLICATION_TYPE = "application";
    private static final String TEXT_TYPE = "text";
    private static final String IMAGE_TYPE = "image";
    private static final String VIDEO_TYPE = "video";
    private static final String AUDIO_TYPE = "audio";
    private static final MediaType TEXT_PLAIN = new MediaType("text", "plain");
    private static final MediaType TEXT_HTML = new MediaType("text", "html");
    private static final MediaType TEXT_CSS = new MediaType("text", "css");
    private static final MediaType TEXT_JAVASCRIPT = new MediaType("text", "javascript");
    private static final MediaType APPLICATION_JSON = new MediaType("application", "json");
    private static final MediaType APPLICATION_XML = new MediaType("application", "xml");
    private static final MediaType IMAGE_JPEG = new MediaType("image", "jpeg");
    private static final MediaType IMAGE_PNG = new MediaType("image", "png");
    private static final MediaType IMAGE_GIF = new MediaType("image", "gif");
    private static final MediaType VIDEO_MPEG = new MediaType("video", "mpeg");
    private static final MediaType AUDIO_MPEG = new MediaType("audio", "mpeg");
    private static final MediaType APPLICATION_PDF = new MediaType("application", "pdf");
    private static final MediaType APPLICATION_MSWORD = new MediaType("application", "msword");
    private static final MediaType APPLICATION_VND_MSEXCEL = new MediaType("application", "vnd.ms-excel");
    private static final MediaType APPLICATION_ZIP = new MediaType("application", "zip");
    private static final MediaType APPLICATION_OCTET_STREAM = new MediaType("application", "octet-stream");
    private static final MediaType MULTIPART_FORM_DATA = new MediaType("multipart", "form-data");

    private MediaType() {
        this("*", "*");
    }

    private MediaType(String type, String subtype) {
        this._type = type;
        this._subType = subtype;
    }

    public String getType() {
        return this._type;
    }

    public String getSubType() {
        return this._subType;
    }

    public String toString() {
        return this._type + "/" + this._subType;
    }

    public static MediaType parse(String type) throws DataSetIllegalArgumentException {
        if (type == null || type.isBlank()) {
            throw new DataSetIllegalArgumentException("Cannot create media type from a null or empty string");
        }
        Matcher matcher = MEDIA_TYPE_PATTERN.matcher(type);
        if (!matcher.find()) {
            throw new DataSetIllegalArgumentException(String.format("Media Type: %s does not match pattern: %s", type, MEDIA_TYPE_PATTERN.pattern()));
        }
        return new MediaType(matcher.group(1).toLowerCase(), matcher.group(2).toLowerCase());
    }

    public static MediaType textPlain() {
        return TEXT_PLAIN;
    }

    public static MediaType textHtml() {
        return TEXT_HTML;
    }

    public static MediaType textCss() {
        return TEXT_CSS;
    }

    public static MediaType textJavascript() {
        return TEXT_JAVASCRIPT;
    }

    public static MediaType applicationJson() {
        return APPLICATION_JSON;
    }

    public static MediaType applicationXml() {
        return APPLICATION_XML;
    }

    public static MediaType imageJpeg() {
        return IMAGE_JPEG;
    }

    public static MediaType imagePng() {
        return IMAGE_PNG;
    }

    public static MediaType imageGif() {
        return IMAGE_GIF;
    }

    public static MediaType videoMpeg() {
        return VIDEO_MPEG;
    }

    public static MediaType audioMpeg() {
        return AUDIO_MPEG;
    }

    public static MediaType applicationPdf() {
        return APPLICATION_PDF;
    }

    public static MediaType applicationMsword() {
        return APPLICATION_MSWORD;
    }

    public static MediaType applicationVndMsexcel() {
        return APPLICATION_VND_MSEXCEL;
    }

    public static MediaType applicationZip() {
        return APPLICATION_ZIP;
    }

    public static MediaType applicationOctetStream() {
        return APPLICATION_OCTET_STREAM;
    }

    public static MediaType multipartFormData() {
        return MULTIPART_FORM_DATA;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaType mediaType = (MediaType)o;
        return Objects.equals(this._type, mediaType._type) && Objects.equals(this._subType, mediaType._subType);
    }

    public int hashCode() {
        return Objects.hash(this._type, this._subType);
    }
}

