/*
 * Decompiled with CFR 0.152.
 */
package com.rma.geojson;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.rma.geojson.Feature;
import com.rma.geojson.GeoJsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@JsonPropertyOrder(value={"type", "features"})
public class FeatureCollection<T extends Feature>
extends GeoJsonObject
implements Iterable<T> {
    private static final long serialVersionUID = 1L;
    private final String type = "FeatureCollection";
    @JsonProperty(value="features")
    private List<T> features = new ArrayList<T>();

    public FeatureCollection() {
    }

    public FeatureCollection(T feature) {
        this.addFeature(feature);
    }

    public FeatureCollection(Collection<T> features) {
        this.setFeatures(features);
    }

    public List<T> getFeatures() {
        return this.features;
    }

    public List<T> getFeatures(Predicate<T> query) {
        return this.features.stream().filter(query).collect(Collectors.toList());
    }

    public void setFeatures(Collection<T> features) {
        this.features = new ArrayList<T>(features);
    }

    public void addFeature(T feature) {
        this.features.add(feature);
    }

    public void removeFeature(T feature) {
        this.features.remove(feature);
    }

    public void addFeatures(Collection<T> features) {
        this.features.addAll(features);
    }

    public int numFeatures() {
        return this.features.size();
    }

    public T getFeature(int i) {
        return (T)((Feature)this.features.get(i));
    }

    @Override
    public String getType() {
        return "FeatureCollection";
    }

    @Override
    public Iterator<T> iterator() {
        return this.features.iterator();
    }
}

