/*
 * Decompiled with CFR 0.152.
 */
package usace.loading.gui.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import usace.loading.gui.prefs.Constants;
import usace.loading.gui.ui.SpinningLoadingGui;

public abstract class LoadingGuiOptionsPanel
extends JPanel {
    private final Preferences _prefs;
    private Color _bgColor;
    private Color _fgColor;
    private Color _indicatorColor;
    public static final String MODIFIED = "Modified";
    private JButton btnBackground;
    private JButton btnDefault;
    private JButton btnForeground;
    private JButton btnIndicator;
    private JPanel jPanel2;
    private JPanel pnlSample;

    public LoadingGuiOptionsPanel() {
        this(Preferences.userRoot());
    }

    public LoadingGuiOptionsPanel(Preferences prefs) {
        this._prefs = prefs;
        this.initComponents();
        this.initColors();
        this.initExample();
    }

    private void initColors() {
        this._bgColor = this.getGuiBackgroundColor();
        this._fgColor = this.getGuiForegroundColor();
        this._indicatorColor = this.getGuiIndicatorColor();
        this.updateButtonColors();
    }

    private Color getGuiBackgroundColor() {
        return Constants.getBgColor(this._prefs);
    }

    private Color getGuiForegroundColor() {
        return Constants.getFgColor(this._prefs);
    }

    private Color getGuiIndicatorColor() {
        return Constants.getIndicatorColor(this._prefs);
    }

    public final void save() {
        Constants.setBgColor(this._prefs, this._bgColor);
        Constants.setFgColor(this._prefs, this._fgColor);
        Constants.setIndicatorColor(this._prefs, this._indicatorColor);
    }

    private void initComponents() {
        this.pnlSample = new JPanel();
        this.jPanel2 = new JPanel();
        this.btnForeground = new JButton();
        this.btnBackground = new JButton();
        this.btnDefault = new JButton();
        this.btnIndicator = new JButton();
        this.pnlSample.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.btnForeground.setText("Text");
        this.btnForeground.setHorizontalAlignment(2);
        this.btnForeground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadingGuiOptionsPanel.this.btnForegroundActionPerformed(evt);
            }
        });
        this.btnBackground.setText("Background");
        this.btnBackground.setHorizontalAlignment(2);
        this.btnBackground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadingGuiOptionsPanel.this.btnBackgroundActionPerformed(evt);
            }
        });
        this.btnDefault.setText("Use Defaults");
        this.btnDefault.setHorizontalAlignment(2);
        this.btnDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadingGuiOptionsPanel.this.btnDefaultActionPerformed(evt);
            }
        });
        this.btnIndicator.setText("Indicator");
        this.btnIndicator.setHorizontalAlignment(2);
        this.btnIndicator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadingGuiOptionsPanel.this.btnIndicatorActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnForeground, -1, -1, Short.MAX_VALUE).addComponent(this.btnBackground, -1, -1, Short.MAX_VALUE).addComponent(this.btnDefault, -1, -1, Short.MAX_VALUE).addComponent(this.btnIndicator, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.btnForeground).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBackground).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnIndicator).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDefault).addContainerGap(179, Short.MAX_VALUE)));
        this.add((Component)this.jPanel2, "West");
    }

    private void btnForegroundActionPerformed(ActionEvent evt) {
        this._fgColor = this.getColorFromEditor(this._fgColor);
        this.updateButtonColors();
        this.firePropertyChange(MODIFIED, null, null);
    }

    private void btnBackgroundActionPerformed(ActionEvent evt) {
        this._bgColor = this.getColorFromEditor(this._bgColor);
        this.updateButtonColors();
        this.firePropertyChange(MODIFIED, null, null);
    }

    private void btnDefaultActionPerformed(ActionEvent evt) {
        this._bgColor = Constants.getDefaultBgColor();
        this._fgColor = Constants.getDefaultFgColor();
        this._indicatorColor = Constants.getDefaultIndicatorColor();
        this.updateButtonColors();
        this.firePropertyChange(MODIFIED, null, null);
    }

    private void btnIndicatorActionPerformed(ActionEvent evt) {
        this._indicatorColor = this.getColorFromEditor(this._indicatorColor);
        this.updateButtonColors();
        this.firePropertyChange(MODIFIED, null, null);
    }

    private void updateButtonColors() {
        this.btnBackground.setIcon(this.buildIconForColor(this._bgColor));
        this.btnForeground.setIcon(this.buildIconForColor(this._fgColor));
        this.btnIndicator.setIcon(this.buildIconForColor(this._indicatorColor));
    }

    private Icon buildIconForColor(Color color) {
        BufferedImage image = this.buildImage(color);
        return new ImageIcon(image);
    }

    private BufferedImage buildImage(Color color) {
        int width = 16;
        int height = 16;
        BufferedImage output = new BufferedImage(width, height, 2);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                output.setRGB(x, y, color.getRGB());
            }
        }
        return output;
    }

    protected abstract Color getColorFromEditor(Color var1);

    private void initExample() {
        SampleSpinner spinner = new SampleSpinner(this.pnlSample);
        JLayer<JPanel> layer = new JLayer<JPanel>(this.pnlSample, spinner.getLayer());
        spinner.start("Example");
        this.add(layer, "Center");
        this.initSampleInterface(this.pnlSample);
    }

    protected abstract void initSampleInterface(JPanel var1);

    private class SampleSpinner
    extends SpinningLoadingGui<JPanel> {
        public SampleSpinner(JComponent comp) {
            super(comp, LoadingGuiOptionsPanel.this._prefs);
        }

        @Override
        public Color getBgColor() {
            return LoadingGuiOptionsPanel.this._bgColor;
        }

        @Override
        public Color getFgColor() {
            return LoadingGuiOptionsPanel.this._fgColor;
        }

        @Override
        public Color getIndicatorColor() {
            return LoadingGuiOptionsPanel.this._indicatorColor;
        }
    }
}

