/*
 * Decompiled with CFR 0.152.
 */
package usace.loading.gui.prefs;

import java.awt.Color;
import java.util.prefs.Preferences;

public class Constants {
    private static final String BACKGROUND_COLOR_PREF = "bg_color";
    private static final String FOREGROUND_COLOR_PREF = "fg_color";
    private static final String INDICATOR_COLOR_PREF = "indicator_color";
    protected static final int DEFAULT_BACKGROUND_COLOR = 0x19000000;
    protected static final int DEFAULT_FOREGROUND_COLOR = -16777216;
    protected static final int DEFAULT_INDICATOR_COLOR = -1;
    private static final String PREF_ROOT = "loading_gui";

    public static Color getBgColor(Preferences prefs) {
        return Constants.get(prefs, BACKGROUND_COLOR_PREF, 0x19000000);
    }

    public static Color getFgColor(Preferences prefs) {
        return Constants.get(prefs, FOREGROUND_COLOR_PREF, -16777216);
    }

    public static Color getIndicatorColor(Preferences prefs) {
        return Constants.get(prefs, INDICATOR_COLOR_PREF, -1);
    }

    public static void setBgColor(Preferences prefs, Color color) {
        Constants.set(prefs, BACKGROUND_COLOR_PREF, color);
    }

    public static void setFgColor(Preferences prefs, Color color) {
        Constants.set(prefs, FOREGROUND_COLOR_PREF, color);
    }

    public static void setIndicatorColor(Preferences prefs, Color color) {
        Constants.set(prefs, INDICATOR_COLOR_PREF, color);
    }

    public static Color getDefaultBgColor() {
        return new Color(0x19000000, true);
    }

    public static Color getDefaultFgColor() {
        return new Color(-16777216, true);
    }

    public static Color getDefaultIndicatorColor() {
        return new Color(-1, true);
    }

    private static Preferences getPrefs(Preferences prefs) {
        return prefs.node(PREF_ROOT);
    }

    private static Color get(Preferences prefs, String name, int def) {
        Preferences node = Constants.getPrefs(prefs);
        int iColor = node.getInt(name, def);
        return new Color(iColor, true);
    }

    private static void set(Preferences prefs, String name, Color color) {
        Constants.set(prefs, name, color.getRGB());
    }

    private static void set(Preferences prefs, String name, int value) {
        Preferences node = Constants.getPrefs(prefs);
        node.putInt(name, value);
    }
}

