/*
 * Decompiled with CFR 0.152.
 */
package usace.loading.gui.states;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import usace.loading.gui.prefs.Constants;
import usace.loading.gui.states.IState;
import usace.loading.gui.states.IStateMachine;

public abstract class AbstractState
implements IState {
    private final WeakReference<IStateMachine> _stateMachineRef;
    private String _text;
    private final Preferences _prefs;

    public AbstractState(IStateMachine stateMachine, String text, Preferences prefs) {
        this._stateMachineRef = new WeakReference<IStateMachine>(stateMachine);
        this._prefs = prefs;
        this._text = text;
    }

    @Override
    public synchronized IStateMachine getStateMachine() {
        return (IStateMachine)this._stateMachineRef.get();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void setText(String text) {
        this._text = text;
    }

    public String getText() {
        return this._text;
    }

    @Override
    public void processInputMethodEvent(InputMethodEvent e) {
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
    }

    @Override
    public void processMouseWheelEvent(MouseWheelEvent e) {
    }

    @Override
    public void processMouseMotionEvent(MouseEvent e) {
    }

    public Preferences getPrefs() {
        return this._prefs;
    }

    protected Color getBgColor() {
        if (this.getStateMachine() != null) {
            return this.getStateMachine().getBgColor();
        }
        return Constants.getDefaultBgColor();
    }

    protected Color getFgColor() {
        if (this.getStateMachine() != null) {
            return this.getStateMachine().getFgColor();
        }
        return Constants.getDefaultFgColor();
    }

    protected Color getIndicatorColor() {
        if (this.getStateMachine() != null) {
            return this.getStateMachine().getIndicatorColor();
        }
        return Constants.getDefaultIndicatorColor();
    }

    @Override
    public synchronized void shutdown() {
        this._stateMachineRef.clear();
    }

    protected void repaintStateMachine() {
        SwingUtilities.invokeLater(() -> {
            if (this.getStateMachine() != null) {
                this.getStateMachine().repaint();
            }
        });
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.getClass());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }
}

