/*
 * Decompiled with CFR 0.152.
 */
package usace.loading.gui.states;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.Timer;
import usace.loading.gui.states.AbstractState;
import usace.loading.gui.states.IStateMachine;

public class RunningState
extends AbstractState
implements ActionListener {
    private static final int FRAMES_PER_SECOND = 10;
    private static final int DEFAULT_FONT_SIZE = 24;
    private static final int MIN_FONT_SIZE = 10;
    private static final int MAX_FONT_SIZE = 30;
    private static final int TOTAL_LINES = 16;
    private int _angle;
    private Timer _timer;

    public RunningState(IStateMachine stateMachine, String text, Preferences prefs) {
        super(stateMachine, text, prefs);
    }

    @Override
    public void initState() {
        int fps = 10;
        int tick = 1000 / fps;
        this._timer = new Timer(tick, this);
        if (this._timer.isRunning()) {
            this._timer.restart();
            this.actionPerformed(null);
        } else {
            this._timer.start();
        }
        this.repaintStateMachine();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        IStateMachine stateMachine = this.getStateMachine();
        if (stateMachine == null || stateMachine.isShutdown() || stateMachine.getState() != this) {
            this.shutdown();
            return;
        }
        ++this._angle;
        if (this._angle >= 16) {
            this._angle = 0;
        }
        this.repaintStateMachine();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.getStateMachine() == null || this.getStateMachine().isShutdown()) {
            return;
        }
        int w = c.getWidth();
        int h = c.getHeight();
        Graphics2D g2 = (Graphics2D)g.create();
        this.renderBackgroundLayer(g2, w, h);
        this.renderIndicator(g2, w, h);
        this.renderText(g2, w, h);
        g2.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderBackgroundLayer(Graphics g, int w, int h) {
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            g2d.setColor(this.getBgColor());
            g2d.fillRect(0, 0, w, h);
        }
        finally {
            g2d.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderIndicator(Graphics g, int w, int h) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            int s = Math.min(w, h) / 10;
            int cx = w / 2;
            int cy = h / 2;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(new BasicStroke(s / 4, 1, 1));
            g2.setPaint(this.getIndicatorColor());
            g2.rotate(0.39269908169872414 * (double)this._angle, cx, cy);
            for (int i = 0; i < 16; ++i) {
                float scale = (15.0f - (float)i) / 15.0f;
                g2.drawLine(cx + s, cy, cx + s * 2, cy);
                g2.rotate(-0.39269908169872414, cx, cy);
                g2.setComposite(AlphaComposite.getInstance(3, scale));
            }
        }
        finally {
            g2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderText(Graphics g, int w, int h) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            String text = this.getText();
            if (text == null || text.isEmpty()) {
                return;
            }
            Font font = new Font("Tahoma", 0, 24);
            FontMetrics tempFm = g2.getFontMetrics(font);
            Rectangle2D tempBounds = tempFm.getStringBounds(text, g);
            double ratio = Math.min((double)w / tempBounds.getWidth() * 0.5, (double)h / tempBounds.getHeight() * 0.32);
            ratio = Math.min(Math.max(ratio * 24.0, 10.0), 30.0);
            font = new Font("Tahoma", 0, (int)ratio);
            FontRenderContext frc = g2.getFontRenderContext();
            TextLayout layout = new TextLayout(text, font, frc);
            Rectangle2D bounds = layout.getBounds();
            int width = (int)Math.round(bounds.getWidth());
            int height = (int)Math.round(bounds.getHeight());
            g2.setColor(this.getFgColor());
            layout.draw(g2, (w - width) / 2, (h - height) / 2);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        e.consume();
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        e.consume();
    }

    @Override
    public void processInputMethodEvent(InputMethodEvent e) {
        e.consume();
    }

    @Override
    public void processMouseMotionEvent(MouseEvent e) {
        e.consume();
    }

    @Override
    public void processMouseWheelEvent(MouseWheelEvent e) {
        e.consume();
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        if (this._timer != null) {
            this._timer.stop();
            this._timer.removeActionListener(this);
            this._timer = null;
        }
    }
}

