/*
 * Decompiled with CFR 0.152.
 */
package usace.loading.gui.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.plaf.LayerUI;
import usace.loading.gui.LoadingGui;
import usace.loading.gui.prefs.Constants;
import usace.loading.gui.states.IState;
import usace.loading.gui.states.IStateMachine;
import usace.loading.gui.states.StoppedState;

public abstract class AbstractLoadingGui<T extends Component>
extends LayerUI<T>
implements LoadingGui,
IStateMachine {
    private final WeakReference<Component> _parent;
    private final Preferences _prefs;
    private IState _state;
    private boolean _isShutdown = false;

    public AbstractLoadingGui(Component parent, Preferences prefs) {
        this._parent = new WeakReference<Component>(parent);
        this._prefs = prefs;
        this._state = new StoppedState(this, prefs);
    }

    protected final synchronized void setState(IState state) {
        if (Objects.equals(this._state, state)) {
            return;
        }
        if (this._state != null) {
            this._state.shutdown();
        }
        Logger.getLogger(AbstractLoadingGui.class.getName()).log(Level.FINE, "{0} changed to {1}", new Object[]{((Component)this._parent.get()).getClass().getSimpleName(), state.getClass().getSimpleName()});
        this._state = state;
        if (this._state != null) {
            this._state.initState();
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        this._state.paint(g, c);
    }

    @Override
    public void repaint() {
        if (this._parent.get() != null && ((Component)this._parent.get()).isShowing() && !this._isShutdown) {
            ((Component)this._parent.get()).repaint();
        }
        if (this._parent.get() == null || this._isShutdown) {
            this._state.shutdown();
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e, JLayer<? extends T> l) {
        this._state.processMouseEvent(e);
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e, JLayer<? extends T> l) {
        this._state.processMouseWheelEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e, JLayer<? extends T> l) {
        this._state.processMouseMotionEvent(e);
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent e, JLayer<? extends T> l) {
        this._state.processInputMethodEvent(e);
    }

    @Override
    protected void processKeyEvent(KeyEvent e, JLayer<? extends T> l) {
        this._state.processKeyEvent(e);
    }

    public Preferences getPrefs() {
        return this._prefs;
    }

    @Override
    public IState getState() {
        return this._state;
    }

    @Override
    public void updateText(String text) {
        this._state.setText(text);
    }

    @Override
    public Color getBgColor() {
        return Constants.getBgColor(this._prefs);
    }

    @Override
    public Color getFgColor() {
        return Constants.getFgColor(this._prefs);
    }

    @Override
    public Color getIndicatorColor() {
        return Constants.getIndicatorColor(this._prefs);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JLayer jlayer = (JLayer)c;
        jlayer.setLayerEventMask(48L);
    }

    @Override
    public void uninstallUI(JComponent c) {
        JLayer jlayer = (JLayer)c;
        jlayer.setLayerEventMask(0L);
        super.uninstallUI(c);
    }

    @Override
    public void shutdown() {
        this._state.shutdown();
        this._isShutdown = true;
    }

    @Override
    public boolean isShutdown() {
        return this._isShutdown;
    }

    protected void setShutdown(boolean value) {
        this._isShutdown = value;
    }
}

