/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.ensemble.client;

import hec.clientapp.model.ModelAlt;
import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.model.AltItem;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.plugins.ResSimPluginModelPanel;
import hec.rss.plugins.ensemble.client.EnsemblePanel$1;
import hec.rss.plugins.ensemble.model.EnsembleAltPluginData;
import hec.rss.plugins.factories.AltPluginDataFactory;
import hec.rss.plugins.model.AltPluginData;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJIntegerSetField;

public class EnsemblePanel
extends AbstractEditorPanel
implements AlternativePanel,
ResSimPluginModelPanel {
    private RssSystem _system;
    private ModelAlt _modelAlt;
    private RmaJIntegerSetField _useEnsembleNumbersField;
    private RmaJCheckBox _useMultithreadedComputeCheck;

    public EnsemblePanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        this.setBorder(BorderFactory.createTitledBorder("Ensemble"));
        JLabel jLabel = new JLabel("Use Ensemble Members*:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jLabel, gridBagConstraints);
        this._useEnsembleNumbersField = new RmaJIntegerSetField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        EnsemblePanel ensemblePanel = this;
        ensemblePanel.add((Component)ensemblePanel._useEnsembleNumbersField, gridBagConstraints);
        this._useEnsembleNumbersField.setChooserDialogTitle("Enter Ensemble Members");
        jLabel = new JLabel("*Ensemble Members are 6 numeric characters long.");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jLabel, gridBagConstraints);
        jLabel = new JLabel(" To use all Ensemble members in a collection enter the star, *, character. ");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jLabel, gridBagConstraints);
        this._useMultithreadedComputeCheck = new RmaJCheckBox("Use Multithreaded Compute");
        this._useMultithreadedComputeCheck.setToolTipText("<html>Check to use a Multithreaded ResSim computational engine.<br>By default the Ensemble Compute uses a single-threaded computational engine</html>");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        EnsemblePanel ensemblePanel2 = this;
        ensemblePanel2.add((Component)ensemblePanel2._useMultithreadedComputeCheck, gridBagConstraints);
    }

    private void addListeners() {
        this._useEnsembleNumbersField.addFocusListener((FocusListener)new EnsemblePanel$1(this));
    }

    protected void updateTimeSeriesTabText(String string) {
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (window instanceof AlternativeEditor && Boolean.getBoolean("Ensemble.UpdateTsTab")) {
            window = (AlternativeEditor)window;
            window = window.getTimeSeriesPanel();
            window.setTextInInflowPanel(string);
        }
    }

    public String getTabname() {
        return "Ensemble";
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (window instanceof AlternativeEditor) {
            window = (AlternativeEditor)window;
            window.getTimeSeriesPanel();
            if (bl) {
                EnsemblePanel ensemblePanel = this;
                ensemblePanel.updateTimeSeriesTabText("Ensemble Members" + ensemblePanel._useEnsembleNumbersField.getText());
                return;
            }
            this.updateTimeSeriesTabText("");
        }
    }

    public void setSystem(RssSystem rssSystem) {
        this._system = rssSystem;
    }

    public void clearPanel() {
        this._useEnsembleNumbersField.clearPerformed();
        this.updateTimeSeriesTabText("");
    }

    public boolean createPluginAlternative(RssAlt rssAlt) {
        return true;
    }

    public void deleteAltManager(RssAlt rssAlt) {
    }

    public boolean updateAltItemList(Vector<AltItem> vector) {
        return false;
    }

    public void fillPanel(NamedType object) {
        if (!(object instanceof RssAlt)) {
            return;
        }
        object = (RssAlt)object;
        if ((object = (EnsembleAltPluginData)object.getAltPluginData(AltPluginDataFactory.ENSEMBLE)) == null) {
            return;
        }
        EnsemblePanel ensemblePanel = this;
        ensemblePanel.updateTimeSeriesTabText("Ensemble Members" + ensemblePanel._useEnsembleNumbersField.getText());
        this._useEnsembleNumbersField.setText(((EnsembleAltPluginData)((Object)object)).getEnsembleMembersString());
        this._useMultithreadedComputeCheck.setSelected(((EnsembleAltPluginData)((Object)object)).useMultithreadedCompute());
    }

    public boolean savePanel(NamedType namedType) {
        if (namedType instanceof RssAlt) {
            return this.savePanel((RssAlt)namedType);
        }
        return true;
    }

    public boolean savePanel(RssAlt object) {
        EnsembleAltPluginData ensembleAltPluginData = (EnsembleAltPluginData)object.getAltPluginData(AltPluginDataFactory.ENSEMBLE);
        if (ensembleAltPluginData == null) {
            ensembleAltPluginData = new EnsembleAltPluginData();
            object.addAltPluginData((AltPluginData)ensembleAltPluginData);
        }
        if ((object = SwingUtilities.windowForComponent((Component)((Object)this))) instanceof AlternativeEditor) {
            object = (AlternativeEditor)object;
            ensembleAltPluginData.setUseCompute(object.getRunControlPanel().isPluginRadioSelected(AltPluginDataFactory.ENSEMBLE));
        }
        ensembleAltPluginData.setEnsembleMembersString(this._useEnsembleNumbersField.getText());
        ensembleAltPluginData.setEnsembleArray(this._useEnsembleNumbersField.getIntegerSet());
        ensembleAltPluginData.setUseMultithreadedCompute(this._useMultithreadedComputeCheck.isSelected());
        return true;
    }
}

