/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.ensemble.model;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.model.TSRecordImpl;
import hec.clientapp.rmi.csinterface.HecRmiWorkspace;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.util.HecTime;
import hec.model.TSRecord;
import hec.rss.compute.ResSimComputeLauncher;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.model.RssTSRecordImpl;
import hec.rss.model.reports.AlternativeInputReport;
import hec.rss.plugins.ensemble.compute.EnsembleComputeLauncher;
import hec.rss.plugins.factories.AltPluginDataFactory;
import hec.rss.plugins.model.AbstractAltPluginData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Element;
import rma.util.IntArray;
import rma.util.RMAIO;

public class EnsembleAltPluginData
extends AbstractAltPluginData {
    private static final FluentLogger b = FluentLogger.forEnclosingClass();
    private String c = AltPluginDataFactory.ENSEMBLE;
    private boolean d = false;
    private int[] e;
    private String f;
    private int[] g;
    private List<String> h;
    private String[] i;
    private String[] j = new String[]{"00000", "0000", "000", "00", "0"};
    private int k = -1;
    private int l = -1;
    private boolean m;
    private RssRun n;

    public void setUseCompute(boolean bl) {
        this.d = bl;
    }

    public boolean useCompute() {
        return this.d;
    }

    public List<String> getCollectionNumbers(RssAlt rssAlt, HecTime hecTime) {
        this.initVariables(rssAlt, hecTime);
        return this.h;
    }

    public Vector getTSInputData(RssAlt object, HecTime hecTime) {
        Vector<DSSPathname> vector = new Vector<DSSPathname>();
        this.initVariables((RssAlt)object, hecTime);
        object = object.getInputTSDataSet().getTSRecords();
        boolean bl = false;
        if (this.n != null) {
            bl = this.n.getComputeType() == 3;
        }
        for (int i = 0; i < this.h.size(); ++i) {
            this.h.get(i);
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                TSRecord tSRecord = (TSRecord)((Vector)object).get(j);
                if (!DSSPathname.isaCollectionPath((String)tSRecord.getDSSPathname()) && !bl) continue;
                DSSPathname dSSPathname = new DSSPathname(tSRecord.getDSSPathname());
                String string = HecTimeSeries.getDpartFromTime((HecTime)hecTime, (String)dSSPathname.getEPart());
                dSSPathname.setDPart(string);
                dSSPathname.setCollectionSequence(Integer.parseInt(this.h.get(i)));
                tSRecord.setDSSPathname(dSSPathname.getPathname());
                dSSPathname = new RssTSRecordImpl((TSRecordImpl)tSRecord);
                dSSPathname.setName(tSRecord.getName());
                vector.add(dSSPathname);
            }
        }
        return vector;
    }

    public int initVariables(RssAlt object, HecTime tSRecord) {
        Object object2;
        this.h = new ArrayList<String>();
        Object object3 = null;
        if (this.n != null && this.n.getComputeType() == 3) {
            object2 = this.n.getAdditionalComputeOptions();
            if (object2 instanceof String) {
                object3 = (String)object2;
            }
        } else {
            object3 = this.f.trim();
        }
        if (((String)object3).isEmpty()) {
            return 0;
        }
        object2 = new StringTokenizer((String)object3, ",");
        Object object4 = ((StringTokenizer)object2).nextToken().trim();
        while (object4 != null && !((String)object4).isEmpty()) {
            Object object5;
            if (((String)object4).equals("*")) {
                Object object6;
                object3 = tSRecord;
                tSRecord = object;
                object = this;
                object.h.clear();
                object2 = tSRecord.getInputTSDataSet().getTSRecords();
                object4 = new HecTimeSeries();
                object5 = tSRecord.getWorkspacePath();
                tSRecord = (RmiWorkspace)tSRecord.getWorkspace().getRemote();
                try {
                    RmiWorkspace rmiWorkspace;
                    RmiWorkspace rmiWorkspace2 = tSRecord.getChildWorkspace("");
                    if (rmiWorkspace2 instanceof HecRmiWorkspace && (rmiWorkspace = (object6 = (HecRmiWorkspace)rmiWorkspace2).getBaseWorkspace()) != null) {
                        object5 = rmiWorkspace.getWorkspacePath();
                    }
                }
                catch (RemoteException remoteException) {
                    ((FluentLogger.Api)b.atInfo()).log("getAllCollections:exception getting workspace path " + String.valueOf(remoteException));
                }
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    tSRecord = (TSRecord)((Vector)object2).get(i);
                    if (!DSSPathname.isaCollectionPath((String)tSRecord.getDSSPathname())) continue;
                    if (!RMAIO.isFullPath((String)tSRecord.getDSSFilename())) {
                        object6 = RMAIO.getRelativePath((String)object5, (String)tSRecord.getDSSFilename());
                        object4.setDSSFileName((String)object5 + "/" + (String)object6);
                    } else {
                        object4.setDSSFileName(tSRecord.getDSSFilename());
                    }
                    object6 = new DSSPathname();
                    object6.setPathname(tSRecord.getDSSPathname());
                    tSRecord = HecTimeSeries.getDpartFromTime((HecTime)object3, (String)object6.getEPart());
                    object6.setDPart((String)tSRecord);
                    tSRecord = object4.getCollectionSequenceList(object6.getPathname());
                    if (tSRecord == null || ((String[])tSRecord).length <= 0) continue;
                    for (int j = 0; j < ((String[])tSRecord).length; ++j) {
                        object6 = tSRecord[j];
                        if (((String)object6).length() < 6) {
                            object6 = object.j[((String)object6).length() - 1] + (String)object6;
                        }
                        if (object.h.contains(object6)) continue;
                        object.h.add((String)object6);
                    }
                }
                break;
            }
            if (((String)object4).contains("-")) {
                object3 = new StringTokenizer((String)object4, "-");
                String string = ((StringTokenizer)object3).nextToken().trim();
                if (!string.matches("[a-zA-z0-9]*")) continue;
                object5 = string;
                string = ((StringTokenizer)object3).nextToken().trim();
                if (((String)object5).length() < 6) {
                    object5 = this.j[((String)object5).length() - 1] + (String)object5;
                }
                if (!string.matches("[a-zA-z0-9]*")) continue;
                int n = Integer.parseInt(string);
                if (!this.h.contains(object5)) {
                    this.h.add((String)object5);
                }
                object4 = object5;
                int n2 = Integer.parseInt((String)object4);
                while (object4 != null) {
                    if (((String)(object4 = Integer.toString(++n2))).length() < 6) {
                        object4 = this.j[((String)object4).length() - 1] + (String)object4;
                    }
                    if (!this.h.contains(object4)) {
                        this.h.add((String)object4);
                    }
                    if (n2 != n) continue;
                    object4 = null;
                }
            } else if (((String)object4).matches("[a-zA-z0-9]*")) {
                if (((String)object4).length() < 6) {
                    object4 = this.j[((String)object4).length() - 1] + (String)object4;
                }
                if (!this.h.contains(object4)) {
                    this.h.add((String)object4);
                }
            }
            if (!((StringTokenizer)object2).hasMoreTokens()) break;
            object4 = ((StringTokenizer)object2).nextToken().trim();
        }
        Arrays.sort(this.h.toArray());
        return 0;
    }

    public int compute(RssRun rssRun) {
        int n;
        this.n = rssRun;
        rssRun.setRunProgress(0.0);
        rssRun.setTimeBlocking(false);
        rssRun.setIterative(false);
        rssRun.setTimeInit(0L);
        rssRun.setTimePulse(0L);
        rssRun.setTimeCLoc(0L);
        rssRun.setTimeUReg(0L);
        rssRun.setTimeReg2(0L);
        rssRun.setTimeHOut(0L);
        rssRun.setTimeCplt(0L);
        long[] lArray = new long[1];
        if (rssRun.getLogLevel() > 5) {
            RssRun rssRun2 = rssRun;
            rssRun2.printMessage("Is EnsembleCompute:" + (rssRun2.getComputeType() == 3) + " Ensemble Member:" + String.valueOf(rssRun.getAdditionalComputeOptions()));
        }
        if (rssRun.getComputeType() == 3 && rssRun.getAdditionalComputeOptions() instanceof String) {
            if (this.h != null) {
                this.h.clear();
            } else {
                this.h = new ArrayList<String>(1);
            }
            String string = (String)rssRun.getAdditionalComputeOptions();
            rssRun.printMessage("Using Ensemble Member :" + string);
            this.h.add(string);
        }
        if ((n = rssRun.initCompute(lArray)) != 0) {
            return n;
        }
        RssRun rssRun3 = rssRun;
        rssRun3.setTimeInit(rssRun3.getTimeInit()[0] + lArray[0]);
        long l = System.currentTimeMillis();
        n = this.initVariables(rssRun.getAlternative(), rssRun.getRunTimeWindow().getStartTime());
        if (n != 0) {
            return n;
        }
        int n2 = 0;
        long l2 = System.currentTimeMillis();
        RssRun rssRun4 = rssRun;
        rssRun4.setTimeInit(rssRun4.getTimeInit()[0] + l2 - l);
        if (this.h.isEmpty()) {
            rssRun.printErrorMessage("*****No collection data was found for an Ensemble compute!****");
            return 1;
        }
        int n3 = 0;
        int n4 = this.h.size();
        rssRun.setNumberTasks(n4);
        rssRun.printMessage("There are " + n4 + " ensemble runs to compute");
        if (this.k >= 0) {
            n3 = this.k;
        }
        if (this.l >= 0) {
            n4 = this.l;
        }
        rssRun.printMessage("Computing ensemble member(s) " + n3 + " to " + n4);
        for (int i = n3; i < n4; ++i) {
            long l3;
            try {
                boolean bl;
                block34: {
                    TSRecord tSRecord;
                    System.currentTimeMillis();
                    long l4 = System.currentTimeMillis();
                    rssRun.initProgress();
                    rssRun.printMessage("\n***Computing ensemble member " + i);
                    rssRun.setRunProgress(5.0);
                    l2 = System.currentTimeMillis();
                    RssRun rssRun5 = rssRun;
                    rssRun5.setTimeInit(rssRun5.getTimeInit()[0] + l2 - l4);
                    int n5 = i;
                    RssRun rssRun6 = rssRun;
                    Object object = this;
                    Object object2 = rssRun6.getInputTSData();
                    object2 = object2.getTSRecords();
                    object.i = new String[((Vector)object2).size()];
                    boolean bl2 = object.n.getComputeType() == 3;
                    for (int j = 0; j < ((Vector)object2).size(); ++j) {
                        tSRecord = (TSRecord)((Vector)object2).get(j);
                        if (!DSSPathname.isaCollectionPath((String)tSRecord.getDSSPathname()) && !bl2) continue;
                        DSSPathname dSSPathname = new DSSPathname(tSRecord.getDSSPathname());
                        String string = HecTimeSeries.getDpartFromTime((HecTime)rssRun6.getRunTimeWindow().getStartTime(), (String)dSSPathname.getEPart());
                        dSSPathname.setDPart(string);
                        int n6 = Integer.parseInt(object.h.get(n5));
                        dSSPathname.setCollectionSequence(n6);
                        tSRecord.setDSSPathname(dSSPathname.getPathname().toUpperCase());
                        if (tSRecord.loadTSData(rssRun6.getRunTimeWindow().getStartTime(), rssRun6.getRunTimeWindow().getEndTime())) continue;
                        object = tSRecord.getName();
                        object = rssRun6.getNetwork().getNameForKeyString((String)object);
                        rssRun6.printWarningMessage("Failed to load Ensemble Time Series Record for " + (String)object + ", Ensemble member:" + n5 + " Collection Number:" + n6 + " DSS path=" + tSRecord.getDSSPathname());
                        bl = true;
                        break block34;
                    }
                    Vector vector = rssRun6.getOutputTSData().getTSRecords();
                    if (vector.size() <= 0) {
                        rssRun6.printErrorMessage("Ensemble could not change TS Output F-Part because record list was empty.");
                        bl = true;
                    } else {
                        tSRecord = (TSRecord)vector.get(0);
                        DSSPathname dSSPathname = new DSSPathname(tSRecord.getDSSPathname());
                        dSSPathname.setCollectionSequence(Integer.parseInt(object.h.get(n5)));
                        rssRun6.setOutputFPart(dSSPathname.getFPart());
                        bl = false;
                    }
                }
                if (bl) {
                    rssRun.printMessage("\n***Ensemble compute skipped iteration " + i + " because record were missing for: " + this.h.get(i));
                    ++n2;
                    continue;
                }
                if (n2 == 0) {
                    n = rssRun.pulseRoutingCompute(lArray);
                    if (n != 0) {
                        return n;
                    }
                    RssRun rssRun7 = rssRun;
                    rssRun7.setTimePulse(rssRun7.getTimePulse()[0] + lArray[0]);
                    rssRun.setRunProgress(10.0);
                }
                if ((n = rssRun.cumLocCompute(lArray)) != 0) {
                    return n;
                }
                RssRun rssRun8 = rssRun;
                rssRun8.setTimePulse(rssRun8.getTimeCLoc()[0] + lArray[0]);
                rssRun.setRunProgress(15.0);
                n = rssRun.unRegCompute(lArray);
                if (n != 0) {
                    return n;
                }
                RssRun rssRun9 = rssRun;
                rssRun9.setTimeUReg(rssRun9.getTimeUReg()[0] + lArray[0]);
                rssRun.setRunProgress(25.0);
                n = rssRun.regCompute(lArray);
                if (n != 0) {
                    return n;
                }
                RssRun rssRun10 = rssRun;
                rssRun10.setTimeReg2(rssRun10.getTimeReg2()[0] + lArray[0]);
                rssRun.setRunProgress(90.0);
                n = rssRun.holdOutCompute(lArray);
                if (n != 0) {
                    return n;
                }
                RssRun rssRun11 = rssRun;
                rssRun11.setTimeHOut(rssRun11.getTimeHOut()[0] + lArray[0]);
                rssRun.setRunProgress(95.0);
                l3 = System.currentTimeMillis();
                l2 = System.currentTimeMillis();
                RssRun rssRun12 = rssRun;
                rssRun12.setTimeCplt(rssRun12.getTimeCplt()[0] + l2 - l3);
                n = i == this.h.size() - 1 ? 1 : 0;
                n = rssRun.finalizeCompute(lArray, true, n != 0);
                if (n != 0) {
                    return n;
                }
                RssRun rssRun13 = rssRun;
                rssRun13.setTimeCplt(rssRun13.getTimeCplt()[0] + lArray[0]);
                rssRun.setRunProgress(100.0);
                System.currentTimeMillis();
                ++n2;
            }
            catch (Exception exception) {
                ((FluentLogger.Api)b.atInfo()).log("Ensemble Compute:Exception during computing " + String.valueOf(exception));
                rssRun.printErrorMessage("Ensemble Compute exception during computing " + String.valueOf(exception));
                if (rssRun.getLogLevel() > 5) {
                    exception.printStackTrace();
                }
                n = 1;
                ++n2;
            }
            finally {
                l3 = System.currentTimeMillis();
                l2 = System.currentTimeMillis();
                RssRun rssRun14 = rssRun;
                rssRun14.setTimeCplt(rssRun14.getTimeCplt()[0] + l2 - l3);
                rssRun.setTaskNumber(i);
            }
            continue;
        }
        rssRun.setTaskNumber(n4);
        EnsembleAltPluginData ensembleAltPluginData = this;
        ensembleAltPluginData.l = -1;
        ensembleAltPluginData.k = -1;
        return n;
    }

    public void setType(String string) {
    }

    public String getType() {
        return this.c;
    }

    public String getEnsembleMembersString() {
        return this.f;
    }

    public void setEnsembleMembersString(String string) {
        this.f = string;
    }

    public int[] getEnsembleArray() {
        return this.g;
    }

    public void setEnsembleArray(int[] nArray) {
        this.g = nArray;
    }

    public void read(BufferedReader bufferedReader) {
        try {
            IntArray intArray = new IntArray();
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.length() == 0) {
                    string = bufferedReader.readLine();
                    continue;
                }
                String string2 = RMAIO.getType((String)string, (String)":");
                string = RMAIO.getParam((String)string, (String)":");
                if (string2.equals("PlugInEnd")) {
                    return;
                }
                if (string2.equals("EnsembleMemebersArray")) {
                    intArray.add(Integer.parseInt(string));
                } else if (string2.equals("EnsembleMembersString")) {
                    this.setEnsembleMembersString(string);
                } else if (string2.equals("Compute")) {
                    this.setUseCompute(Boolean.parseBoolean(string));
                } else if (string2.equalsIgnoreCase("UseMultithreadedCompute")) {
                    this.setUseMultithreadedCompute(Boolean.parseBoolean(string));
                }
                string = bufferedReader.readLine();
            }
            this.g = intArray.toArray();
            return;
        }
        catch (IOException iOException) {
            ((FluentLogger.Api)b.atInfo()).log("Failed to read Monte Carlo Plugin Data.   " + String.valueOf(iOException.getStackTrace()));
            return;
        }
    }

    public void write(BufferedWriter bufferedWriter) {
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"PlugIn:Ensemble");
        if (this.g != null) {
            for (int i = 0; i < this.g.length; ++i) {
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)("EnsembleMemebersArray:" + this.g[i]));
            }
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("EnsembleMembersString:" + this.f));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Compute:" + this.useCompute()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("UseMultithreadedCompute:" + this.m));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"PlugInEnd");
    }

    public EnsembleAltPluginData clone() {
        try {
            EnsembleAltPluginData ensembleAltPluginData = (EnsembleAltPluginData)super.clone();
            ((EnsembleAltPluginData)super.clone()).d = this.d;
            ensembleAltPluginData.g = this.g;
            ensembleAltPluginData.f = this.f;
            ensembleAltPluginData.e = this.e;
            return ensembleAltPluginData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ((FluentLogger.Api)b.atInfo()).log("EnsembleAltPluginDataclone: Error in clone " + String.valueOf(cloneNotSupportedException));
            return null;
        }
    }

    public boolean writeReport(BufferedWriter bufferedWriter, RssRun rssRun) throws IOException {
        return true;
    }

    public ResSimComputeLauncher getComputeLauncher() {
        if (!this.m) {
            return null;
        }
        EnsembleComputeLauncher ensembleComputeLauncher = new EnsembleComputeLauncher();
        return ensembleComputeLauncher;
    }

    public void setUseMultithreadedCompute(boolean bl) {
        this.m = bl;
    }

    public boolean useMultithreadedCompute() {
        return this.m;
    }

    public void setEnsembleIndexes(int n, int n2) {
        this.k = n;
        this.l = n2;
    }

    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        element.setAttribute("ComputeOn", Boolean.toString(this.d));
        element.setAttribute("EnsembleMemebers", this.f);
        element.setAttribute("MultithreadedCompute", Boolean.toString(this.m));
    }

    public void setRssRun(RssRun rssRun) {
        this.n = rssRun;
    }
}

