/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.alternativeReport;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.SimulationRun;
import hec.io.Identifier;
import hec.rss.client.RSimSimulationMode;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSimTrialRun;
import hec.rss.model.RssSimulationRun;
import hec.rss.model.RssSystem;
import hec.rss.plugins.alternativeReport.AlternativeReport$1;
import hec.rss.plugins.alternativeReport.AlternativeReport$2;
import hec.rss.plugins.alternativeReport.AlternativeReport$3;
import hec.rss.plugins.alternativeReport.AlternativeReport$4;
import hec.rss.plugins.alternativeReport.AlternativeReport$5;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class AlternativeReport
extends RmaJDialog {
    private RmaJTable _altTable;
    private ButtonCmdPanel _cmdPanel;
    private RmaJTextField _nameFld;
    private RmaJDescriptionField _descFld;
    private RmaJIntegerField _idxFld;
    private RmaJTextField _fileFld;
    private RmaJPanel _lowerPanel;
    private JCheckBoxMenuItem _allowEditsMenuItem;
    private RmaJTextField _classFld;
    private RmaJTextField _lastModFld;

    public AlternativeReport(Frame frame, Vector vector) {
        super(frame, false);
        this.buildControls();
        this.addListeners();
        this.fillForm(vector);
        this.pack();
        this.setSize(640, 400);
        AlternativeReport alternativeReport = this;
        alternativeReport.setLocationRelativeTo(alternativeReport.getParent());
    }

    private void buildControls() {
        this.setTitle("Alternative Report");
        this.getContentPane().setLayout(new GridBagLayout());
        Object object = new String[]{"Type", "Alternative", "Network", "Input Time Series", "Variants"};
        AlternativeReport alternativeReport = this;
        this._altTable = new AlternativeReport$1(alternativeReport, (Component)((Object)alternativeReport), (Object[])object);
        this._altTable.setModifiedForegroundColor(Color.BLUE);
        this._altTable.setRowHeight(this._altTable.getRowHeight() + 5);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        object.gridy = -1;
        object.gridwidth = 0;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.anchor = 18;
        object.fill = 1;
        object.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._altTable.getScrollPane(), object);
        this.buildLowerPanel();
        this._cmdPanel = new ButtonCmdPanel(12);
        object.gridx = -1;
        object.gridy = -1;
        object.gridwidth = 0;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.anchor = 16;
        object.fill = 2;
        object.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, object);
        this.buildMenus();
    }

    private void buildLowerPanel() {
        this._lowerPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._lowerPanel, gridBagConstraints);
        JLabel jLabel = new JLabel("Name:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._lowerPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._nameFld = new RmaJTextField();
        this._nameFld.setEditable(false);
        jLabel.setLabelFor((Component)this._nameFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._lowerPanel.add((Component)this._nameFld, (Object)gridBagConstraints);
        jLabel = new JLabel("Description:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._lowerPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._descFld = new RmaJDescriptionField();
        this._descFld.setEditable(false);
        jLabel.setLabelFor((Component)this._descFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._lowerPanel.add((Component)this._descFld, (Object)gridBagConstraints);
        jLabel = new JLabel("Workspace Index:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._lowerPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._idxFld = new RmaJIntegerField();
        this._idxFld.setEditable(false);
        jLabel.setLabelFor((Component)this._idxFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._lowerPanel.add((Component)this._idxFld, (Object)gridBagConstraints);
        jLabel = new JLabel("File Path:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._lowerPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._fileFld = new RmaJTextField();
        this._fileFld.setEditable(false);
        jLabel.setLabelFor((Component)this._fileFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._lowerPanel.add((Component)this._fileFld, (Object)gridBagConstraints);
        jLabel = new JLabel("Last Modified:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._lowerPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._lastModFld = new RmaJTextField();
        this._lastModFld.setEditable(false);
        jLabel.setLabelFor((Component)this._lastModFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._lowerPanel.add((Component)this._lastModFld, (Object)gridBagConstraints);
        jLabel = new JLabel("Class:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._lowerPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._classFld = new RmaJTextField();
        this._classFld.setEditable(false);
        jLabel.setLabelFor((Component)this._classFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._lowerPanel.add((Component)this._classFld, (Object)gridBagConstraints);
    }

    private void buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Edit");
        jMenuBar.add(jMenu);
        this._allowEditsMenuItem = new JCheckBoxMenuItem("Allow Editing");
        jMenu.add(this._allowEditsMenuItem);
        this.setJMenuBar(jMenuBar);
    }

    private void addListeners() {
        this._altTable.getSelectionModel().addListSelectionListener(new AlternativeReport$2(this));
        this._allowEditsMenuItem.addActionListener(new AlternativeReport$3(this));
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new AlternativeReport$4(this));
    }

    protected void allowEditsAction() {
        RSimSimulationMode rSimSimulationMode = (RSimSimulationMode)ClientApp.frame().getModeByName("Simulation");
        if ((rSimSimulationMode = rSimSimulationMode.getActiveRun()) != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "<html>There can't be any Active Runs in the Simulation Module when editing.<br>Set the current Run as inactive first</html>", "No Active Runs allowed", 1);
            this._allowEditsMenuItem.setSelected(false);
            this._altTable.repaint();
            return;
        }
        if (this._altTable.getRowCount() == 0) {
            return;
        }
        boolean bl = this._allowEditsMenuItem.isSelected();
        if (bl) {
            Vector<Identifier> vector = new Vector<Identifier>();
            RssAlt rssAlt = (RssAlt)this._altTable.getValueAt(0, 1);
            Vector vector2 = rssAlt.getProxyList().getManagerIDList(RssSystem.class.getName());
            for (int i = 0; i < vector2.size(); ++i) {
                Identifier identifier = (Identifier)vector2.get(i);
                identifier = rssAlt.getProxyList().getManagerProxy(identifier);
                if (identifier == null) continue;
                vector.add(identifier);
            }
            JComboBox jComboBox = this._altTable.setComboBoxEditor(2, vector);
            jComboBox.addActionListener(new AlternativeReport$5(this));
            this._altTable.repaint();
            this._allowEditsMenuItem.setEnabled(false);
        }
    }

    protected void tableSelectionAction() {
        int n = this._altTable.getSelectedRow();
        if (n == -1) {
            this.clearLowerPanel();
            return;
        }
        int n2 = this._altTable.getSelectedColumn();
        if (n2 == -1) {
            this.clearLowerPanel();
            return;
        }
        Object object = this._altTable.getValueAt(n, n2);
        if (object == null) {
            this.clearLowerPanel();
            return;
        }
        if (object instanceof Manager) {
            this.fillLowerTable((Manager)object);
            return;
        }
        if (object instanceof ManagerProxy) {
            this.fillLowerTable((ManagerProxy)object);
            return;
        }
        this.clearLowerPanel();
    }

    private void fillLowerTable(ManagerProxy object) {
        this._nameFld.setText(object.getName());
        this._descFld.setText(object.getDescription());
        this._idxFld.setValue(object.getIndex());
        this._fileFld.setText(object.getId().getPath());
        this._classFld.setText(object.getClassName());
        object = new Date(object.getLastModifiedTime());
        this._lastModFld.setText(((Date)object).toString());
    }

    private void fillLowerTable(Manager object) {
        this._nameFld.setText(object.getName());
        this._descFld.setText(object.getDescription());
        this._idxFld.setValue(object.getIndex());
        this._fileFld.setText(object.getIdentifier().getPath());
        this._classFld.setText(object.getClass().getName());
        object = new Date(object.getLastModifiedTime());
        this._lastModFld.setText(((Date)object).toString());
    }

    private void clearLowerPanel() {
        this._nameFld.clearPerformed();
        this._descFld.clearPerformed();
        this._idxFld.clearPerformed();
        this._fileFld.clearPerformed();
        this._classFld.clearPerformed();
        this._lastModFld.clearPerformed();
    }

    protected boolean saveForm() {
        this._altTable.commitEdit(true);
        if (this._allowEditsMenuItem.isSelected() && this.isModified()) {
            if (!this.validNetworkChoices()) {
                return false;
            }
        } else {
            return true;
        }
        RSimSimulationMode rSimSimulationMode = (RSimSimulationMode)ClientApp.frame().getModeByName("Simulation");
        SimulationRun simulationRun = rSimSimulationMode.getActiveRun();
        RssAlt rssAlt = null;
        if (simulationRun instanceof RssSimulationRun) {
            rssAlt = ((RssSimulationRun)simulationRun).getRssAlt();
        }
        int n = this._altTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            RssAlt rssAlt2 = (RssAlt)this._altTable.getValueAt(i, 1);
            ManagerProxy managerProxy = (ManagerProxy)this._altTable.getValueAt(i, 2);
            if (rssAlt2.getSystemIndex() == managerProxy.getIndex()) continue;
            rssAlt2.setSystemIndex(managerProxy.getIndex());
            rssAlt2.setSystemPath(managerProxy.getId().getPath());
            rssAlt2.setModified(true);
            if (rssAlt2 != rssAlt) continue;
            rSimSimulationMode.updateManagerMaps();
        }
        return true;
    }

    private boolean validNetworkChoices() {
        int n = this._altTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            ManagerProxy managerProxy = (ManagerProxy)this._altTable.getValueAt(i, 2);
            for (int j = i + 1; j < n; ++j) {
                ManagerProxy managerProxy2 = (ManagerProxy)this._altTable.getValueAt(j, 2);
                if (managerProxy != managerProxy2) continue;
                AlternativeReport alternativeReport = this;
                JOptionPane.showMessageDialog((Component)((Object)alternativeReport), "Duplicate Networks selected for " + String.valueOf(alternativeReport._altTable.getValueAt(i, 1)) + " and " + String.valueOf(this._altTable.getValueAt(j, 1)), "Invalid Network Selection", 0);
                return false;
            }
        }
        return true;
    }

    private void fillForm(Vector vector) {
        this._altTable.deleteCells();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object object = (SimulationRun)vector.get(i);
            if (!(object instanceof RssSimulationRun)) continue;
            object = (RssSimulationRun)object;
            this.addRunToTable((RssSimulationRun)object);
            object = object.getTrials();
            if (object == null) continue;
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                Object object2 = ((Vector)object).get(j);
                if (!(object2 instanceof RssSimulationRun)) continue;
                object2 = (RssSimulationRun)object2;
                this.addRunToTable((RssSimulationRun)object2);
            }
        }
        if (this._altTable.getRowCount() == 0) {
            this._allowEditsMenuItem.setEnabled(false);
        }
        this.setModified(false);
    }

    private void addRunToTable(RssSimulationRun rssSimulationRun) {
        String string;
        Object object;
        RssAlt rssAlt = rssSimulationRun.getRssAlt();
        Vector<String> vector = new Vector<String>();
        if (rssSimulationRun instanceof RssSimTrialRun) {
            vector.add("Trial");
        } else {
            vector.add("Run");
        }
        vector.add((String)rssAlt);
        int n = rssAlt.getSystemIndex();
        ManagerProxy managerProxy = rssAlt.getProxyList().getManagerProxy(RssSystem.class.getName(), n);
        if (managerProxy == null) {
            object = rssAlt.getSystemPath();
            string = rssAlt.makeAbsolutePath((String)object);
            try {
                managerProxy = rssAlt.getProxyList().getManagerProxy(RssSystem.class.getName(), new Identifier(string));
            }
            catch (RemoteException remoteException) {}
        }
        vector.add((String)managerProxy);
        vector.add((String)rssAlt.getInputITSDataSet());
        object = rssAlt.getInputTSVariantNames();
        string = "";
        if (object != null) {
            string = object.toString();
            string = RMAIO.removeChar((String)string, (char)'[');
            string = RMAIO.removeChar((String)string, (char)']');
        }
        vector.add(string);
        this._altTable.appendRow(vector);
    }
}

