/*
 * Decompiled with CFR 0.152.
 */
package usace.cwms.db.dao.ifc.pool;

import java.util.Objects;
import usace.cwms.db.dao.ifc.pool.PoolNameType;

public class PoolType {
    private final PoolNameType _poolName;
    private final String _projectId;
    private final String _bottomLevelId;
    private final String _topLevelId;
    private final boolean _implicit;

    public PoolType(PoolNameType poolName, String projectId, String bottomLevelId, String topLevelId, boolean implicit) {
        this._poolName = poolName;
        this._projectId = projectId;
        this._bottomLevelId = bottomLevelId;
        this._topLevelId = topLevelId;
        this._implicit = implicit;
    }

    public boolean isImplicit() {
        return this._implicit;
    }

    public PoolNameType getPoolName() {
        return this._poolName;
    }

    public String getProjectId() {
        return this._projectId;
    }

    public String getBottomLevelId() {
        return this._bottomLevelId;
    }

    public String getTopLevelId() {
        return this._topLevelId;
    }

    public int hashCode() {
        String projectId = PoolNameType.getCaseInsensitiveValue(this._projectId);
        String bottomLevelId = PoolNameType.getCaseInsensitiveValue(this._projectId);
        String topLevelId = PoolNameType.getCaseInsensitiveValue(this._projectId);
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this._poolName);
        hash = 89 * hash + Objects.hashCode(projectId);
        hash = 89 * hash + Objects.hashCode(bottomLevelId);
        hash = 89 * hash + Objects.hashCode(topLevelId);
        return hash;
    }

    public boolean equals(Object obj) {
        String otherTopLevelId;
        String otherBottomLevelId;
        String otherProjectId;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PoolType other = (PoolType)obj;
        String projectId = PoolNameType.getCaseInsensitiveValue(this._projectId);
        if (!Objects.equals(projectId, otherProjectId = PoolNameType.getCaseInsensitiveValue(other._projectId))) {
            return false;
        }
        String bottomLevelId = PoolNameType.getCaseInsensitiveValue(this._bottomLevelId);
        if (!Objects.equals(bottomLevelId, otherBottomLevelId = PoolNameType.getCaseInsensitiveValue(other._bottomLevelId))) {
            return false;
        }
        String topLevelId = PoolNameType.getCaseInsensitiveValue(this._topLevelId);
        if (!Objects.equals(topLevelId, otherTopLevelId = PoolNameType.getCaseInsensitiveValue(other._topLevelId))) {
            return false;
        }
        return Objects.equals(this._poolName, other._poolName);
    }
}

