/*
 * Decompiled with CFR 0.152.
 */
package usace.cwms.db.dao.ifc.xchg;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import usace.cwms.db.dao.ifc.CwmsDbSchemaCompatible;
import usace.cwms.db.dao.util.message.MessageException;

public interface CwmsDbXchg
extends CwmsDbSchemaCompatible {
    public static String createStateChangeMessage(String engineUrl, String newState, String payload) throws MessageException {
        if (!(newState.equalsIgnoreCase("startup") || newState.equalsIgnoreCase("pause") || newState.equalsIgnoreCase("resume") || newState.equalsIgnoreCase("shutdown normal") || newState.equalsIgnoreCase("shutdown immediate"))) {
            throw new MessageException("Illegal data exchange engine state: " + newState);
        }
        StringBuilder sb = new StringBuilder().append("<cwms_message type=\"Status\">\n").append("\t<property type=\"String\" name=\"subtype\">EngineState</property>\n").append("\t<property type=\"String\" name=\"url\">").append(engineUrl).append("</property>\n").append("\t<property type=\"String\" name=\"new_state\">").append(newState).append("</property>\n");
        if (payload != null && payload.length() != 0) {
            sb.append("\t<text>\n").append(payload).append("\n\t</text>\n");
        }
        sb.append("</cwms_message>");
        return sb.toString();
    }

    public static String createStateChangeMessage(String engineUrl, String newState) throws MessageException {
        return CwmsDbXchg.createStateChangeMessage(engineUrl, newState, null);
    }

    public static String createEngineStartupMessage(String engineUrl, String info) throws MessageException {
        return CwmsDbXchg.createStateChangeMessage(engineUrl, "startup", info);
    }

    public static String createEnginePauseMessage(String engineUrl) throws MessageException {
        return CwmsDbXchg.createStateChangeMessage(engineUrl, "pause");
    }

    public static String createEngineResumeMessage(String engineUrl) throws MessageException {
        return CwmsDbXchg.createStateChangeMessage(engineUrl, "resume");
    }

    public static String createEngineShutdownMessage(String engineUrl, boolean isImmediate) throws MessageException {
        return CwmsDbXchg.createStateChangeMessage(engineUrl, isImmediate ? "shutdown immediate" : "shutdown normal");
    }

    public static String createBatchStartMessage(String engineUrl, String setId, String jobId, String dstDatastoreId) throws MessageException {
        if (setId == null || setId.length() == 0) {
            throw new MessageException("Set ID is null or empty.");
        }
        if (jobId == null || jobId.length() == 0) {
            throw new MessageException("Job ID is null or empty.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<cwms_message type=\"Status\">\n").append("\t<property type=\"String\" name=\"subtype\">BatchStarting</property>\n").append("\t<property type=\"String\" name=\"url\">").append(engineUrl).append("</property>\n").append("\t<property type=\"String\" name=\"set_id\">").append(setId).append("</property>\n").append("\t<property type=\"String\" name=\"job_id\">").append(jobId).append("</property>\n").append("\t<property type=\"String\" name=\"destination_datastore_id\">").append(dstDatastoreId).append("</property>\n").append("</cwms_message>");
        return sb.toString();
    }

    public static String createBatchCompleteMessage(String engineUrl, String setId, String jobId, String dstDatastoreId, String info) throws MessageException {
        if (setId == null || setId.length() == 0) {
            throw new MessageException("Set ID is null or empty.");
        }
        if (jobId == null || jobId.length() == 0) {
            throw new MessageException("Job ID is null or empty.");
        }
        String[] parts = info.split("\\n");
        String shortInfo = parts.length > 3 ? parts[0].concat("\n").concat(parts[1]).concat("\n").concat(parts[2]) : info;
        if (shortInfo.length() > 1024) {
            shortInfo = shortInfo.substring(0, 1024);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<cwms_message type=\"Status\">\n").append("\t<property type=\"String\" name=\"subtype\">BatchCompleted</property>\n").append("\t<property type=\"String\" name=\"url\">").append(engineUrl).append("</property>\n").append("\t<property type=\"String\" name=\"set_id\">").append(setId).append("</property>\n").append("\t<property type=\"String\" name=\"job_id\">").append(jobId).append("</property>\n").append("\t<property type=\"String\" name=\"destination_datastore_id\">").append(dstDatastoreId).append("</property>\n");
        if (info.length() != 0) {
            sb.append("\t<text>\n").append(shortInfo).append("\n\t</text>\n");
        }
        sb.append("</cwms_message>");
        return sb.toString();
    }

    public void getQueueNames(Connection var1, String[] var2, String[] var3, String var4) throws SQLException;

    public void getQueueNames(Connection var1, String[] var2, String[] var3) throws SQLException;

    public String replayDataMessages(Connection var1, String var2, String var3, long var4, long var6, String var8, String var9, String var10) throws SQLException;

    public String restartRealtime(Connection var1, String var2) throws SQLException;

    public void updateLastProcessedTime(Connection var1, String var2, String var3, long var4) throws SQLException;

    public String requestBatchExchange(Connection var1, String var2, String var3, String var4, long var5, long var7, String var9, String var10) throws SQLException;

    public long logEngineStartupMessage(Connection var1, String var2, String var3) throws SQLException, MessageException;

    public long logEnginePauseMessage(Connection var1, String var2) throws SQLException, MessageException;

    public long logEngineResumeMessage(Connection var1, String var2) throws SQLException, MessageException;

    public long logEngineShutdownMessage(Connection var1, String var2, boolean var3) throws SQLException, MessageException;

    public long logBatchStartMessage(Connection var1, String var2, String var3, String var4, String var5, String var6) throws SQLException, MessageException;

    public long logBatchCompleteMessage(Connection var1, String var2, String var3, String var4, String var5, String var6, String var7) throws SQLException, MessageException;

    public void renameDataExchangeSet(Connection var1, String var2, String var3, String var4) throws SQLException;

    public void copyDataExchangeSet(Connection var1, String var2, String var3, String var4) throws SQLException;

    public void deleteDataExchangeSet(Connection var1, String var2, String var3) throws SQLException;

    public Reader retrieveDataExchangeConfiguration(Connection var1, String var2, String var3) throws SQLException;

    public Reader retrieveDataExchangeConfiguration(Connection var1, String var2, String var3, String var4) throws SQLException;

    public void storeDataExchangeConfiguration(Connection var1, String var2, String var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8) throws SQLException, IOException;

    public String getDatabaseDataStoreId(Connection var1) throws SQLException;
}

