/*
 * Decompiled with CFR 0.152.
 */
package usace.cwms.db.dao.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class CwmsDbClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = Logger.getLogger(CwmsDbClassLoader.class.getName());
    private static final Pattern CLASSPATH_PATTERN = Pattern.compile(File.pathSeparator);
    private static final PathMatcher JAR_PATH_MATCHER = FileSystems.getDefault().getPathMatcher("glob:*.jar");
    private static final Map<String, CwmsDbClassLoader> _classLoaderCache = new HashMap<String, CwmsDbClassLoader>();
    private final Map<String, Class<?>> _classes = new HashMap();

    private CwmsDbClassLoader(Set<String> classPath) {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
        try {
            for (String path : classPath) {
                this.addURL(CwmsDbClassLoader.stringToUrl(Paths.get(path, new String[0])));
            }
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, e, () -> "Invalid classpath settings: " + classPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClassLoader getInstance(String classPath) {
        ClassLoader retval = Thread.currentThread().getContextClassLoader();
        if (classPath == null || classPath.trim().isEmpty()) return retval;
        try {
            classPath = URLDecoder.decode(classPath, "UTF-8");
            retval = _classLoaderCache.get(classPath);
            if (retval != null) return retval;
            Class<CwmsDbClassLoader> clazz = CwmsDbClassLoader.class;
            synchronized (CwmsDbClassLoader.class) {
                retval = _classLoaderCache.get(classPath);
                if (retval != null) return retval;
                Set<String> urls = CwmsDbClassLoader.parseClassPath(classPath);
                LOGGER.log(Level.CONFIG, "Creating CwmsDbClassLoader instance for path: {0}", classPath);
                LOGGER.log(Level.FINER, "Creating CwmsDbClassLoader instance for paths: {0}", urls);
                retval = new CwmsDbClassLoader(urls);
                _classLoaderCache.put(classPath, (CwmsDbClassLoader)retval);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return retval;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Invalid classpath settings: " + classPath, e);
        }
        return retval;
    }

    private static Set<String> parseClassPath(String classPath) {
        HashSet<String> classPathUrls = new HashSet<String>();
        String[] implPaths = CLASSPATH_PATTERN.split(classPath);
        try {
            for (String implPath : implPaths) {
                Path path = Paths.get(implPath, new String[0]);
                LOGGER.log(Level.FINER, "Looking in directory: {0} for CwmsDbDao implementations", path.toAbsolutePath());
                if (!path.toFile().isDirectory()) continue;
                classPathUrls.addAll(CwmsDbClassLoader.parseClassPathDirectory(path));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e, () -> "Invalid classpath setting: " + classPath);
        }
        return classPathUrls;
    }

    private static URL stringToUrl(Path path) throws MalformedURLException {
        return path.toUri().toURL();
    }

    private static Set<String> parseClassPathDirectory(Path path) throws IOException {
        HashSet<String> classPathUrls = new HashSet<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            for (Path file : stream) {
                if (file.toFile().isDirectory() || !JAR_PATH_MATCHER.matches(file)) continue;
                classPathUrls.add(file.toRealPath(new LinkOption[0]).toString());
            }
        }
        return classPathUrls;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> retval = null;
        try {
            String filePath = name.replace('.', '/');
            Enumeration<URL> resources = this.getResources(filePath + ".class");
            if (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                retval = this.readClassFromResource(name, resource);
                if (resources.hasMoreElements() && LOGGER.isLoggable(Level.FINE)) {
                    StringBuilder append = new StringBuilder("Found duplicate class: ").append(filePath).append(" in multiple jars: ").append(resource);
                    while (resources.hasMoreElements()) {
                        append.append(";").append(resources.nextElement());
                    }
                    append.append(". Using class found in: ").append(resource);
                    LOGGER.log(Level.FINE, append.toString());
                }
            }
        }
        catch (IOException | RuntimeException pae) {
            LOGGER.log(Level.FINEST, pae, () -> "Unable to load class: " + name);
            throw new ClassNotFoundException();
        }
        return retval;
    }

    private Class<?> readClassFromResource(String name, URL resource) throws ClassNotFoundException {
        Class<?> clazz;
        BufferedInputStream reader = new BufferedInputStream(resource.openStream());
        try {
            Class<?> retval;
            byte[] classBytes = new byte[reader.available()];
            int bytesRead = reader.read(classBytes);
            if (bytesRead < 0) {
                LOGGER.log(Level.FINEST, "No bytes read: {0}", name);
            }
            CodeSource cs = new CodeSource(resource, (Certificate[])null);
            clazz = retval = this.defineClass(name, classBytes, 0, classBytes.length, cs);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException e) {
                LOGGER.log(Level.FINEST, e, () -> "Unable to load class: " + name);
                throw new ClassNotFoundException(name);
            }
        }
        reader.close();
        return clazz;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.findResources(name);
    }

    @Override
    public synchronized Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> loadedClass = this._classes.get(name);
        if (loadedClass == null) {
            block4: {
                try {
                    loadedClass = this.getParent().loadClass(name);
                }
                catch (ClassNotFoundException | RuntimeException t) {
                    LOGGER.log(Level.FINEST, "Unable to read class from parent classloader, will try in current dependencies", t);
                    loadedClass = this.findClass(name);
                    if (loadedClass == null) break block4;
                    this._classes.put(name, loadedClass);
                }
            }
            if (loadedClass == null) {
                throw new ClassNotFoundException("Couldn't load class: " + name);
            }
        }
        return loadedClass;
    }
}

