/*
 * Decompiled with CFR 0.152.
 */
package usace.cwms.db.dao.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import usace.cwms.db.dao.ifc.IOracleTypeMap;
import usace.cwms.db.dao.util.TranslateMethod;

public class OracleTypeMap
implements IOracleTypeMap {
    public static final TimeZone GMT_TIME_ZONE;
    public static final int RMACONST_UNDEF_INT = Integer.MIN_VALUE;
    public static final double RMACONST_UNDEF_DOUBLE = Double.NEGATIVE_INFINITY;
    public static final double RMACONST_MISSING_DOUBLE = -901.0;
    public static final double RMACONST_HEC_UNDEFINED_FLOAT = -3.4028234663852886E38;
    public static final double RMACONST_HEC_UNDEFINED_DOUBLE = -3.4028234663852886E38;
    public static final int RMACONST_MISSING_INT = -901;
    public static final int RMACONST_HEC_UNDEFINED_INT = Integer.MIN_VALUE;
    public static final long RMACONST_HEC_UNDEFINED_LONG = Long.MIN_VALUE;
    private static final Logger LOGGER;
    private static final Map<Class<?>, Map<Class<?>, Method>> METHOD_HASH;
    private final Calendar _gmtCalendar = Calendar.getInstance(GMT_TIME_ZONE);

    protected static BigInteger toBigInteger(Timestamp pStartTime) {
        BigInteger retval = null;
        if (pStartTime != null) {
            retval = BigInteger.valueOf(pStartTime.getTime());
        }
        return retval;
    }

    protected static BigInteger toBigInteger(Long value) {
        BigInteger retval = null;
        if (value != null) {
            retval = BigInteger.valueOf(value);
        }
        return retval;
    }

    protected static BigInteger toBigInteger(int pRevokeTimeout) {
        return BigInteger.valueOf(pRevokeTimeout);
    }

    public static Date buildDate(Timestamp timestamp) {
        Date retval = null;
        if (timestamp != null) {
            retval = new Date(timestamp.getTime());
        }
        return retval;
    }

    public static String getTimeZoneId(TimeZone timeZone) {
        String retval = null;
        if (timeZone != null) {
            retval = timeZone.getID();
        }
        return retval;
    }

    public static OracleTypeMap getInstance() {
        return new OracleTypeMap();
    }

    public static TimeZone getGmtTimeZone() {
        return GMT_TIME_ZONE;
    }

    public static boolean isValidValue(double v) {
        return !Double.isInfinite(v) && !Double.isNaN(v) && v != Double.NEGATIVE_INFINITY && v != -901.0 && v != -3.4028234663852886E38;
    }

    public static boolean isValidValue(int v) {
        return v != Integer.MIN_VALUE && v != -901 && v != Integer.MIN_VALUE;
    }

    public static DateFormat gmtDateFormat() {
        SimpleDateFormat gmtDateFormat = new SimpleDateFormat("HHmm ddMMMyyyy z");
        gmtDateFormat.setTimeZone(GMT_TIME_ZONE);
        return gmtDateFormat;
    }

    public static boolean parseBool(String str) {
        if ("T".equalsIgnoreCase(str)) {
            return true;
        }
        return Boolean.parseBoolean(str);
    }

    public static String formatBool(Boolean tf) {
        String parsed = null;
        if (tf != null) {
            parsed = tf != false ? "T" : "F";
        }
        return parsed;
    }

    public static boolean containsColumnIgnoreCase(ResultSetMetaData metaData, String columnName) throws SQLException {
        int columns = metaData.getColumnCount();
        for (int x = 1; x <= columns; ++x) {
            if (!columnName.equalsIgnoreCase(metaData.getColumnName(x))) continue;
            return true;
        }
        return false;
    }

    public static void checkMetaData(ResultSetMetaData metaData, List<String> columnList, String type) throws SQLException {
        int columnCount = metaData.getColumnCount();
        ArrayList<String> metadataColumns = new ArrayList<String>();
        LOGGER.log(Level.FINE, "{0} column dump.", type);
        for (int ii = 1; ii <= columnCount; ++ii) {
            Iterator columnName = metaData.getColumnName(ii).toUpperCase();
            metadataColumns.add((String)((Object)columnName));
            LOGGER.log(Level.FINE, "{0}: {1}", new Object[]{ii, columnName});
        }
        Collections.sort(metadataColumns);
        if (!metadataColumns.containsAll(columnList)) {
            StringBuilder sb = new StringBuilder();
            sb.append(type).append(" columns do not match expected names.\nExpected: ");
            for (String s : columnList) {
                sb.append(s).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(".\nReceived: ");
            for (String s : metadataColumns) {
                sb.append(s).append(", ");
            }
            sb.setLength(sb.length() - 2);
            ArrayList<String> missing = new ArrayList<String>(columnList);
            missing.removeAll(metadataColumns);
            sb.append(".\nMising: ");
            for (String s : missing) {
                sb.append(s).append(", ");
            }
            sb.setLength(sb.length() - 2);
            throw new SQLException(sb.toString());
        }
    }

    public static String buildString(Clob clob) throws IOException, SQLException {
        StringBuilder buffer = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(clob.getCharacterStream());){
            String n;
            while ((n = reader.readLine()) != null) {
                buffer.append(n);
            }
        }
        return buffer.toString();
    }

    public static double buildDouble(BigDecimal bigDecimal) {
        return bigDecimal == null ? 0.0 : bigDecimal.doubleValue();
    }

    public static BigDecimal toBigDecimal(Number locationAttribute) {
        return locationAttribute == null ? null : BigDecimal.valueOf(locationAttribute.doubleValue());
    }

    public static long buildLong(BigInteger num) {
        return num == null ? 0L : num.longValue();
    }

    public static Timestamp buildTimestamp(Date date) {
        Timestamp retval = null;
        if (date != null) {
            retval = new Timestamp(date.getTime());
        }
        return retval;
    }

    public Object getTranslatedType(Object value, Class<?> valueType, Class<?> returnType) throws IllegalAccessException, InvocationTargetException {
        Object retval = null;
        Map<Class<?>, Method> paramMap = this.getMethodMap().get(valueType);
        if (paramMap != null) {
            Method method = paramMap.get(returnType);
            retval = this.translateType(valueType, method, value, returnType);
        } else {
            LOGGER.log(Level.WARNING, "Unable to find translation method for: " + valueType.getSimpleName());
        }
        return retval;
    }

    protected Map<Class<?>, Map<Class<?>, Method>> getMethodMap() {
        return METHOD_HASH;
    }

    private Object translateType(Class<?> valueType, Method method, Object value, Class<?> returnType) throws IllegalAccessException, InvocationTargetException {
        Object retval = null;
        if (method != null) {
            retval = method.invoke((Object)this, value);
        } else {
            LOGGER.log(Level.WARNING, "Unable to find translation method for " + valueType.getSimpleName() + " that has a return type of: " + returnType.getSimpleName());
        }
        return retval;
    }

    public Calendar getGmtCalendar() {
        return this._gmtCalendar;
    }

    public static ZoneId toZoneId(String zoneId, String locationId) {
        ZoneId retval = null;
        if (zoneId != null) {
            try {
                retval = ZoneId.of(zoneId);
            }
            catch (DateTimeException e) {
                if ("Unknown or Not Applicable".equalsIgnoreCase(zoneId)) {
                    LOGGER.log(Level.FINE, e, () -> "Location " + locationId + " has an undefined time zone");
                }
                retval = OracleTypeMap.getNonStandardZoneId(zoneId, locationId, e, retval);
            }
        }
        return retval;
    }

    private static ZoneId getNonStandardZoneId(String zoneId, String locationId, DateTimeException e, ZoneId retval) {
        try {
            HashMap<String, String> shortIds = new HashMap<String, String>(ZoneId.SHORT_IDS);
            shortIds.put("Canada/East-Saskatchewan", "Canada/Saskatchewan");
            shortIds.put("ROC", "Asia/Taipei");
            shortIds.put("US/Pacific-New", "US/Pacific");
            ZoneId correctedZoneId = ZoneId.of(zoneId, shortIds);
            LOGGER.log(Level.WARNING, () -> "Location " + locationId + " uses a desupported Short ID time zone: " + zoneId + ". It should be updated to use a valid Time Zone ID instead of an abbreviation. Resolving to time zone id: " + correctedZoneId);
            retval = correctedZoneId;
        }
        catch (DateTimeException e2) {
            if (LOGGER.isLoggable(Level.FINE)) {
                e.addSuppressed(e2);
                LOGGER.log(Level.WARNING, e, () -> "Location " + locationId + " has an invalid location time zone: " + zoneId);
            }
            LOGGER.log(Level.WARNING, () -> "Location " + locationId + " has an invalid location time zone: " + zoneId);
        }
        return retval;
    }

    static {
        Map paramMap;
        Class<?> returnType;
        Class<?> parameterType;
        Class<?>[] parameterTypes;
        TranslateMethod annotation;
        Method[] declaredMethods;
        GMT_TIME_ZONE = TimeZone.getTimeZone("UTC");
        LOGGER = Logger.getLogger(OracleTypeMap.class.getName());
        METHOD_HASH = new HashMap();
        for (Method declaredMethod : declaredMethods = OracleTypeMap.class.getDeclaredMethods()) {
            annotation = declaredMethod.getAnnotation(TranslateMethod.class);
            if (annotation == null || (parameterTypes = declaredMethod.getParameterTypes()).length != 1) continue;
            parameterType = parameterTypes[0];
            returnType = declaredMethod.getReturnType();
            paramMap = METHOD_HASH.computeIfAbsent(parameterType, k -> new HashMap());
            paramMap.put(returnType, declaredMethod);
        }
        for (Method declaredMethod : declaredMethods = OracleTypeMap.class.getDeclaredMethods()) {
            annotation = declaredMethod.getAnnotation(TranslateMethod.class);
            if (annotation == null || (parameterTypes = declaredMethod.getParameterTypes()).length != 1) continue;
            parameterType = parameterTypes[0];
            returnType = declaredMethod.getReturnType();
            paramMap = METHOD_HASH.computeIfAbsent(parameterType, k -> new HashMap());
            paramMap.put(returnType, declaredMethod);
        }
    }
}

