/*
 * Decompiled with CFR 0.152.
 */
package usace.cwms.db.dao.util;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ResultSetUtil {
    private static final Logger LOGGER = Logger.getLogger(ResultSetUtil.class.getName());

    private ResultSetUtil() {
        throw new AssertionError((Object)"private ctor. helper class");
    }

    public static void checkMetaData(ResultSetMetaData metaData, List<String> columnList, String type) throws SQLException {
        int columnCount = metaData.getColumnCount();
        ArrayList<String> metadataColumns = new ArrayList<String>();
        LOGGER.log(Level.FINE, "{0} column dump.", type);
        for (int ii = 1; ii <= columnCount; ++ii) {
            String columnName = metaData.getColumnName(ii).toUpperCase();
            metadataColumns.add(columnName);
            LOGGER.log(Level.FINE, "{0}: {1}", new Object[]{ii, columnName});
        }
        if (!metadataColumns.containsAll(columnList)) {
            StringBuilder sb = new StringBuilder();
            sb.append(type).append(" columns do not match expected names.\nExpected: ");
            for (String s : columnList) {
                sb.append(s).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(".\nReceived: ");
            for (String s : metadataColumns) {
                sb.append(s).append(", ");
            }
            sb.setLength(sb.length() - 2);
            throw new SQLException(sb.toString());
        }
    }
}

