/*
 * Decompiled with CFR 0.152.
 */
package usace.cwms.db.dao.util.connection;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import usace.cwms.db.dao.util.connection.ConnectionInfo;

public class ConnectionInfoImpl
implements ConnectionInfo {
    private static final long serialVersionUID = -2664104664240913508L;
    private static final Pattern TNSNAME_FORMAT_MATCHER = Pattern.compile("(?<=\\(SERVICE_NAME=)[a-zA-Z0-9_.-]*(?=\\))", 8);
    private String _dburl;

    public ConnectionInfoImpl(String dburl) {
        Objects.requireNonNull(dburl);
        this._dburl = dburl;
    }

    public ConnectionInfoImpl(ConnectionInfo connectionInfo) {
        this(connectionInfo.getUrl());
    }

    public static String getDatabaseInstance(String dbUrl) {
        int idx;
        String instance = null;
        if (dbUrl != null && (idx = dbUrl.indexOf(64)) != -1) {
            instance = dbUrl.substring(idx + 1);
            Matcher matcher = TNSNAME_FORMAT_MATCHER.matcher(instance.toUpperCase());
            if (matcher.find()) {
                instance = matcher.group();
            } else {
                int index = instance.lastIndexOf(58);
                if (index != -1) {
                    instance = instance.substring(index + 1);
                }
            }
        }
        return instance;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionInfoImpl)) {
            return false;
        }
        ConnectionInfoImpl that = (ConnectionInfoImpl)o;
        return this._dburl.equalsIgnoreCase(that._dburl);
    }

    public final int hashCode() {
        return Objects.hash(this._dburl.toUpperCase());
    }

    @Override
    public String getUrl() {
        return this._dburl;
    }

    public void setUrl(String url) {
        this._dburl = url;
    }

    @Override
    public String getDatabaseInstance() {
        return ConnectionInfoImpl.getDatabaseInstance(this.getUrl());
    }
}

