/*
 * Decompiled with CFR 0.152.
 */
package usace.cwms.db.dao.util.connection;

import java.sql.Connection;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import usace.cwms.db.dao.ifc.IConnectionPool;

final class ConnectionLoggingUtil {
    private static final Logger LOGGER = Logger.getLogger(ConnectionLoggingUtil.class.getName());

    private ConnectionLoggingUtil() {
        throw new AssertionError((Object)"Utility class");
    }

    static void logGetPooledConnection(Connection connection, Class<? extends IConnectionPool> connectionPoolClass) {
        if (LOGGER.isLoggable(Level.FINE)) {
            String uuid = UUID.randomUUID().toString();
            try {
                connection.setClientInfo("OCSID.ACTION", uuid);
            }
            catch (SQLClientInfoException e) {
                LOGGER.log(Level.FINE, "Unable to add unique OpenClock client info", e);
            }
            ConnectionLoggingUtil.logConnectionMethod(connection, "getPooledConnection", "O", connectionPoolClass, uuid);
        }
    }

    static void logClosePooledConnection(Connection connection, Class<? extends IConnectionPool> connectionPoolClass) {
        if (LOGGER.isLoggable(Level.FINE)) {
            String uuid = "";
            try {
                uuid = connection.getClientInfo("OCSID.ACTION");
            }
            catch (SQLException e) {
                LOGGER.log(Level.FINE, "Unable to add unique OpenClock client info", e);
            }
            ConnectionLoggingUtil.logConnectionMethod(connection, "closePooledConnection", "C", connectionPoolClass, uuid);
        }
    }

    private static void logConnectionMethod(Connection c, String method, String stackTraceCode, Class<? extends IConnectionPool> connectionPoolClass, String uuid) {
        StringBuilder stringBuilder = new StringBuilder("OracleConnectionManagement:").append(method).append(":").append(ConnectionLoggingUtil.encodeClass(connectionPoolClass)).append(" ").append(uuid).append("\n").append("Connection Stack Trace:").append(uuid);
        Exception exception = new Exception();
        StackTraceElement[] stackTrace = exception.getStackTrace();
        for (int i = 1; i < stackTrace.length; ++i) {
            stringBuilder.append("\n\t").append("STE").append(stackTraceCode).append(":").append(uuid).append("\t\t").append(stackTrace[i]);
        }
        LOGGER.log(Level.FINE, stringBuilder.toString());
    }

    private static String encodeClass(Class<? extends IConnectionPool> connectionPoolClass) {
        if (connectionPoolClass.getName().toLowerCase().contains("connectionpoolucp")) {
            return "JQ";
        }
        return "NA";
    }
}

