/*
 * Decompiled with CFR 0.152.
 */
package usace.cwms.db.dao.util.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import usace.cwms.db.dao.ifc.IConnectionPool;
import usace.cwms.db.dao.util.DaoServiceUndefinedException;
import usace.cwms.db.dao.util.connection.ConnectionLoggingUtil;
import usace.cwms.db.dao.util.connection.ConnectionLoginInfo;
import usace.cwms.db.dao.util.connection.ConnectionLoginInfoImpl;
import usace.cwms.db.dao.util.message.JdbcConnectionListener;
import usace.cwms.db.dao.util.services.CwmsDbConnectionPoolLookup;

public final class CwmsDbConnectionPool {
    public static final String ROW_PREFETCH_PROPERTY = "cwms.db.rowprefetch";
    private static final Logger LOGGER = Logger.getLogger(CwmsDbConnectionPool.class.getName());
    private static final CwmsDbConnectionPool INSTANCE = new CwmsDbConnectionPool();
    private static final List<IConnectionPool> _connectionPools = new CopyOnWriteArrayList<IConnectionPool>();
    private Set<JdbcConnectionListener> _connectionListeners = new HashSet<JdbcConnectionListener>();

    private CwmsDbConnectionPool() {
        LOGGER.log(Level.FINEST, "CwmsDbConnectionPool singleton created");
    }

    public static void startTrace(Connection connection) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Starting trace for connection", new Exception());
        }
        try {
            List<IConnectionPool> pools = CwmsDbConnectionPool.getInstance().getConnectionPools(connection);
            for (IConnectionPool pool : pools) {
                pool.startTrace(connection);
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e, () -> "Unable to start trace: " + e.getMessage());
        }
    }

    public static CwmsDbConnectionPool getInstance() {
        return INSTANCE;
    }

    public static void close(Connection connection) throws SQLException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Returning borrowed connection", new Exception());
        }
        for (JdbcConnectionListener connectionListener : CwmsDbConnectionPool.getInstance().getConnectionListeners()) {
            connectionListener.jdbcConnectionClosingEvent(connection);
        }
        if (connection != null) {
            for (IConnectionPool pool : _connectionPools) {
                Set<Connection> connectionSet;
                if (pool == null) continue;
                Map<Connection, DataSource> connectionDSMap = pool.getConnectionDSMap();
                DataSource dataSource = connectionDSMap.get(connection);
                Map<DataSource, Set<Connection>> connectionMap = pool.getConnectionMap();
                if (connectionMap != null && dataSource != null && (connectionSet = connectionMap.get(dataSource)) != null) {
                    connectionSet.remove(connection);
                }
                connectionDSMap.remove(connection);
                ConnectionLoggingUtil.logClosePooledConnection(connection, pool.getClass());
                connection.close();
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                int hashcode = connection.hashCode();
                LOGGER.log(Level.FINER, "Closing connection : {0} : {1} : {2}", new Object[]{Thread.currentThread().getName(), connection, hashcode});
            }
        }
    }

    public static void close(Connection connection, OracleTransactionControl transactionControl, Savepoint savePoint) throws SQLException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Returning borrowed connection", new Exception());
        }
        switch (transactionControl) {
            case COMMIT: {
                CwmsDbConnectionPool.commit(connection);
                break;
            }
            case ROLLBACK: {
                CwmsDbConnectionPool.rollback(connection, savePoint);
                break;
            }
        }
        CwmsDbConnectionPool.close(connection);
    }

    private static void commit(Connection connection) throws SQLException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Committing borrowed connection", new Exception());
        }
        connection.commit();
    }

    private static void rollback(Connection connection, Savepoint savePoint) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Rolling back borrowed connection", new Exception());
        }
        if (savePoint != null) {
            connection.rollback(savePoint);
        } else {
            connection.rollback();
        }
    }

    public DataSource getDataSource(ConnectionLoginInfo ci) throws SQLException {
        DataSource retval = null;
        List<IConnectionPool> connectionPools = this.getConnectionPools(ci);
        for (IConnectionPool connectionPool : connectionPools) {
            DataSource dataSource = connectionPool.getDataSource(ci);
            if (dataSource == null) continue;
            retval = dataSource;
            break;
        }
        return retval;
    }

    public Connection getNormalConnection(ConnectionLoginInfo ci) throws SQLException {
        Connection retval = null;
        Iterator<IConnectionPool> iterator = this.getConnectionPools(ci).iterator();
        if (!iterator.hasNext()) {
            throw new DaoServiceUndefinedException("No Connection Pools found in service lookup");
        }
        IConnectionPool pool = iterator.next();
        retval = pool.getNormalConnection(ci);
        ConnectionLoggingUtil.logGetPooledConnection(retval, pool.getClass());
        return retval;
    }

    public String getSchemaVersion(Connection conn) throws SQLException {
        String retval = "";
        Iterator<IConnectionPool> iterator = _connectionPools.iterator();
        if (iterator.hasNext()) {
            retval = iterator.next().getSchemaVersion(conn);
        }
        return retval;
    }

    public Connection getConnection(ConnectionLoginInfo ci, String actionMetricsId) throws SQLException {
        Iterator<IConnectionPool> iterator = this.getConnectionPools(ci).iterator();
        if (!iterator.hasNext()) {
            throw new DaoServiceUndefinedException("No Connection Pools found in service lookup");
        }
        IConnectionPool pool = iterator.next();
        Connection retval = pool.getConnection(ci, actionMetricsId);
        ConnectionLoggingUtil.logGetPooledConnection(retval, pool.getClass());
        return retval;
    }

    public Connection getConnection(ConnectionLoginInfo ci) throws SQLException {
        return this.getConnection(ci, null);
    }

    private Iterable<JdbcConnectionListener> getConnectionListeners() {
        ArrayList<JdbcConnectionListener> retval = new ArrayList<JdbcConnectionListener>();
        for (IConnectionPool connectionPool : _connectionPools) {
            for (JdbcConnectionListener listener : connectionPool.getConnectionListeners()) {
                retval.add(listener);
            }
        }
        retval.addAll(this._connectionListeners);
        return retval;
    }

    public synchronized void setMaxConnections(ConnectionLoginInfo ci, int maxConnections) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Setting max connections", new Exception());
        }
        List<IConnectionPool> connectionPools = this.getConnectionPools(ci);
        for (IConnectionPool connectionPool : connectionPools) {
            connectionPool.setMaxConnections(ci, maxConnections);
        }
    }

    public synchronized void closeDataSource(ConnectionLoginInfo ci) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Closing data source for url: " + ci.getUrl(), new Exception());
        }
        List<IConnectionPool> connectionPools = this.getConnectionPools(ci);
        for (IConnectionPool connectionPool : connectionPools) {
            connectionPool.closeDataSource(ci);
        }
    }

    public synchronized void closeAll() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.INFO, "Closing all connections", new Exception());
        } else {
            LOGGER.log(Level.INFO, "Closing all connections");
        }
        for (IConnectionPool connectionPool : _connectionPools) {
            connectionPool.closeAll();
        }
    }

    public void addJdbcConnectionListener(JdbcConnectionListener listener) {
        this._connectionListeners.add(listener);
        for (IConnectionPool connectionPool : _connectionPools) {
            connectionPool.addJdbcConnectionListener(listener);
        }
    }

    public void removeJdbcConnectionListener(JdbcConnectionListener listener) {
        this._connectionListeners.remove(listener);
        for (IConnectionPool connectionPool : _connectionPools) {
            connectionPool.removeJdbcConnectionListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IConnectionPool> getConnectionPools(ConnectionLoginInfo cli) throws SQLException {
        if (_connectionPools.isEmpty() && cli != null) {
            CwmsDbConnectionPool cwmsDbConnectionPool = this;
            synchronized (cwmsDbConnectionPool) {
                if (_connectionPools.isEmpty()) {
                    _connectionPools.addAll(CwmsDbConnectionPoolLookup.lookupConnectionPools(cli));
                    for (IConnectionPool connectionPool : _connectionPools) {
                        for (JdbcConnectionListener connectionListener : this._connectionListeners) {
                            connectionPool.removeJdbcConnectionListener(connectionListener);
                            connectionPool.addJdbcConnectionListener(connectionListener);
                        }
                    }
                }
            }
        }
        return _connectionPools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IConnectionPool> getConnectionPools(Connection connection) throws SQLException {
        if (_connectionPools.isEmpty() && connection != null) {
            CwmsDbConnectionPool cwmsDbConnectionPool = this;
            synchronized (cwmsDbConnectionPool) {
                if (_connectionPools.isEmpty()) {
                    _connectionPools.addAll(CwmsDbConnectionPoolLookup.lookupConnectionPools(connection));
                    for (IConnectionPool connectionPool : _connectionPools) {
                        for (JdbcConnectionListener connectionListener : this._connectionListeners) {
                            connectionPool.removeJdbcConnectionListener(connectionListener);
                            connectionPool.addJdbcConnectionListener(connectionListener);
                        }
                    }
                }
            }
        }
        return _connectionPools;
    }

    public void testUnauthenticatedConnection(String jdbcUrl) throws SQLException {
        List<IConnectionPool> connectionPools = this.getConnectionPools(new ConnectionLoginInfoImpl(jdbcUrl, "", "", ""));
        if (connectionPools.isEmpty()) {
            // empty if block
        }
        for (IConnectionPool connectionPool : connectionPools) {
            connectionPool.testUnauthenticatedConnection(jdbcUrl);
        }
    }

    public static enum OracleTransactionControl {
        COMMIT,
        NO_COMMIT,
        ROLLBACK;

    }
}

