/*
 * Decompiled with CFR 0.152.
 */
package usace.cwms.db.dao.util.connection;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import usace.cwms.db.dao.util.connection.ConnectionInfoImpl;
import usace.cwms.db.dao.util.connection.ConnectionLoginInfo;

public class EncryptedConnectionLoginInfoImpl
implements ConnectionLoginInfo {
    private static final Logger LOGGER = Logger.getLogger(EncryptedConnectionLoginInfoImpl.class.getName());
    private static final long serialVersionUID = -3618927250166721252L;
    private static final int KEY_SIZE_FOR_RSA = 1024;
    private transient PrivateKey _privateKey;
    private final PublicKey _publicKey;
    private transient Cipher _cipher;
    private List<byte[]> _encryptedPasswordBytes;
    private List<byte[]> _encryptedDburlBytes;
    private List<byte[]> _encryptedUserBytes;
    private List<byte[]> _encryptedOfficeBytes;
    private List<byte[]> _encryptedSessionKeyBytes;

    public EncryptedConnectionLoginInfoImpl(PublicKey publicKey, ConnectionLoginInfo connectionLoginInfo) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        this._publicKey = publicKey;
        String url = connectionLoginInfo.getUrl();
        this._encryptedDburlBytes = this.encrypt(publicKey, url);
        String user = connectionLoginInfo.getUser();
        this._encryptedUserBytes = this.encrypt(publicKey, user);
        String password = connectionLoginInfo.getPassword();
        this._encryptedPasswordBytes = this.encrypt(publicKey, password);
        this._encryptedOfficeBytes = this.encrypt(publicKey, connectionLoginInfo.getUserOfficeId());
        this._encryptedSessionKeyBytes = this.encrypt(publicKey, connectionLoginInfo.getSessionKey());
    }

    private List<byte[]> encrypt(PublicKey publicKey, String textToEncrypt) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        ArrayList<byte[]> retval = new ArrayList<byte[]>();
        if (textToEncrypt != null) {
            byte[] bytes = textToEncrypt.getBytes();
            Cipher cipher = this.getCipher();
            cipher.init(1, publicKey);
            int i = 0;
            int keySize = 1024;
            if (publicKey instanceof RSAKey) {
                keySize = ((RSAKey)((Object)publicKey)).getModulus().bitLength();
            }
            while (i <= bytes.length) {
                int end = i + (keySize / 8 - 11);
                byte[] block = Arrays.copyOfRange(bytes, i, Math.min(bytes.length, end));
                retval.add(cipher.doFinal(block));
                i = end;
            }
        }
        return retval;
    }

    private Cipher getCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (this._cipher == null) {
            this._cipher = Cipher.getInstance(this._publicKey.getAlgorithm());
        }
        return this._cipher;
    }

    private String decrypt(PrivateKey privateKey, List<byte[]> encryptedBytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte[] b : encryptedBytes) {
            Cipher cipher = this.getCipher();
            cipher.init(2, privateKey);
            stringBuilder.append(new String(cipher.doFinal(b)));
        }
        return stringBuilder.toString();
    }

    private PrivateKey getPrivateKey() {
        return this._privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this._privateKey = privateKey;
    }

    private String decryptString(List<byte[]> encryptedBytes) {
        String retval = null;
        PrivateKey privateKey = this.getPrivateKey();
        if (privateKey != null) {
            try {
                retval = this.decrypt(privateKey, encryptedBytes);
            }
            catch (GeneralSecurityException e) {
                LOGGER.log(Level.INFO, "Error decrypting data.", e);
            }
        }
        return retval;
    }

    @Override
    public String getPassword() {
        return this.decryptString(this._encryptedPasswordBytes);
    }

    @Override
    public void setPassword(String password) {
        try {
            this._encryptedPasswordBytes = this.encrypt(this._publicKey, password);
        }
        catch (GeneralSecurityException e) {
            LOGGER.log(Level.INFO, "Error encrypting data", e);
        }
    }

    @Override
    public String getUser() {
        return this.decryptString(this._encryptedUserBytes);
    }

    @Override
    public void setUser(String user) {
        try {
            this._encryptedUserBytes = this.encrypt(this._publicKey, user);
        }
        catch (GeneralSecurityException e) {
            LOGGER.log(Level.INFO, "Error encrypting data", e);
        }
    }

    @Override
    public String getUrl() {
        return this.decryptString(this._encryptedDburlBytes);
    }

    @Override
    public void setUrl(String url) {
        try {
            this._encryptedDburlBytes = this.encrypt(this._publicKey, url);
        }
        catch (GeneralSecurityException e) {
            LOGGER.log(Level.INFO, "Error encrypting data.", e);
        }
    }

    @Override
    public String getDatabaseInstance() {
        return ConnectionInfoImpl.getDatabaseInstance(this.getUrl());
    }

    public int hashCode() {
        String password;
        String user;
        StringBuilder sb = new StringBuilder();
        String dbUrl = this.getUrl();
        if (dbUrl != null) {
            sb.append(dbUrl);
        }
        if ((user = this.getUser()) != null) {
            sb.append(user);
        }
        if ((password = this.getPassword()) != null) {
            sb.append(password);
        }
        return sb.toString().hashCode();
    }

    public boolean equals(Object obj) {
        boolean retval;
        if (this == obj) {
            retval = true;
        } else if (obj == null || obj.getClass() != this.getClass()) {
            retval = false;
        } else {
            EncryptedConnectionLoginInfoImpl cli = (EncryptedConnectionLoginInfoImpl)obj;
            String url = this.getUrl();
            String user = this.getUser();
            String password = this.getPassword();
            String cliUrl = cli.getUrl();
            String cliUser = cli.getUser();
            String cliPassword = cli.getPassword();
            boolean urlsEqual = url == null && cliUrl == null || url != null && url.equals(cliUrl);
            boolean usersEqual = user == null && cliUser == null || user != null && user.equals(cliUser);
            boolean passwordsEqual = password == null && cliPassword == null || password != null && password.equals(cliPassword);
            retval = urlsEqual && usersEqual && passwordsEqual;
        }
        return retval;
    }

    @Override
    public String getUserOfficeId() {
        return this.decryptString(this._encryptedOfficeBytes);
    }

    @Override
    public void setUserOfficeId(String officeId) {
        try {
            this._encryptedOfficeBytes = this.encrypt(this._publicKey, officeId);
        }
        catch (GeneralSecurityException e) {
            LOGGER.log(Level.INFO, "Error encrypting data.", e);
        }
    }

    @Override
    public String getSessionKey() {
        String retval = this.decryptString(this._encryptedSessionKeyBytes);
        if (retval == null || retval.isEmpty()) {
            retval = null;
        }
        return retval;
    }
}

