/*
 * Decompiled with CFR 0.152.
 */
package usace.cwms.db.dao.util.services;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.lookup.Lookup;
import rma.util.lookup.Lookups;
import usace.cwms.db.dao.util.CwmsDbClassLoader;
import usace.cwms.db.dao.util.services.CwmsDbServiceLookup;
import usace.cwms.db.dao.util.services.CwmsLookupFactory;

public abstract class AbstractCwmsDbLookupFactory
implements CwmsLookupFactory {
    public static final String META_INF_IMPL_ATTRIBUTE = "CWMS Impl Info";
    private static final Logger LOGGER = Logger.getLogger(AbstractCwmsDbLookupFactory.class.getName());
    protected static final String META_INF_IMPL_ATTRIBUTE_VALUE = "cwms-impl-name";

    public String getImplClasspath() {
        String retval = "";
        if (CwmsDbServiceLookup.IMPL_CLASSPATHS != null) {
            String[] classPaths;
            for (String classPath : classPaths = CwmsDbServiceLookup.IMPL_CLASSPATHS.split(File.pathSeparator)) {
                if (!this.isImplDirectory(classPath)) continue;
                retval = classPath;
                break;
            }
        }
        return retval;
    }

    private boolean isImplDirectory(String directory) {
        boolean retval = false;
        Path implDirectory = Paths.get(directory, new String[0]);
        if (implDirectory.toFile().isDirectory()) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(implDirectory);){
                for (Path file : directoryStream) {
                    String classPathImpl = null;
                    if ((classPathImpl = this.findClassPathFromJar(file, classPathImpl)) == null || !classPathImpl.equalsIgnoreCase(this.getImplName())) continue;
                    retval = true;
                    break;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e, () -> "Unable to read files in directory: " + implDirectory);
            }
        }
        return retval;
    }

    private String findClassPathFromJar(Path file, String classPathImpl) {
        try (JarFile jarFile = new JarFile(file.toFile());){
            Attributes attr;
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (attr = manifest.getAttributes(META_INF_IMPL_ATTRIBUTE)) != null) {
                classPathImpl = attr.getValue(META_INF_IMPL_ATTRIBUTE_VALUE);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e, () -> "Unable to read files in directory: " + file);
        }
        return classPathImpl;
    }

    @Override
    public <T> T lookupCwmsDb(Class<T> aClass, String path) {
        String classPath = this.getImplClasspath();
        ClassLoader l = CwmsDbClassLoader.getInstance(classPath);
        Lookup lookup = Lookups.metaInfServices((ClassLoader)l, (String)("META-INF/namedservices/" + path + "/"));
        return (T)lookup.lookup(aClass);
    }

    @Override
    public <T> Collection<? extends T> lookupCwmsDbs(Class<T> aClass, String path) {
        String classPath = this.getImplClasspath();
        ClassLoader l = CwmsDbClassLoader.getInstance(classPath);
        Lookup lookup = Lookups.metaInfServices((ClassLoader)l, (String)("META-INF/namedservices/" + path + "/"));
        return lookup.lookupAll(aClass);
    }

    protected String getImplName() {
        Attributes attr;
        String implName = "";
        Manifest manifest = this.retrieveManifest();
        if (manifest != null && (attr = manifest.getAttributes(META_INF_IMPL_ATTRIBUTE)) != null) {
            implName = attr.getValue(META_INF_IMPL_ATTRIBUTE_VALUE);
        }
        return implName;
    }

    protected abstract Manifest retrieveManifest();
}

