/*
 * Decompiled with CFR 0.152.
 */
package usace.cwms.db.dao.util.services;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import usace.cwms.db.dao.ifc.IConnectionPool;
import usace.cwms.db.dao.util.connection.ConnectionLoginInfo;
import usace.cwms.db.dao.util.services.CwmsDbServiceLookup;
import usace.cwms.db.dao.util.services.CwmsLookupFactory;

public final class CwmsDbConnectionPoolLookup {
    private static final Logger LOGGER = Logger.getLogger(CwmsDbConnectionPoolLookup.class.getName());

    private CwmsDbConnectionPoolLookup() {
        throw new AssertionError((Object)"private ctor for factory class");
    }

    public static List<IConnectionPool> lookupConnectionPools(ConnectionLoginInfo cli) throws SQLException {
        ArrayList<IConnectionPool> connectionPools = new ArrayList<IConnectionPool>();
        Collection<? extends CwmsLookupFactory> lookupFactories = CwmsDbServiceLookup.lookupCwmsLookupFactories();
        for (CwmsLookupFactory cwmsLookupFactory : lookupFactories) {
            Collection<? extends IConnectionPool> services = CwmsDbConnectionPoolLookup.loadService(cwmsLookupFactory, IConnectionPool.class);
            if (services.isEmpty()) {
                LOGGER.log(Level.SEVERE, " No connection pools available. No access to the database is available. Please check project configuration.");
            }
            for (IConnectionPool iConnectionPool : services) {
                try {
                    if (iConnectionPool == null || !iConnectionPool.testCompatibility(cli)) continue;
                    connectionPools.add(iConnectionPool);
                }
                catch (SQLException e) {
                    LOGGER.log(Level.SEVERE, "Unable to test Connection Pool compatibility.", e);
                }
            }
        }
        return connectionPools;
    }

    public static Set<IConnectionPool> lookupConnectionPools(Connection connection) throws SQLException {
        HashSet<IConnectionPool> connectionPools = new HashSet<IConnectionPool>();
        Collection<? extends CwmsLookupFactory> lookupFactories = CwmsDbServiceLookup.lookupCwmsLookupFactories();
        for (CwmsLookupFactory cwmsLookupFactory : lookupFactories) {
            Collection<? extends IConnectionPool> services = CwmsDbConnectionPoolLookup.loadService(cwmsLookupFactory, IConnectionPool.class);
            for (IConnectionPool iConnectionPool : services) {
                try {
                    if (iConnectionPool == null || !iConnectionPool.testCompatibility(connection)) continue;
                    connectionPools.add(iConnectionPool);
                }
                catch (SQLException e) {
                    LOGGER.log(Level.SEVERE, "Unable to test Connection Pool compatibility.", e);
                }
            }
        }
        return connectionPools;
    }

    private static Collection<? extends IConnectionPool> loadService(CwmsLookupFactory factory, Class<IConnectionPool> aClass) {
        return factory.lookupCwmsDbs(aClass, "cwms/db");
    }
}

