/*
 * Decompiled with CFR 0.152.
 */
package usace.cwms.db.dao.util.services;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.services.annotations.ServiceProvider;
import rma.util.lookup.Lookup;
import usace.metrics.services.MetricsApp;
import usace.metrics.services.MetricsService;
import usace.metrics.services.MetricsServiceProvider;
import usace.metrics.services.MetricsUtil;
import usace.metrics.services.config.MetricsConfig;
import usace.metrics.services.config.MetricsConfigBuilder;

@ServiceProvider(service=MetricsServiceProvider.class, path="cwmsdb_metrics", position=0)
public class CwmsDbMetricsServiceProvider
implements MetricsServiceProvider {
    private static final Logger LOGGER = Logger.getLogger(CwmsDbMetricsServiceProvider.class.getSimpleName());
    public static final String SERVICE_PATH = "cwmsdb_metrics";
    public static final int SERVICE_POSITION = 0;
    private MetricsService _service;
    private final Object _lock = new Object();

    protected MetricsApp getMetricsApp() {
        return (MetricsApp)Lookup.getDefault().lookup(MetricsApp.class);
    }

    private void init() {
        MetricsApp app = this.getMetricsApp();
        String appName = this.getAppName(app);
        Properties cwmsDbConfig = this.getConfigurationFile(appName);
        MetricsConfig config = this.buildMetricsConfig(cwmsDbConfig, app, appName);
        this._service = new MetricsService(config);
    }

    protected MetricsConfig buildMetricsConfig(Properties cwmsDbConfig, MetricsApp app, String appName) {
        MetricsConfigBuilder builder = new MetricsConfigBuilder();
        if (cwmsDbConfig != null) {
            builder.withPropertiesFile(cwmsDbConfig);
        }
        MetricsConfig appConfig = null;
        if (app != null) {
            appConfig = app.getAppConfig();
        }
        Properties appOverrides = this.buildCwmsDbOverrideProperties(appName);
        builder.withPropertiesFile(appOverrides);
        if (appConfig != null) {
            builder.withBackingConfiguration(appConfig);
        }
        MetricsConfig config = builder.withSystemPropertyOptions().build();
        return config;
    }

    protected Properties buildCwmsDbOverrideProperties(String appName) {
        Properties appOverrides = new Properties();
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd kkmm-ss");
        String filePrefix = format.format(now);
        appOverrides.setProperty("metrics-file-location", "CwmsDb" + appName);
        appOverrides.setProperty("metrics-file-prefix", filePrefix);
        return appOverrides;
    }

    protected String getAppName(MetricsApp app) {
        String appName = "";
        if (app != null && (appName = app.getAppName()) == null) {
            appName = "";
        }
        return appName;
    }

    private Properties getConfigurationFile(String appName) {
        String configFileProperty = this.getConfigPropertyName(appName);
        Properties output = null;
        try {
            output = MetricsUtil.readPropertiesFromSystemProperty((String)configFileProperty);
        }
        catch (FileNotFoundException ex) {
            LOGGER.log(Level.WARNING, "Unable to find file for CwmsDb Metrics configuration.", ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Exception occurred while reading CwmsDb metrics configuration file.", ex);
        }
        return output;
    }

    private String getConfigPropertyName(String appName) {
        Object configFileProperty = "cwms.db";
        if (!appName.isEmpty()) {
            configFileProperty = (String)configFileProperty + "." + appName.toLowerCase();
        }
        configFileProperty = (String)configFileProperty + ".config";
        return configFileProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricsService getMetricsService() {
        if (this._service == null) {
            Object object = this._lock;
            synchronized (object) {
                if (this._service == null) {
                    this.init();
                }
            }
        }
        return this._service;
    }
}

