/*
 * Decompiled with CFR 0.152.
 */
package usace.cwms.db.dao.util.services;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import rma.util.lookup.Lookup;
import rma.util.lookup.Lookups;
import usace.cwms.db.dao.ifc.CwmsDbSchemaCompatible;
import usace.cwms.db.dao.ifc.IOracleTypeMap;
import usace.cwms.db.dao.util.CwmsDatabaseVersionInfoFactory;
import usace.cwms.db.dao.util.CwmsDbClassLoader;
import usace.cwms.db.dao.util.DaoServiceUndefinedException;
import usace.cwms.db.dao.util.JdbcTypeUtil;
import usace.cwms.db.dao.util.message.AQMessageSubscriberFactory;
import usace.cwms.db.dao.util.services.CwmsLookupFactory;

public final class CwmsDbServiceLookup {
    public static final String CWMS_DB_SERVICE_PATH = "cwms/db";
    public static final String CWMS_DB_AQ_CONNECTION_PROVIDER_PATH = "cwms/db/aq";
    public static final String CWMS_DB_IMPL_CLASSPATHS = "cwms.db.impl.classpaths";
    public static final String CWMS_DB_CWMS_LOOKUP_FACTORY_PATH = "cwms/db/lookupfactory";
    public static final String META_INF_SERVICES_PATH = "META-INF/namedservices/";
    public static final String IMPL_CLASSPATHS = System.getProperty("cwms.db.impl.classpaths");

    private CwmsDbServiceLookup() {
        throw new AssertionError((Object)"private ctor in helper class");
    }

    public static <T extends CwmsDbSchemaCompatible> T buildCwmsDb(Class<T> aClass, Connection conn) throws SQLException {
        return CwmsDbServiceLookup.buildCwmsDb(aClass, conn, CWMS_DB_SERVICE_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<? extends CwmsLookupFactory> lookupCwmsLookupFactories() throws SQLException {
        Collection cwmsLookupFactories;
        ClassLoader cl = CwmsDbClassLoader.getInstance(IMPL_CLASSPATHS);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            Lookup lookup = Lookups.metaInfServices((ClassLoader)cl, (String)"META-INF/namedservices/cwms/db/lookupfactory/");
            cwmsLookupFactories = lookup.lookupAll(CwmsLookupFactory.class);
            if (cwmsLookupFactories.isEmpty()) {
                throw new SQLException("No implementation lookup service available. No access to the database is available. Please check project configuration. Trying to use cwms.db.impl.classpaths path: " + IMPL_CLASSPATHS);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return cwmsLookupFactories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends CwmsDbSchemaCompatible> T buildCwmsDb(Class<T> aClass, Connection conn, String path) throws SQLException {
        CwmsDbSchemaCompatible cwmsDb = null;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = CwmsDbClassLoader.getInstance(IMPL_CLASSPATHS);
            Thread.currentThread().setContextClassLoader(cl);
            Collection<? extends CwmsLookupFactory> factoryServices = CwmsDbServiceLookup.lookupCwmsLookupFactories();
            for (CwmsLookupFactory cwmsLookupFactory : factoryServices) {
                CwmsDbSchemaCompatible service = (CwmsDbSchemaCompatible)cwmsLookupFactory.lookupCwmsDb(aClass, path);
                if (service == null || !service.testCompatibility(conn)) continue;
                cwmsDb = service;
                break;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        if (cwmsDb == null) {
            throw new DaoServiceUndefinedException("Unable to lookup a service for: " + aClass);
        }
        return (T)cwmsDb;
    }

    public static AQMessageSubscriberFactory lookupAQMessageSubscriberFactory() throws SQLException {
        return CwmsDbServiceLookup.lookupClass(AQMessageSubscriberFactory.class);
    }

    public static IOracleTypeMap lookupOracleTypeMap() throws SQLException {
        return CwmsDbServiceLookup.lookupClass(IOracleTypeMap.class);
    }

    public static CwmsDatabaseVersionInfoFactory lookupVersionInfoFactory() throws SQLException {
        return CwmsDbServiceLookup.lookupClass(CwmsDatabaseVersionInfoFactory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T lookupClass(Class<T> clazz) throws SQLException {
        T retval = null;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = CwmsDbClassLoader.getInstance(IMPL_CLASSPATHS);
            Thread.currentThread().setContextClassLoader(cl);
            Collection<? extends CwmsLookupFactory> factoryServices = CwmsDbServiceLookup.lookupCwmsLookupFactories();
            for (CwmsLookupFactory cwmsLookupFactory : factoryServices) {
                T service = cwmsLookupFactory.lookupCwmsDb(clazz, CWMS_DB_SERVICE_PATH);
                if (service == null) continue;
                retval = service;
                break;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return retval;
    }

    public static JdbcTypeUtil lookupJdbcTypeUtil() throws SQLException {
        return CwmsDbServiceLookup.lookupClass(JdbcTypeUtil.class);
    }
}

