/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore;

import hec.data.UnitsConversionException;
import hec.heclib.util.HecTime;
import rma.util.RMAConst;

public class ConversionUtils {
    private static final double ATM_TO_PA = 9.8692316931427E-6;
    private static final double SEC_PER_DAY = 86400.0;
    private static final double CALORIE_TO_JOULE = 4.1868;
    private static final double KNOTS_TO_MPS = 0.5144444444444444;
    private static final double MPH_TO_MPS = 0.44704;
    private static final double SOLAR_CONSTANT = 1361.0;
    private static final double DEFAULT_ATTENUATION_CONSTANT = 0.04;

    public static void convertMJPerM2PerDayToWPerM2(double[] dataValues) throws UnitsConversionException {
        double megaJ2Joule = 1000000.0;
        double convFactor = megaJ2Joule / 86400.0;
        for (int i = 0; i < dataValues.length; ++i) {
            if (!RMAConst.isValidValue((double)dataValues[i])) continue;
            dataValues[i] = convFactor * dataValues[i];
        }
    }

    public static void convertCalPerCm2PerDayToWattPerM2(double[] dataValues) throws UnitsConversionException {
        double sqmeters2sqcms = 10000.0;
        double convFactor = 4.1868 * sqmeters2sqcms / 86400.0;
        for (int i = 0; i < dataValues.length; ++i) {
            if (!RMAConst.isValidValue((double)dataValues[i])) continue;
            dataValues[i] = convFactor * dataValues[i];
        }
    }

    public static void convertRHandTempToMb(double[] rhValues, boolean isRHConstant, double[] airTemps, boolean isAirTConstant, String units) throws UnitsConversionException {
        if (isRHConstant) {
            if (isAirTConstant) {
                ConversionUtils.convertRHandTempToMb(rhValues, airTemps, units);
            } else {
                rhValues = ConversionUtils.convertRHandTempToMb(rhValues[0], airTemps, units);
            }
        } else if (isAirTConstant) {
            ConversionUtils.convertRHandTempToMb(rhValues, airTemps[0], units);
        } else {
            ConversionUtils.convertRHandTempToMb(rhValues, airTemps, units);
        }
    }

    public static void convertRHandTempToMb(double[] rhVals, double[] airTempVals, String units) throws UnitsConversionException {
        for (int i = 0; i < rhVals.length; ++i) {
            if (!RMAConst.isValidValue((double)rhVals[i])) continue;
            rhVals[i] = ConversionUtils.rhAndTempToMb(rhVals[i], airTempVals[i], units);
        }
    }

    public static void convertRHandTempToMb(double[] rhVals, double airTempVal, String units) throws UnitsConversionException {
        for (int i = 0; i < rhVals.length; ++i) {
            if (!RMAConst.isValidValue((double)rhVals[i])) continue;
            rhVals[i] = ConversionUtils.rhAndTempToMb(rhVals[i], airTempVal, units);
        }
    }

    public static double[] convertRHandTempToMb(double rhVal, double[] airTempVals, String units) throws UnitsConversionException {
        double[] dataValues = new double[airTempVals.length];
        for (int i = 0; i < airTempVals.length; ++i) {
            dataValues[i] = RMAConst.isValidValue((double)airTempVals[i]) ? ConversionUtils.rhAndTempToMb(rhVal, airTempVals[i], units) : airTempVals[i];
        }
        return dataValues;
    }

    public static void airTempToSatVapPresMb(double[] airTemp) {
        for (int i = 0; i < airTemp.length; ++i) {
            if (!RMAConst.isValidValue((double)airTemp[i])) continue;
            airTemp[i] = ConversionUtils.esat(airTemp[i]);
        }
    }

    private static double esat(double temp) {
        return 6.11 * Math.pow(10.0, 7.5 * temp / (237.3 + temp));
    }

    public static double rhAndTempToMb(double rh, double airt, String units) throws UnitsConversionException {
        if (units.contains("Relative") || units.contains("RH") || units.contains("%")) {
            return rh / 100.0 * ConversionUtils.esat(airt);
        }
        if (units.contains("Wetbulb")) {
            double easat = ConversionUtils.esat(rh);
            double factor = 6.6E-4 * (1.0 + 0.00115 * rh);
            double atmP = 1000.0;
            return easat - factor * atmP * (airt - rh);
        }
        throw new UnitsConversionException("Error: units string " + units + " not recognized in conversion of humidity data to water vapor pressure.");
    }

    public static double elevationToPressurePa(double meters) {
        if (RMAConst.isValidValue((double)meters)) {
            return 101325.0 * Math.pow(1.0 - 2.2557700000000003E-5 * meters, 5.25588);
        }
        return meters;
    }

    public static double elevationToPressureAtm(double meters) {
        return ConversionUtils.convertPaToAtm(ConversionUtils.elevationToPressurePa(meters));
    }

    public static double convertPaToAtm(double paVal) {
        if (RMAConst.isValidValue((double)paVal)) {
            return 9.8692316931427E-6 * paVal;
        }
        return paVal;
    }

    public static void convertPaToAtm(double[] paVals) {
        for (int i = 0; i < paVals.length; ++i) {
            if (!RMAConst.isValidValue((double)paVals[i])) continue;
            paVals[i] = ConversionUtils.convertPaToAtm(paVals[i]);
        }
    }

    public static double convertKPaToAtm(double kPaVal) {
        if (RMAConst.isValidValue((double)kPaVal)) {
            return ConversionUtils.convertPaToAtm(1000.0 * kPaVal);
        }
        return kPaVal;
    }

    public static void convertKPaToAtm(double[] kpaVals) {
        for (int i = 0; i < kpaVals.length; ++i) {
            if (!RMAConst.isValidValue((double)kpaVals[i])) continue;
            kpaVals[i] = ConversionUtils.convertKPaToAtm(kpaVals[i]);
        }
    }

    public static void knotsToMetersPerSecond(double[] dataValues) {
        for (int i = 0; i < dataValues.length; ++i) {
            if (!RMAConst.isValidValue((double)dataValues[i])) continue;
            dataValues[i] = 0.5144444444444444 * dataValues[i];
        }
    }

    public static void mphToMetersPerSecond(double[] dataValues) {
        for (int i = 0; i < dataValues.length; ++i) {
            if (!RMAConst.isValidValue((double)dataValues[i])) continue;
            dataValues[i] = 0.44704 * dataValues[i];
        }
    }

    public static double computeSolarRaditation(HecTime hecTime, double lat, double lon, double standardMeridian, double dat, double dewpt, double cloud) throws UnitsConversionException {
        hecTime.showTimeAsBeginningOfDay(false);
        double dayOfYear = hecTime.dayOfYear();
        double timeOfDay = (double)hecTime.secondsSinceMidnight() / 3600.0;
        double phi = Math.toRadians(lat);
        double con1 = 0.01721420632103996;
        double rearth = 1.0 + 0.017 * Math.cos(con1 * (186.0 - dayOfYear));
        double rr = rearth * rearth;
        double declination = Math.toRadians(23.45) * Math.cos(con1 * (172.0 - dayOfYear));
        double eqOfTime = 1.21E-4 - 0.12319 * Math.sin(con1 * (dayOfYear - 1.0) - 0.07014) - 0.16549 * Math.sin(2.0 * con1 * (dayOfYear - 1.0) + 0.3088);
        double deltSl = -(lon - standardMeridian) / 15.0;
        double con6 = 3.819718634205488;
        double declina = Math.abs(declination);
        double arccos = Math.tan(phi) * Math.tan(declina);
        double stm = Math.abs(arccos);
        if (stm >= 1.0) {
            throw new UnitsConversionException("computeSolarRaditation.latitude > 66.55  deg. Cannot compute sunrise/sunset");
        }
        if (arccos != 0.0) {
            double xx = Math.sqrt(1.0 - arccos * arccos);
            xx /= arccos;
            arccos = Math.abs(Math.atan(xx));
            if (xx > 0.0) {
                if (declination > 0.0) {
                    arccos = Math.PI - arccos;
                }
            } else if (declination < 0.0) {
                arccos = Math.PI - arccos;
            }
        } else {
            arccos = 1.5707963267948966;
        }
        double stSunrise = 12.0 - con6 * arccos + deltSl;
        double stSunset = 24.0 - stSunrise + 2.0 * deltSl;
        double daylen = stSunset - stSunrise;
        double stBegin = timeOfDay - 0.016666666666666666;
        double stEnd = timeOfDay + 0.016666666666666666;
        boolean alphaT_is_neg = false;
        double solarRad = 0.0;
        if (stEnd < stSunrise || stBegin > stSunset) {
            solarRad = 0.0;
        } else {
            if (stBegin < stSunrise) {
                stBegin = stSunrise;
            }
            if (stEnd > stSunset) {
                stEnd = stSunset;
            }
            double tb = stBegin - 12.0 - deltSl + eqOfTime;
            double te = stEnd - 12.0 - deltSl + eqOfTime;
            double talt = (tb + te) / 2.0;
            solarRad = Math.sin(phi) * Math.sin(declination) * (te - tb) + con6 * Math.cos(phi) * Math.cos(declination) * (Math.sin(te / con6) - Math.sin(tb / con6));
            solarRad *= 1361.0 / rr;
            double alphaT = Math.sin(phi) * Math.sin(declination) + Math.cos(phi) * Math.cos(declination) * Math.cos(talt / con6);
            if (alphaT == 1.0) {
                alphaT = 1.5707963267948966;
            } else if (alphaT == -1.0) {
                alphaT = -1.5707963267948966;
            } else if (alphaT < 0.01) {
                solarRad = 0.0;
                alphaT_is_neg = true;
            } else {
                double y = Math.sqrt(1.0 - alphaT * alphaT);
                y = alphaT / y;
                alphaT = Math.atan(y);
            }
            if (!alphaT_is_neg) {
                if (dewpt < 0.01) {
                    dewpt = 10.0;
                }
                double pwc = 0.02936 * Math.exp(0.08802 * dewpt);
                double elevat = 1.0;
                double elexp = Math.exp(-elevat / 771.76);
                double con3 = 57.29577951308232;
                double oam = elexp / (Math.sin(alphaT) + 0.15 * Math.pow(alphaT * con3 + 3.885, -1.253));
                double a1 = Math.exp(-(0.465 + 0.0408 * pwc) * (0.129 + 0.171 * Math.exp(-0.88 * oam)) * oam);
                double a2 = Math.exp(-(0.465 + 0.0408 * pwc) * (0.179 + 0.421 * Math.exp(-0.721 * oam)) * oam);
                double cs = 1.0 - 0.65 * cloud * cloud;
                double ar = 1.18;
                double br = -0.77;
                if (cloud >= 0.99) {
                    ar = 0.35;
                    br = -0.45;
                } else if (cloud >= 0.5) {
                    ar = 0.95;
                    br = -0.75;
                } else if (cloud >= 0.1) {
                    ar = 2.2;
                    br = -0.97;
                }
                double rs = ar * Math.pow(con3 * alphaT, br);
                if (dat < 0.0) {
                    dat = 0.0;
                }
                double atc = (a2 + 0.5 * (1.0 - a1 - dat)) / (1.0 - 0.5 * rs * 0.5 * (1.0 - a1 - dat));
                atc = Math.max(atc, 0.0);
                solarRad *= atc * cs * (1.0 - rs);
                solarRad = Math.max(solarRad, 0.0);
            }
        }
        return solarRad *= 30.0;
    }
}

