/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import hec.io.PairedDataContainer;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.SeasonalRecord;
import hec.wqenginecore.dataSource.pairedData.PairedData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.KebabCaseStrategy.class)
public final class SeasonalVariationData {
    private final int _interpolationType;
    private final PairedData _pairedData;
    @JsonIgnore
    private transient SeasonalRecord _seasonalRecord = new SeasonalRecord();

    @JsonCreator
    public SeasonalVariationData(@JsonProperty(value="interpolationType") int interpolationType, @JsonProperty(value="pairedData") PairedData pairedData) {
        this._interpolationType = interpolationType;
        this._pairedData = pairedData;
        this.updateSeasonalRecord();
    }

    public int getInterpolationType() {
        return this._interpolationType;
    }

    public PairedData getPairedData() {
        return this._pairedData;
    }

    @JsonIgnore
    public SeasonalRecord getSeasonalRecord() {
        if (this._seasonalRecord == null) {
            this.updateSeasonalRecord();
        }
        return this._seasonalRecord;
    }

    @JsonIgnore
    private void updateSeasonalRecord() {
        this._seasonalRecord.clear();
        if (this._pairedData == null) {
            return;
        }
        PairedDataContainer pdContainer = this._pairedData.getPairedDataContainer();
        if (pdContainer == null) {
            return;
        }
        double[] x = pdContainer.getXOridnates();
        double[] y = pdContainer.getYOridnates()[0];
        int n = 0;
        for (int i = 0; i < x.length; ++i) {
            if (!SeasonalVariationData.checkValid(x[i]) || !SeasonalVariationData.checkValid(y[i])) continue;
            ++n;
        }
        int[] time = new int[n + 2];
        double[] vals = new double[n + 2];
        time[0] = 1;
        vals[0] = y[0];
        int index = 1;
        for (int i = 0; i < x.length; ++i) {
            if (!SeasonalVariationData.checkValid(x[i]) || !SeasonalVariationData.checkValid(y[i])) continue;
            time[index] = (int)x[i];
            vals[index] = y[i];
            ++index;
        }
        time[index] = 525600;
        vals[index] = vals[n];
        this._seasonalRecord.setArrays(time, vals);
        this._seasonalRecord.setInterpolationType(this._interpolationType);
    }

    @JsonIgnore
    static boolean checkValid(double value) {
        return value != -3.4028234663852886E38 && (int)value != Integer.MIN_VALUE && value != Double.NEGATIVE_INFINITY;
    }

    @JsonIgnore
    public double getInterpolatedValue(RunTimeWindow rtw, int rssStep) {
        if (this._seasonalRecord == null) {
            this.updateSeasonalRecord();
        }
        RunTimeStep rtStep = new RunTimeStep(rtw);
        rtStep.setStep(rssStep);
        return this._seasonalRecord.interpolate(rtStep);
    }
}

