/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore;

import java.util.ArrayList;

public class WQConsistencyCheck {
    private ArrayList<String> _warningMessages = null;
    private ArrayList<String> _errorMessages = null;
    private String _datasetName = null;

    public WQConsistencyCheck(String datasetName) {
        this._datasetName = datasetName;
    }

    public String getDatasetName() {
        return this._datasetName;
    }

    public void addWarningMessage(String warningMessage) {
        if (this._warningMessages == null) {
            this._warningMessages = new ArrayList();
        }
        this._warningMessages.add(warningMessage);
    }

    public void addErrorMessage(String errorMessage) {
        if (this._errorMessages == null) {
            this._errorMessages = new ArrayList();
        }
        this._errorMessages.add(errorMessage);
    }

    public int getNumWarnings() {
        int numWarnings = 0;
        if (this._warningMessages != null) {
            numWarnings = this._warningMessages.size();
        }
        return numWarnings;
    }

    public int getNumErrors() {
        int numErrors = 0;
        if (this._errorMessages != null) {
            numErrors = this._errorMessages.size();
        }
        return numErrors;
    }

    public ArrayList<String> getWarningMessages() {
        return this._warningMessages;
    }

    public ArrayList<String> getErrorMessages() {
        return this._errorMessages;
    }

    public boolean hasWarnings() {
        return this.getNumWarnings() > 0;
    }

    public boolean hasErrors() {
        return this.getNumErrors() > 0;
    }

    public boolean hasWarningsOrErrors() {
        return this.hasWarnings() || this.hasErrors();
    }
}

