/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore;

import hec.io.DSSIdentifier;
import hec.lang.annotation.Scriptable;
import hec.wqenginecore.BoundaryCondition;
import hec.wqenginecore.BoundaryConditionSet;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.ConversionUtils;
import hec.wqenginecore.DataProvider;
import hec.wqenginecore.InitialCondition;
import hec.wqenginecore.InitialConditionSet;
import hec.wqenginecore.InterpICValue;
import hec.wqenginecore.InterpolationType;
import hec.wqenginecore.OutputVariableOptions;
import hec.wqenginecore.Region;
import hec.wqenginecore.RegionSet;
import hec.wqenginecore.SimpleInitialCondition;
import hec.wqenginecore.SimpleInitialConditionSet;
import hec.wqenginecore.WQException;
import hec.wqenginecore.WQParamTimeVarData;
import hec.wqenginecore.WQReachHydro;
import hec.wqenginecore.WQResHydro;
import hec.wqenginecore.WQTime;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.ambient.AmbientData;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.dispersion.AlternateMixingMethod;
import hec.wqenginecore.dispersion.DispersionCoefSettings;
import hec.wqenginecore.dispersion.MunkAndersonDispersionData;
import hec.wqenginecore.dispersion.ReachDispersionSettings;
import hec.wqenginecore.dispersion.ReachDispersionType;
import hec.wqenginecore.dispersion.ReachDispersionValues;
import hec.wqenginecore.dispersion.ReservoirDispersionEntrainmentSettings;
import hec.wqenginecore.dispersion.ReservoirDispersionSettings;
import hec.wqenginecore.dispersion.ReservoirEntrainmentInflowSetting;
import hec.wqenginecore.dispersion.StabilityDispersionData;
import hec.wqenginecore.dispersion.ValueByReachType;
import hec.wqenginecore.dispersion.WindDispersionData;
import hec.wqenginecore.geometry.BoundaryType;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.MetAssignmentSet;
import hec.wqenginecore.geometry.RegionRef;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainBoundary;
import hec.wqenginecore.geometry.SubDomainBoundaryRef;
import hec.wqenginecore.geometry.SubDomainJunction;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqenginecore.geometry.SubDomainType;
import hec.wqenginecore.geometry.WQControlDevice;
import hec.wqenginecore.massinjection.MassInjectionConstituentData;
import hec.wqenginecore.massinjection.MassInjectionReservoirType;
import hec.wqenginecore.massinjection.MassInjectionSet;
import hec.wqenginecore.massinjection.MassInjectionSite;
import hec.wqenginecore.massinjection.MassInjectionSiteData;
import hec.wqenginecore.massinjection.MassInjectionType;
import hec.wqenginecore.metstation.MetStation;
import hec.wqenginecore.metstation.MetStationSet;
import hec.wqenginecore.metstation.MetVariable;
import hec.wqenginecore.metstation.MetVariableTypes;
import hec.wqenginecore.metstation.ShortWaveRadiationUnits;
import hec.wqenginecore.parameter.Parameter;
import hec.wqenginecore.parameter.ParameterSet;
import hec.wqenginecore.parameter.ParameterSetting;
import hec.wqenginecore.parameter.ParameterSettingValue;
import hec.wqenginecore.parameter.WQParameterType;
import hec.wqenginecore.utility.ClassLoaderLibraryLoader;
import hec.wqenginecore.utility.Unloadable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import mil.army.usace.hec.metadata.UnitUtil;
import mil.army.usace.hec.metadata.UnitsConversionException;
import rma.util.RMAConst;

public class WQEngineAdapter {
    private static Unloadable _libLoader = null;

    public static synchronized void loadLibraries() {
        String libStr = "libiomp5md,libmmd,svml_dispmd,libifcoremd,libifcoremdd,WQnative";
        libStr = System.getProperty("WQLibraries", libStr);
        List<String> libs = Arrays.asList(libStr.split(","));
        if (Boolean.getBoolean("WQUnload")) {
            if (_libLoader != null) {
                WQEngineAdapter.unloadLibraries();
            }
            _libLoader = new ClassLoaderLibraryLoader();
            _libLoader.load(libs);
        } else {
            for (String lib : libs) {
                System.loadLibrary(lib);
            }
        }
    }

    public static synchronized void unloadLibraries() {
        if (_libLoader != null) {
            _libLoader.unload();
            _libLoader = null;
        }
    }

    public native void jniSetLogFilename(String var1, int var2, NativeCallRtnInfo var3);

    public native void jniInit(int var1, NativeCallRtnInfo var2);

    public native void jniSetFlowComputeType(int var1, NativeCallRtnInfo var2);

    public native void jniSetNumThreads(int var1, NativeCallRtnInfo var2);

    public native void jniSetSolutionOrder(int var1, NativeCallRtnInfo var2);

    public native void jniSetConservationType(int var1, NativeCallRtnInfo var2);

    public native void jniSetWQSubdomainIds(int var1, int[] var2, NativeCallRtnInfo var3);

    public native void jniSetSubDomainName(int var1, String var2, int var3, NativeCallRtnInfo var4);

    public native void jniSetSubDomainGeo(int var1, int var2, int var3, int var4, int var5, int[][] var6, int[][] var7, int[] var8, double[] var9, NativeCallRtnInfo var10);

    public native void jniSetReachRoutingInfo(int var1, int var2, NativeCallRtnInfo var3);

    public native void jniSetResElevStorArea(int var1, int var2, double[][] var3, int var4, double[][] var5, int var6, NativeCallRtnInfo var7);

    public native void jniSetNumResParentOutletElems(int var1, int var2, NativeCallRtnInfo var3);

    public native void jniSetResOutletData(int var1, int var2, int var3, double[] var4, double[] var5, NativeCallRtnInfo var6);

    public native void jniSetResOutletBCData(int var1, int var2, int[] var3, NativeCallRtnInfo var4);

    public native void jniSetNumResTCDs(int var1, int var2, NativeCallRtnInfo var3);

    public native void jniSetResTCDData(int var1, int var2, int[] var3, int var4, double[] var5, boolean[] var6, double[] var7, double[] var8, double[] var9, double var10, NativeCallRtnInfo var12);

    public native void jniReallocateResTCDData(int var1, int var2, int var3, double[] var4, NativeCallRtnInfo var5);

    public native void jniSetResTCDElev(int var1, int var2, int var3, double[] var4, NativeCallRtnInfo var5);

    public native void jniSetShastaTCDInfo(int var1, int var2, int[] var3, int[] var4, int[] var5, int[] var6, NativeCallRtnInfo var7);

    public native void jniSetWQSubdomainBoundaryIds(int var1, int[] var2, NativeCallRtnInfo var3);

    public native void jniSetSubDomainBoundaryName(int var1, String var2, int var3, NativeCallRtnInfo var4);

    public native void jniSetSubDomainBoundary(int var1, int var2, int[] var3, NativeCallRtnInfo var4);

    public native void jniSetDistToResDam(int var1, double var2, NativeCallRtnInfo var4);

    public native void jniSetBoundaryInflowDepth(int var1, double var2, NativeCallRtnInfo var4);

    public native void jniSetWQSubdomainJunctionIds(int var1, int[] var2, NativeCallRtnInfo var3);

    public native void jniSetJunctionName(int var1, String var2, int var3, NativeCallRtnInfo var4);

    public native void jniSetSubDomainJunction(int var1, int var2, int[] var3, NativeCallRtnInfo var4);

    public native void jniSetWQRegionIds(int var1, int[] var2, NativeCallRtnInfo var3);

    public native void jniSetWQSubdomainRegion(int var1, int var2, NativeCallRtnInfo var3);

    public native void jniSetRunTimeInfo(String var1, String var2, double var3, double var5, NativeCallRtnInfo var7);

    public native void jniSetParamFilePath(String var1, int var2, String var3, int var4, NativeCallRtnInfo var5);

    public native void jniSetPathwaysTemperature(boolean var1, NativeCallRtnInfo var2);

    public native void jniSetPathwaysGC(boolean var1, NativeCallRtnInfo var2);

    public native void jniSetPathwaysNSM1(boolean var1, NativeCallRtnInfo var2);

    public native void jniSetDerivedVars(boolean var1, NativeCallRtnInfo var2);

    public native void jniSetWQConstituentInfo(int var1, int[] var2, NativeCallRtnInfo var3);

    public native void jniSetWQParameterValuesReal(int var1, int var2, double[] var3, double[] var4, NativeCallRtnInfo var5);

    public native void jniSetWQParameterValuesRealSingleRegion(int var1, int var2, double var3, double var5, NativeCallRtnInfo var7);

    public native void jniSetWQParameterValuesInteger(int var1, int var2, int[] var3, NativeCallRtnInfo var4);

    public native int jniGetNumberWQPathways(NativeCallRtnInfo var1);

    public native int jniGetNumberWQDerivedVars(NativeCallRtnInfo var1);

    public native String jniGetPathwayName(int var1, int var2, NativeCallRtnInfo var3);

    public native String jniGetDerivedVarName(int var1, int var2, NativeCallRtnInfo var3);

    public native String jniGetPathwayUnits(int var1, int var2, NativeCallRtnInfo var3);

    public native String jniGetDerivedVarUnits(int var1, int var2, NativeCallRtnInfo var3);

    public native void jniSetLightFieldParams(NativeCallRtnInfo var1);

    public native void jniSetMetStationIds(int var1, int[] var2, NativeCallRtnInfo var3);

    public native void jniSetMetStationName(int var1, String var2, int var3, NativeCallRtnInfo var4);

    public native void jniSetWQSubdomainMetStation(int var1, int var2, NativeCallRtnInfo var3);

    public native void jniSetMetDataTimeSeries(int var1, int var2, int var3, double[] var4, int var5, NativeCallRtnInfo var6);

    public native void jniSetMetDataConstant(int var1, int var2, double var3, NativeCallRtnInfo var5);

    public native void jniSetICInterpMethod(int var1, int var2, NativeCallRtnInfo var3);

    public native void jniSetICReservoir(int var1, int var2, int var3, double[] var4, double[] var5, boolean var6, NativeCallRtnInfo var7);

    public native void jniSetICReaches(int var1, int var2, int[] var3, double[] var4, NativeCallRtnInfo var5);

    public native void jniSetICReach(int var1, int var2, double var3, NativeCallRtnInfo var5);

    public native void jniSetICJunction(int var1, int var2, double var3, NativeCallRtnInfo var5);

    public native void jniSetBoundaryConcConstant(int var1, int var2, double var3, NativeCallRtnInfo var5);

    public native void jniSetBoundaryConcAmbient(int var1, int var2, int var3, NativeCallRtnInfo var4);

    public native void jniSetBoundaryConcTS(int var1, int var2, int var3, double[] var4, int var5, NativeCallRtnInfo var6);

    public native void jniSetResVertMixingMethod(int var1, int var2, NativeCallRtnInfo var3);

    public native void jniSetDispersionStabilityParameters(int var1, double var2, double var4, double var6, NativeCallRtnInfo var8);

    public native void jniSetDispersionWindParameters(int var1, double var2, double var4, double var6, double var8, NativeCallRtnInfo var10);

    public native void jniSetDispersionMAParameters(int var1, double var2, double var4, double var6, double var8, NativeCallRtnInfo var10);

    public native void jniSetResEntrainment(int var1, double var2, double var4, double var6, double var8, NativeCallRtnInfo var10);

    public native void jniSetResMaxInflowEnvelopeHeight(int var1, double var2, NativeCallRtnInfo var4);

    public native void jniSetResMaxOutflowEnvelopeHeight(int var1, double var2, NativeCallRtnInfo var4);

    public native void jniSetResMixLayerTolerance(int var1, double var2, NativeCallRtnInfo var4);

    public native void jniSetReachDispersionCoefs(int var1, double var2, double var4, NativeCallRtnInfo var6);

    public native void jniSetMassInjectionIds(int var1, int[] var2, NativeCallRtnInfo var3);

    public native void jniSetMIGeometryReach(int var1, int var2, boolean var3, int var4, NativeCallRtnInfo var5);

    public native void jniSetMIGeometryReservoir(int var1, int var2, boolean var3, double var4, NativeCallRtnInfo var6);

    public native void jniSetMIGeometryJnct(int var1, int var2, NativeCallRtnInfo var3);

    public native void jniSetMassInjectionConstitIds(int var1, int var2, int[] var3, NativeCallRtnInfo var4);

    public native void jniSetMIConcConstant(int var1, int var2, double var3, NativeCallRtnInfo var5);

    public native void jniSetMIConcTS(int var1, int var2, int var3, double[] var4, int var5, NativeCallRtnInfo var6);

    public native void jniInitializeMassInjections(NativeCallRtnInfo var1);

    public native void jniFinalizeInitialization(NativeCallRtnInfo var1);

    public native void jniComputeStep(int var1, int var2, NativeCallRtnInfo var3);

    public native double[] jniComputeTCDFlows(int var1, int var2, int var3, int var4, double[] var5, double[] var6, double var7, double var9, NativeCallRtnInfo var11);

    public native void jniSaveState(int var1, NativeCallRtnInfo var2);

    public native void jniRestoreState(int var1, NativeCallRtnInfo var2);

    public native void jniUpdateTimeOffset(int var1, NativeCallRtnInfo var2);

    public native void jniUpdateReachHydro(int var1, int var2, double[] var3, double[] var4, double[] var5, int var6, NativeCallRtnInfo var7);

    public native void jniUpdateResHydro(int var1, double var2, double var4, double var6, int var8, double[] var9, int var10, double[] var11, int var12, double[] var13, int var14, NativeCallRtnInfo var15);

    public native void jniUpdateBoundaryFlow(int var1, double var2, int var4, NativeCallRtnInfo var5);

    public native void jniSetInitialCellVolumes(NativeCallRtnInfo var1);

    public native void jniSetInitialCellVolumesReach(int var1, int var2, double[] var3, NativeCallRtnInfo var4);

    public native void jniFinalizeCompute(NativeCallRtnInfo var1);

    public native void jniSetWQConstituentValAll(int var1, double var2, NativeCallRtnInfo var4);

    public native void jniSetWQConstituentValSubDomain(int var1, int var2, double var3, NativeCallRtnInfo var5);

    public native void jniSetWQConstituentValCell(int var1, int var2, int var3, double var4, NativeCallRtnInfo var6);

    public native void jniSetMinDz(int var1, double var2, NativeCallRtnInfo var4);

    public native void jniSetBoundaryTempSource(int var1, double var2, NativeCallRtnInfo var4);

    public native double[] jniGetWQConstituentVal(int var1, int var2, int var3, int var4, NativeCallRtnInfo var5);

    public native double[] jniGetWQPathwayVal(int var1, int var2, int var3, NativeCallRtnInfo var4);

    public native double[] jniGetWQDerivedVarVal(int var1, int var2, int var3, NativeCallRtnInfo var4);

    public native double jniGetWQConstituentValAtJnct(int var1, int var2, NativeCallRtnInfo var3);

    public native double jniGetWQConstituentValAtReach(int var1, int var2, NativeCallRtnInfo var3);

    public native double jniGetWQConstituentValAtReachEnd(int var1, int var2, NativeCallRtnInfo var3);

    public native double jniGetWQConstituentValAtBoundary(int var1, int var2, NativeCallRtnInfo var3);

    public native double[] jniGetWQConstituentValOutlets(int var1, int var2, int var3, NativeCallRtnInfo var4);

    public native double[] jniGetWQConstituentValTCDInlets(int var1, int var2, int var3, int var4, NativeCallRtnInfo var5);

    public native double jniGetWQConstituentValTCDOptimized(int var1, int var2, NativeCallRtnInfo var3);

    public native double jniGetWQConstituentValFlowElev(int var1, int var2, double var3, double var5, NativeCallRtnInfo var7);

    public native double[] jniGetHydroVal(int var1, int var2, int var3, int var4, NativeCallRtnInfo var5);

    public native int jniGetNumTCDInletLevels(int var1, int var2, NativeCallRtnInfo var3);

    public native double[] jniGetTCDInletElevs(int var1, int var2, int var3, NativeCallRtnInfo var4);

    public native String jniGetVersionNum(NativeCallRtnInfo var1);

    public native void jniSetResThermalMixing(boolean var1, NativeCallRtnInfo var2);

    public void setLogFile(String logFilename) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetLogFilename(logFilename, logFilename.length(), rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void initCompute(int unitSystem) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniInit(unitSystem, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setFlowComputeType(int flowComputeType) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetFlowComputeType(flowComputeType, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setNumThreads(int nThreads) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetNumThreads(nThreads, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setSolutionOrder(int solnOrder) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetSolutionOrder(solnOrder, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setConservationType(int consType) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetConservationType(consType, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setGeoData(Geometry geo) throws WQException {
        if (geo == null) {
            throw new WQException("Water Quality Geometry object is null");
        }
        List<SubDomain> subdomList = geo.getSubDomainsInExtent();
        int nSubDom = subdomList.size();
        int[] sdIds = new int[nSubDom];
        for (int j = 0; j < nSubDom; ++j) {
            sdIds[j] = subdomList.get(j).getId();
        }
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetWQSubdomainIds(nSubDom, sdIds, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        for (SubDomain subdom : subdomList) {
            String sdName = subdom.getName();
            int iwqsd = subdom.getId();
            int iwqsdType = subdom.getTypeId();
            int numCells = subdom.getNumCells();
            int numFaces = subdom.getNumFaces();
            int numFacesInternal = subdom.getNumFacesInternal();
            int[][] faceCells = subdom.get2DArrayFaceCells();
            int[][] cellFaces = subdom.getCellFaces();
            int[] bcidx = subdom.getArrayFlowFaceBoundaryIdx();
            double[] lngth = subdom.getCellLength();
            this.jniSetSubDomainName(iwqsd, sdName, sdName.length(), rtnInfo);
            if (!rtnInfo.isSuccess()) {
                throw new WQException(rtnInfo);
            }
            this.jniSetSubDomainGeo(iwqsd, iwqsdType, numCells, numFaces, numFacesInternal, faceCells, cellFaces, bcidx, lngth, rtnInfo);
            if (!rtnInfo.isSuccess()) {
                throw new WQException(rtnInfo);
            }
            if (subdom.getTypeId() == SubDomainType.RESERVOIR_1DV.id()) {
                double[][] resElevStor = subdom.getElevStorData();
                double[][] resElevArea = subdom.getElevAreaData();
                int elevStorInterpType = subdom.getElevStorInterpType();
                this.jniSetResElevStorArea(iwqsd, resElevStor.length, resElevStor, resElevArea.length, resElevArea, elevStorInterpType, rtnInfo);
                if (!rtnInfo.isSuccess()) {
                    throw new WQException(rtnInfo);
                }
                List<List<Double>> elevList = subdom.getOutletElev();
                List<List<Double>> areaList = subdom.getOutletArea();
                int numParentOutletElems = elevList.size();
                this.jniSetNumResParentOutletElems(iwqsd, numParentOutletElems, rtnInfo);
                if (!rtnInfo.isSuccess()) {
                    throw new WQException(rtnInfo);
                }
                for (int iparentElem = 0; iparentElem < numParentOutletElems; ++iparentElem) {
                    List<Double> outletElevs = elevList.get(iparentElem);
                    List<Double> outletAreas = areaList.get(iparentElem);
                    int numOutlets = outletElevs.size();
                    double[] elevs = new double[numOutlets];
                    double[] areas = new double[numOutlets];
                    for (int j = 0; j < numOutlets; ++j) {
                        elevs[j] = outletElevs.get(j);
                        areas[j] = outletAreas.get(j);
                    }
                    this.jniSetResOutletData(iwqsd, iparentElem, numOutlets, elevs, areas, rtnInfo);
                    if (rtnInfo.isSuccess()) continue;
                    throw new WQException(rtnInfo);
                }
                continue;
            }
            if (subdom.getTypeId() != SubDomainType.REACH_1D.id()) continue;
        }
    }

    public void setReachRoutingInfo(SubDomain subdom, int routingMethod) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetReachRoutingInfo(subdom.getId(), routingMethod, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setBoundaryGeoData(Geometry geo) throws WQException {
        if (geo == null) {
            throw new WQException("Water Quality Geometry object is null");
        }
        this.setWQJnctIdData(geo);
        List<SubDomainBoundary> boundList = geo.getBoundariesInExtent();
        int nSubDomBound = boundList.size();
        int[] sdbIds = new int[nSubDomBound];
        for (int j = 0; j < nSubDomBound; ++j) {
            sdbIds[j] = boundList.get(j).getId();
        }
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetWQSubdomainBoundaryIds(nSubDomBound, sdbIds, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        for (SubDomainBoundary bound : boundList) {
            String sdbName = bound.getName();
            int ibc = bound.getId();
            int ibcType = bound.getBoundaryTypeId();
            int[] connection = new int[2];
            double distToResDam = 0.0;
            connection[0] = bound.getUpstreamSubDomainId();
            connection[1] = bound.getDownstreamSubDomainId();
            if (bound.getBoundaryType() == BoundaryType.LOCAL_DIVERSION) {
                int rssJnctId = bound.getDsDiversionJnctId();
                if (rssJnctId >= 0) {
                    int wqJnctId;
                    connection[1] = wqJnctId = geo.getWQJunction(rssJnctId).getId();
                }
            } else if (connection[1] >= 0 && geo.getSubDomain(connection[1]) != null && geo.getSubDomain(connection[1]).getType() == SubDomainType.RESERVOIR_1DV) {
                distToResDam = bound.getDistToResDam();
            }
            this.jniSetSubDomainBoundaryName(ibc, sdbName, sdbName.length(), rtnInfo);
            if (!rtnInfo.isSuccess()) {
                throw new WQException(rtnInfo);
            }
            this.jniSetSubDomainBoundary(ibc, ibcType, connection, rtnInfo);
            if (!rtnInfo.isSuccess()) {
                throw new WQException(rtnInfo);
            }
            this.jniSetDistToResDam(ibc, distToResDam, rtnInfo);
            if (rtnInfo.isSuccess()) continue;
            throw new WQException(rtnInfo);
        }
        List<SubDomain> subdomList = geo.getSubDomainsInExtent();
        for (SubDomain subdom : subdomList) {
            if (subdom.getTypeId() != SubDomainType.RESERVOIR_1DV.id()) continue;
            List<Integer> bcIdList = subdom.getOutletBCIds();
            int numOutlets = bcIdList.size();
            int[] bcIds = new int[numOutlets];
            for (int iparentElem = 0; iparentElem < numOutlets; ++iparentElem) {
                bcIds[iparentElem] = bcIdList.get(iparentElem);
            }
            this.jniSetResOutletBCData(subdom.getId(), numOutlets, bcIds, rtnInfo);
            if (rtnInfo.isSuccess()) continue;
            throw new WQException(rtnInfo);
        }
    }

    public void setWQControlDeviceData(Geometry geo) throws WQException {
        if (geo == null) {
            throw new WQException("Water Quality Geometry object is null");
        }
        List<SubDomain> subdomList = geo.getSubDomainsInExtent();
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        for (SubDomain subdom : subdomList) {
            List<WQControlDevice> wqControlDevices = subdom.getWqControlDevices();
            if (wqControlDevices == null) continue;
            this.jniSetNumResTCDs(subdom.getId(), wqControlDevices.size(), rtnInfo);
            if (!rtnInfo.isSuccess()) {
                throw new WQException(rtnInfo);
            }
            for (WQControlDevice wqControlDevice : wqControlDevices) {
                int tcdId = wqControlDevice.getId();
                int[] outletIdArray = new int[]{wqControlDevice.getParentOutletIdx(), wqControlDevice.getChildOutletIdx()};
                int numPortLevels = wqControlDevice.getNumPortLevels();
                double[] elevs = wqControlDevice.getPortInvertElevation();
                boolean[] isRect = wqControlDevice.getPortGeomRectangular();
                double[] ht = wqControlDevice.getPortHeight();
                double[] wd = wqControlDevice.getPortWidth();
                double[] diam = wqControlDevice.getPortDiameter();
                double bedElev = wqControlDevice.getBedElevation();
                this.jniSetResTCDData(subdom.getId(), tcdId, outletIdArray, numPortLevels, elevs, isRect, ht, wd, diam, bedElev, rtnInfo);
                if (rtnInfo.isSuccess()) continue;
                throw new WQException(rtnInfo);
            }
        }
    }

    @Scriptable
    public void reallocateWQControlDeviceElevs(SubDomain subdom, WQControlDevice wqControlDevice, int numElevs, double[] elevArray) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniReallocateResTCDData(subdom.getId(), wqControlDevice.getId(), numElevs, elevArray, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setWQControlDeviceElev(SubDomain subdom, int rssElemId, double[] elevs) throws WQException {
        if (subdom == null) {
            throw new WQException("Water Quality Geometry Subdomain object is null");
        }
        List<WQControlDevice> wqControlDevices = subdom.getWqControlDevices();
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        if (wqControlDevices != null) {
            for (WQControlDevice wqControlDevice : wqControlDevices) {
                if (wqControlDevice.getRssReleaseElemId() != rssElemId) continue;
                int tcdId = wqControlDevice.getId();
                int numPortLevels = wqControlDevice.getNumPortLevels();
                if (numPortLevels != elevs.length) {
                    throw new WQException("Number of port levels != length of input elevs array");
                }
                this.jniSetResTCDElev(subdom.getId(), tcdId, numPortLevels, elevs, rtnInfo);
                if (rtnInfo.isSuccess()) continue;
                throw new WQException(rtnInfo);
            }
        }
    }

    public void setShastaTCDInfo(int sdId, int tcdId, int[] sideGateIdx, int[] lowerGateIdx, int[] middleGateIdx, int[] upperGateIdx) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetShastaTCDInfo(sdId, tcdId, sideGateIdx, lowerGateIdx, middleGateIdx, upperGateIdx, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setWQJnctIdData(Geometry geo) throws WQException {
        if (geo == null) {
            throw new WQException("Water Quality Geometry object is null");
        }
        List<SubDomainJunction> jnctList = geo.getWQJunctionsInExtent();
        int nSubDomJnct = jnctList.size();
        int[] sdjIds = new int[nSubDomJnct];
        for (int j = 0; j < nSubDomJnct; ++j) {
            sdjIds[j] = jnctList.get(j).getId();
        }
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetWQSubdomainJunctionIds(nSubDomJnct, sdjIds, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setWQJnctGeoData(Geometry geo) throws WQException {
        if (geo == null) {
            throw new WQException("Water Quality Geometry object is null");
        }
        List<SubDomainJunction> jnctList = geo.getWQJunctionsInExtent();
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        for (SubDomainJunction jnct : jnctList) {
            int ij = jnct.getId();
            String jnctName = jnct.getName();
            List<SubDomainBoundary> bList = jnct.getBoundaryList();
            int nBCs = bList.size();
            int[] bIds = new int[nBCs];
            for (int j = 0; j < nBCs; ++j) {
                SubDomainBoundary sdb = bList.get(j);
                bIds[j] = sdb.getId();
            }
            this.jniSetJunctionName(ij, jnctName, jnctName.length(), rtnInfo);
            if (!rtnInfo.isSuccess()) {
                throw new WQException(rtnInfo);
            }
            this.jniSetSubDomainJunction(ij, nBCs, bIds, rtnInfo);
            if (rtnInfo.isSuccess()) continue;
            throw new WQException(rtnInfo);
        }
    }

    public void setWQRegions(Geometry geo) throws WQException {
        if (geo == null) {
            throw new WQException("Water Quality Geometry object is null");
        }
        RegionSet regionSet = geo.getRegionSet();
        List wqRegions = (List)regionSet.getRegions();
        int nRegions = wqRegions.size();
        int[] regionIds = new int[nRegions];
        for (int ireg = 0; ireg < nRegions; ++ireg) {
            regionIds[ireg] = ((Region)wqRegions.get(ireg)).getId();
        }
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetWQRegionIds(nRegions, regionIds, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        List<SubDomain> subdomList = geo.getSubDomainsInExtent();
        for (Region reg : wqRegions) {
            int regId = reg.getId();
            Collection<SubDomainRef> sdRefList = reg.getElements();
            for (SubDomainRef sdRef : sdRefList) {
                SubDomain wqGeoSD = sdRef.getSubDomain(geo);
                if (!subdomList.contains(wqGeoSD)) continue;
                this.jniSetWQSubdomainRegion(wqGeoSD.getId(), regId, rtnInfo);
                if (rtnInfo.isSuccess()) continue;
                throw new WQException(rtnInfo);
            }
        }
    }

    public void setRunTimeInfo(WQTime wqtime) throws WQException {
        if (wqtime == null) {
            throw new WQException("Water Quality Time object is null");
        }
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetRunTimeInfo(wqtime.getStartTimeString(), wqtime.getEndTimeString(), wqtime.getDeltaTinSec(), wqtime.getWQDeltaTinSec(), rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setParamFilePaths(String libraryName, Path path) throws WQException {
        String pth = path.toAbsolutePath().toString();
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetParamFilePath(libraryName, libraryName.length(), pth, pth.length(), rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setWQConstituentData(ConstituentSet wqConstitSet, OutputVariableOptions options) throws WQException {
        if (wqConstitSet == null) {
            throw new WQException("Water Quality Constituent Set object is null");
        }
        boolean useHeatBudget = options.shouldOutputHeatBudget();
        boolean useGcPathways = options.shouldOutputGeneralPathways();
        boolean useNsm1Pathways = options.shouldOutputNsmPathways();
        boolean useDerivedVars = options.shouldOutputNsmVaribles();
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetPathwaysTemperature(useHeatBudget, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        this.jniSetPathwaysGC(useGcPathways, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        this.jniSetPathwaysNSM1(useNsm1Pathways, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        this.jniSetDerivedVars(useDerivedVars, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        List wqConstitList = (List)wqConstitSet.getConstituentList();
        int nwqc = wqConstitList.size();
        int[] idxList = new int[nwqc];
        int count = 0;
        for (Constituent wqConstit : wqConstitList) {
            idxList[count] = wqConstit.getId();
            ++count;
        }
        this.jniSetWQConstituentInfo(nwqc, idxList, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setWQParameterData(ParameterSet wqParameterSet, Geometry geo, Set<Parameter> params, ArrayList<WQParamTimeVarData> timeVaryingParams) throws WQException {
        Object pSetting;
        RegionRef regRef;
        Region wqRegion;
        int ireg;
        if (wqParameterSet == null) {
            throw new WQException("Water Quality Parameter Set object is null");
        }
        Set<Integer> paramIdSet = wqParameterSet.getParameterIds();
        Set<Integer> paramOptionIdSet = wqParameterSet.getParameterOptionIds();
        RegionSet regionSet = geo.getRegionSet();
        List wqRegions = (List)regionSet.getRegions();
        int nRegions = wqRegions.size();
        timeVaryingParams.clear();
        double missingDataFlag = -9999.0;
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        for (Integer paramId : paramIdSet) {
            double[] valByRegion = new double[nRegions];
            double[] thetaByRegion = new double[nRegions];
            for (ireg = 0; ireg < nRegions; ++ireg) {
                wqRegion = (Region)wqRegions.get(ireg);
                regRef = wqRegion.buildRef();
                pSetting = wqParameterSet.getParameterSetting(paramId, regRef);
                boolean useBase = false;
                if (pSetting == null) {
                    pSetting = wqParameterSet.getParameterSetting(paramId);
                    useBase = true;
                }
                Parameter param = params.stream().filter(p -> p.getId() == paramId.intValue()).findFirst().orElseThrow(() -> new WQException("Data not found for water quality parameter id: " + paramId + " in Region: " + wqRegion.getName()));
                double defaultVal = param.getDefaultValue();
                ParameterSettingValue<?> paramSettingVal = pSetting.getParameterValue();
                if (paramSettingVal.getType() == WQParameterType.Value) {
                    Double val = paramSettingVal.getValue() == null ? Double.valueOf(defaultVal) : (Double)pSetting.getParameterValue().getValue();
                    valByRegion[ireg] = val;
                } else {
                    valByRegion[ireg] = defaultVal;
                    timeVaryingParams.add(new WQParamTimeVarData(wqRegion.getId(), (ParameterSetting)pSetting, param.getName(), defaultVal, useBase));
                }
                Double theta = pSetting.getTheta();
                thetaByRegion[ireg] = Optional.ofNullable(theta).orElse(missingDataFlag);
            }
            this.jniSetWQParameterValuesReal(paramId, nRegions, valByRegion, thetaByRegion, rtnInfo);
            if (rtnInfo.isSuccess()) continue;
            throw new WQException(rtnInfo);
        }
        for (Integer paramOptId : paramOptionIdSet) {
            int[] valByRegion = new int[nRegions];
            for (ireg = 0; ireg < nRegions; ++ireg) {
                wqRegion = (Region)wqRegions.get(ireg);
                regRef = wqRegion.buildRef();
                pSetting = wqParameterSet.getParameterOptionSetting(paramOptId, regRef);
                if (pSetting == null) {
                    pSetting = wqParameterSet.getParameterOptionSetting(paramOptId);
                }
                Integer ival = pSetting.getOption();
                valByRegion[ireg] = ival;
            }
            this.jniSetWQParameterValuesInteger(paramOptId, nRegions, valByRegion, rtnInfo);
            if (rtnInfo.isSuccess()) continue;
            throw new WQException(rtnInfo);
        }
    }

    public void setWQParameterDataSingleRegion(int wqParameterId, int wqRegionId, double wqParamVal, Double wqThetaVal) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        double theta = Optional.ofNullable(wqThetaVal).orElse(-9999.0);
        this.jniSetWQParameterValuesRealSingleRegion(wqParameterId, wqRegionId, wqParamVal, theta, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public String getPathwayName(int pathwayIdx) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        String pwName = this.jniGetPathwayName(pathwayIdx, 80, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return pwName;
    }

    public String getDerivedVarName(int derivedVarIdx) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        String dvName = this.jniGetDerivedVarName(derivedVarIdx, 80, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return dvName;
    }

    public String getPathwayUnits(int pathwayIdx) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        String pwUnits = this.jniGetPathwayUnits(pathwayIdx, 80, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return pwUnits;
    }

    public String getDerivedVarUnits(int derivedVarIdx) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        String dvUnits = this.jniGetDerivedVarUnits(derivedVarIdx, 80, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return dvUnits;
    }

    public void setLightFieldParams() throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetLightFieldParams(rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setMetStations(MetStationSet metStationSet, Geometry geo) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        if (metStationSet != null && geo != null) {
            List<MetStation> metStationList = metStationSet.getActiveStations();
            int nMetStats = metStationList.size();
            int[] metStatIds = new int[nMetStats];
            for (int ims = 0; ims < nMetStats; ++ims) {
                metStatIds[ims] = metStationList.get(ims).getId();
            }
            this.jniSetMetStationIds(nMetStats, metStatIds, rtnInfo);
            if (!rtnInfo.isSuccess()) {
                throw new WQException(rtnInfo);
            }
            for (MetStation ms : metStationList) {
                this.jniSetMetStationName(ms.getId(), ms.getName(), ms.getName().length(), rtnInfo);
            }
            if (!rtnInfo.isSuccess()) {
                throw new WQException(rtnInfo);
            }
            int metSetId = metStationSet.getId();
            MetAssignmentSet assignmentSet = geo.getMetAssignmentSet();
            if (assignmentSet != null) {
                List<SubDomain> subdomList = geo.getSubDomainsInExtent();
                Set<? extends SubDomainRef> refs = assignmentSet.getSubDomainRefs(metSetId);
                for (SubDomainRef subDomainRef : refs) {
                    Integer msId = assignmentSet.getMetStationId(metSetId, subDomainRef);
                    SubDomain subDom = geo.getSubDomain(subDomainRef);
                    if (msId == null || subDom == null || !subdomList.contains(subDom)) continue;
                    this.jniSetWQSubdomainMetStation(subDom.getId(), msId, rtnInfo);
                    if (rtnInfo.isSuccess()) continue;
                    throw new WQException(rtnInfo);
                }
            } else {
                throw new WQException("WQ Error: no Met Station Assignment Set found for WQ Geometry Id: " + geo.getId());
            }
        }
    }

    public void setMetData(MetStationSet metStationSet, DataProvider provider, WQTime time) throws WQException {
        List<MetStation> metStatList = metStationSet.getActiveStations();
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        for (MetStation metStat : metStatList) {
            int ims = metStat.getId();
            List<MetVariable> variables = metStat.getVariables();
            for (MetVariableTypes mvType : MetVariableTypes.values()) {
                MetVariable metVar = WQEngineAdapter.getVariable(variables, mvType);
                if (metVar == null) continue;
                int imetVar = mvType.getId();
                try {
                    double[] metData = this.getMetTimeSeriesValues(metVar, provider, time, variables, metStat);
                    boolean tsCheck = this.checkTimeSeriesValues(metData);
                    if (!tsCheck) {
                        String msg = this.reportTimeSeriesProblem(metData);
                        throw new WQException("Meteorological timeseries data for Station " + metStat.getName() + "\n" + msg + "\n Parameter " + metVar.getType() + " is missing data\n");
                    }
                    if ("Constant Value".equals(metVar.getSelectedDataSourceName()) || "Elevation".equals(metVar.getSelectedDataSourceName())) {
                        this.jniSetMetDataConstant(ims, imetVar, metData[0], rtnInfo);
                        if (rtnInfo.isSuccess()) continue;
                        throw new WQException(rtnInfo);
                    }
                    int recLen = metData.length;
                    Data selectedData = this.getSelectedData(metVar);
                    int dataTypeId = selectedData.getCompType();
                    this.jniSetMetDataTimeSeries(ims, imetVar, recLen, metData, dataTypeId, rtnInfo);
                    if (rtnInfo.isSuccess()) continue;
                    if (selectedData instanceof DssData) {
                        DssData dssData = (DssData)selectedData;
                        String dssFile = dssData.getDssFilePath();
                        String dssPath = dssData.getDssPath();
                        DSSIdentifier dssId = provider.getLocationFileAndPath(dssData, metStat.getName(), metVar.getType());
                        if (dssId != null) {
                            dssFile = dssId.getFileName();
                            dssPath = dssId.getDSSPath();
                        }
                        String dssInfo = "Dss filename: " + dssFile + "\nDss record name: " + dssPath + "\nUnits: " + dssData.getUnits() + "\nWindow start time: " + time.getStartTimeString() + "\nWindow end time: " + time.getEndTimeString() + "\n\n";
                        throw new WQException(dssInfo, rtnInfo);
                    }
                    throw new WQException(rtnInfo);
                }
                catch (UnitsConversionException e) {
                    throw new WQException("Units conversion error for Station " + metStat.getName() + "\nParameter " + metVar.getType() + "\nUnits: " + this.getSelectedData(metVar).getUnits() + "\n");
                }
            }
        }
    }

    private boolean checkTimeSeriesValues(double[] dataValues) {
        if (dataValues == null || dataValues.length == 0) {
            return false;
        }
        return Arrays.stream(dataValues).noneMatch(x -> x == -3.4028234663852886E38);
    }

    private String reportTimeSeriesProblem(double[] dataValues) {
        if (dataValues == null) {
            return "Data is null";
        }
        for (int j = 0; j < dataValues.length; ++j) {
            if (dataValues[j] != -3.4028234663852886E38) continue;
            return "Data value is missing at index " + j;
        }
        return "";
    }

    private double[] getMetTimeSeriesValues(MetVariable metVar, DataProvider provider, WQTime wqRTW, List<MetVariable> variables, MetStation metStat) throws UnitsConversionException, WQException {
        double[] dataValues = null;
        Data selectedData = this.getSelectedData(metVar);
        if (selectedData != null) {
            String interpUnits;
            String units = selectedData.getUnits();
            if (selectedData instanceof DssData && (interpUnits = ((DssData)selectedData).getInterpretedUnits()) != null && !interpUnits.isEmpty()) {
                units = interpUnits;
            }
            if ((dataValues = provider.getDataValues(selectedData, wqRTW, metStat, metVar.getType())) == null || dataValues.length == 0) {
                throw new WQException("Meteorological data for Station " + metStat.getName() + "\n Parameter " + metVar.getType() + " not found\n");
            }
            MetVariableTypes matchingType = this.getMetVariableType(metVar);
            if (matchingType != null) {
                switch (matchingType) {
                    case ATMOSPHERIC_PRESSURE: {
                        dataValues = WQEngineAdapter.convertAtmoValues(metVar, dataValues, selectedData, units, metStat);
                        break;
                    }
                    case AIR_TEMPERATURE: {
                        WQEngineAdapter.convertAirTemp(metVar, dataValues, units, metStat);
                        break;
                    }
                    case HUMIDITY: {
                        this.convertHumidity(metVar, dataValues, selectedData, units, provider, wqRTW, variables, metStat);
                        break;
                    }
                    case SHORTWAVE_RADIATION: {
                        WQEngineAdapter.convertSWRad(metVar, dataValues, selectedData, units, provider, wqRTW, variables, metStat);
                        break;
                    }
                    case WIND_SPEED: {
                        WQEngineAdapter.convertWindSpeed(metVar, dataValues, units, metStat);
                        break;
                    }
                }
            }
        }
        return dataValues;
    }

    public static double[] convertAirTemp(MetVariable metVar, double[] dataValues, String units, MetStation metStat) throws UnitsConversionException {
        UnitUtil.convertUnits((double[])dataValues, (String)units, (String)"deg C");
        return dataValues;
    }

    public static double[] convertAtmoValues(MetVariable metVar, double[] dataValues, Data selectedData, String units, MetStation metStat) throws UnitsConversionException, WQException {
        if (!"atm".equalsIgnoreCase(units)) {
            if ("Elevation".equals(selectedData.getName())) {
                UnitUtil.convertUnits((double[])dataValues, (String)units, (String)"m");
                dataValues = Arrays.stream(dataValues).map(v -> ConversionUtils.elevationToPressureAtm(v)).toArray();
            } else if (UnitUtil.canConvertBetweenUnits((String)units, (String)"kPa")) {
                UnitUtil.convertUnits((double[])dataValues, (String)units, (String)"kPa");
                ConversionUtils.convertKPaToAtm(dataValues);
            } else {
                throw new UnitsConversionException(units, "kPa");
            }
        }
        WQEngineAdapter.checkNegative(dataValues, metVar, metStat);
        return dataValues;
    }

    public double[] convertHumidity(MetVariable metVar, double[] dataValues, Data selectedData, String units, DataProvider provider, WQTime time, List<MetVariable> variables, MetStation metStat) throws UnitsConversionException, WQException {
        if (UnitUtil.canConvertBetweenUnits((String)units, (String)"mb")) {
            UnitUtil.convertUnits((double[])dataValues, (String)units, (String)"mb");
        } else if (units.toLowerCase().contains("dewpt")) {
            if (units.toLowerCase().contains("f")) {
                UnitUtil.convertUnits((double[])dataValues, (String)"deg F", (String)"deg C");
            }
            ConversionUtils.airTempToSatVapPresMb(dataValues);
        } else if (units.toLowerCase().contains("relative") || units.toLowerCase().contains("rh") || units.toLowerCase().contains("wetbulb") || units.contains("%")) {
            MetVariable airTempVar = this.getMetVariable(variables, MetVariableTypes.AIR_TEMPERATURE);
            if (airTempVar == null) {
                throw new WQException("Air Temperature dataset undefined. Dataset needed in order to calculate water vapor pressure for Met Station: " + metStat.getName());
            }
            double[] airTempVals = this.getMetTimeSeriesValues(airTempVar, provider, time, variables, metStat);
            Data airTempData = this.getSelectedData(airTempVar);
            boolean constantAirT = "Constant Value".equals(airTempData.getName());
            boolean constantHumidity = "Constant Value".equals(selectedData.getName());
            if (units.toLowerCase().contains("wetbulb") && units.toLowerCase().contains("f")) {
                UnitUtil.convertUnits((double[])dataValues, (String)"deg F", (String)"deg C");
            }
            ConversionUtils.convertRHandTempToMb(dataValues, constantHumidity, airTempVals, constantAirT, units);
        } else {
            throw new UnitsConversionException(units, "mb");
        }
        WQEngineAdapter.checkNegative(dataValues, metVar, metStat);
        return dataValues;
    }

    public static double[] convertSWRad(MetVariable metVar, double[] dataValues, Data selectedData, String units, DataProvider provider, WQTime time, List<MetVariable> variables, MetStation metStat) throws UnitsConversionException, WQException {
        WQEngineAdapter.convertSWRad(dataValues, units);
        WQEngineAdapter.checkNegative(dataValues, metVar, metStat);
        return dataValues;
    }

    public static double[] convertSWRad(double[] dataValues, String units) throws UnitsConversionException {
        if (UnitUtil.canConvertBetweenUnits((String)units, (String)ShortWaveRadiationUnits.WATTS_PER_M2.toString())) {
            UnitUtil.convertUnits((double[])dataValues, (String)units, (String)ShortWaveRadiationUnits.WATTS_PER_M2.toString());
        } else if (units.toLowerCase().contains(ShortWaveRadiationUnits.CAL_PER_CM2_PER_DAY.toString())) {
            ConversionUtils.convertCalPerCm2PerDayToWattPerM2(dataValues);
        } else if (units.toLowerCase().contains(ShortWaveRadiationUnits.MJ_PER_M2_PER_DAY.toString())) {
            ConversionUtils.convertMJPerM2PerDayToWPerM2(dataValues);
        } else if (!units.toLowerCase().contains("fraction")) {
            throw new UnitsConversionException(units, ShortWaveRadiationUnits.WATTS_PER_M2.toString());
        }
        return dataValues;
    }

    public static double[] convertWindSpeed(MetVariable metVar, double[] dataValues, String units, MetStation metStat) throws UnitsConversionException, WQException {
        if (!UnitUtil.canConvertBetweenUnits((String)units, (String)"m/s")) {
            throw new UnitsConversionException(units, "m/s");
        }
        UnitUtil.convertUnits((double[])dataValues, (String)units, (String)"m/s");
        WQEngineAdapter.checkNegative(dataValues, metVar, metStat);
        return dataValues;
    }

    private static void checkNegative(double[] dataValues, MetVariable metVar, MetStation metStat) throws WQException {
        for (double dataValue : dataValues) {
            if (!RMAConst.isValidValue((double)dataValue) || !(dataValue < 0.0)) continue;
            throw new WQException("Error: negative timeseries value found for " + metVar.getType() + " for met station: " + metStat.getName());
        }
    }

    private MetVariableTypes getMetVariableType(MetVariable metVar) {
        return Arrays.stream(MetVariableTypes.values()).filter(v -> v.getName().equals(metVar.getType())).findFirst().orElse(null);
    }

    private MetVariable getMetVariable(List<MetVariable> variables, MetVariableTypes type) {
        return variables.stream().filter(v -> type.getName().equals(v.getType())).findFirst().orElse(null);
    }

    private static MetVariable getVariable(List<MetVariable> vars, MetVariableTypes type) {
        MetVariable retval = null;
        if (vars != null) {
            retval = vars.stream().filter(t -> t.getType().equals(type.getName())).findFirst().orElse(null);
        }
        return retval;
    }

    public Data getSelectedData(MetVariable variable) {
        String name = variable.getSelectedDataSourceName();
        return variable.getDataSources().stream().filter(d -> Objects.equals(d.getName(), name)).findFirst().orElse(null);
    }

    public void setInitialConditions(InitialConditionSet icSet, Geometry wqGeo, ConstituentSet cs) throws WQException {
        this.setICReachMethod(icSet.getReachInterpolationType());
        this.setICReservoirMethod(icSet.getReservoirInterpolationType());
        this.setICReservoirs(icSet, wqGeo, cs);
        this.setICJunctions(icSet, wqGeo, cs);
    }

    private void setICReservoirs(InitialConditionSet icSet, Geometry wqGeo, ConstituentSet cs) throws WQException {
        List<SubDomain> subdomList = wqGeo.getSubDomainsInExtent();
        Set<Integer> constituentIds = icSet.getConstituentIds();
        for (Integer constituentId : constituentIds) {
            Constituent constituent = cs.getConstituent(constituentId);
            if (constituent == null) continue;
            Set<SubDomainRef> refs = icSet.getSubDomainRefs();
            for (SubDomainRef ref : refs) {
                Set<Double> elevs;
                SubDomain reservoir = wqGeo.getSubDomain(ref);
                if (reservoir == null || !subdomList.contains(reservoir) || (elevs = icSet.getDepths(ref, constituent)) == null) continue;
                this.setICReservoir(icSet, constituent, ref, reservoir, elevs);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setICReservoir(InitialConditionSet icSet, Constituent constituent, SubDomainRef ref, SubDomain reservoir, Set<Double> elevs) throws WQException {
        String units;
        ArrayList<Double> elevList = new ArrayList<Double>();
        ArrayList<Double> values = new ArrayList<Double>();
        int constituentId = constituent.getId();
        for (Double elev : elevs) {
            Double override;
            InitialCondition ic = icSet.getCondition(ref, elev, constituentId);
            if (ic == null || (override = ic.getOverride()) == null) continue;
            elevList.add(elev);
            values.add(override);
        }
        boolean isDepth = icSet.getIsDepth(ref, constituentId);
        if (elevList.size() <= 0) throw new WQException("Initial conditions not found for reservoir " + reservoir.getName() + " for constituent " + constituent.getDisplayName());
        double[] nativeElevs = WQEngineAdapter.asDouble(elevList);
        double[] nativeVals = WQEngineAdapter.asDouble(values);
        if ((constituentId == 1 || constituentId == 2) && (units = icSet.getUnits(ref, constituentId)) != null && units.split("/").length > 1) {
            String curveUnits = units.split("/")[1];
            String dssInfo = " ";
            if (!UnitUtil.canConvertBetweenUnits((String)curveUnits, (String)"deg C")) throw new WQException("Unrecognized units\n" + dssInfo);
            try {
                UnitUtil.convertUnits((double[])nativeVals, (String)curveUnits, (String)"deg C");
            }
            catch (UnitsConversionException e) {
                throw new WQException("Units conversion error\n" + dssInfo);
            }
        }
        this.setICReservoirs(reservoir.getId(), constituentId, nativeElevs, nativeVals, isDepth);
    }

    private void setICReservoirs(int resIdx, int cidx, double[] elevs, double[] values, boolean isDepth) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetICReservoir(resIdx, cidx, elevs.length, elevs, values, isDepth, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    private void setICJunctions(InitialConditionSet icSet, Geometry wqGeo, ConstituentSet cs) throws WQException {
        List<SubDomainBoundary> boundList = wqGeo.getBoundariesInExtent();
        Set<Integer> constituentIds = icSet.getConstituentIds();
        for (Integer constituentId : constituentIds) {
            Constituent constituent = cs.getConstituent(constituentId);
            if (constituent == null) continue;
            ArrayList<Integer> ids = new ArrayList<Integer>();
            ArrayList<Double> values = new ArrayList<Double>();
            Set<SubDomainBoundaryRef> boundaryRefs = icSet.getSubDomainBoundaryRefs();
            for (SubDomainBoundaryRef boundaryRef : boundaryRefs) {
                SubDomainBoundary boundary = wqGeo.getBoundary(boundaryRef);
                if (boundary == null || !boundList.contains(boundary)) continue;
                InitialCondition ic = icSet.getCondition(boundaryRef, constituentId);
                InterpICValue interpValue = icSet.getInterpolatedIC(constituentId, boundaryRef);
                if (ic == null) continue;
                Double value = ic.getOverride();
                if (value != null) {
                    ids.add(boundary.getId());
                    values.add(value);
                    continue;
                }
                if (interpValue == null || (value = interpValue.getValue()) == null) continue;
                ids.add(boundary.getId());
                values.add(value);
            }
            if (ids.size() > 0) {
                this.setICReaches(constituentId, WQEngineAdapter.asInt(ids), WQEngineAdapter.asDouble(values));
                continue;
            }
            throw new WQException("Reach initial conditions not found for constituent " + constituent.getDisplayName());
        }
    }

    private void setICReaches(int id, int[] junctionIdx, double[] values) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetICReaches(id, junctionIdx.length, junctionIdx, values, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    private void setICReachMethod(InterpolationType type) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetICInterpMethod(SubDomainType.REACH_1D.id(), type.id(), rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    private void setICReservoirMethod(InterpolationType type) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetICInterpMethod(SubDomainType.RESERVOIR_1DV.id(), type.id(), rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setSimpleInitialConditions(SimpleInitialConditionSet icSet, Geometry wqGeo) throws WQException {
        Collection<SimpleInitialCondition> sicList = icSet.getConditions();
        for (SimpleInitialCondition sic : sicList) {
            int wqsdId = sic.getSubdomainId();
            int constiId = sic.getConstituentId();
            SubDomain wqsd = wqGeo.getSubDomain(wqsdId);
            if (wqsd == null) {
                double val = sic.getValue();
                this.setICJunction(wqsdId, constiId, val);
                continue;
            }
            if (wqsd.getType() == SubDomainType.REACH_1D) {
                double val = sic.getValue();
                this.setICReach(wqsdId, constiId, val);
                continue;
            }
            double[] elevs = sic.getElevs();
            double[] elevVals = sic.getElevValues();
            boolean isDepth = false;
            this.setICReservoirs(wqsdId, constiId, elevs, elevVals, isDepth);
        }
    }

    private void setICReach(int wqSubDomainId, int constitId, double val) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetICReach(wqSubDomainId, constitId, val, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    private void setICJunction(int jnctId, int constitId, double val) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetICJunction(jnctId, constitId, val, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setBoundaryConcentrations(BoundaryConditionSet bcSet, ConstituentSet constitSet, Geometry geo, DataProvider provider, WQTime wqRTW) throws WQException {
        if (geo == null) {
            throw new WQException("Water Quality Geometry object is null");
        }
        if (bcSet == null) {
            throw new WQException("Water Quality Boundary Condition Set is null");
        }
        Collection<BoundaryCondition> boundaryConditions = bcSet.getBoundaryConditions();
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        for (BoundaryCondition bc : boundaryConditions) {
            int constitId = bc.getConstituentId();
            Constituent constit = constitSet.getConstituent(constitId);
            SubDomainBoundaryRef bRef = bc.getBoundaryRef();
            SubDomainBoundary boundary = geo.getBoundary(bRef);
            if (boundary == null || !boundary.getInExtent()) continue;
            int boundaryId = boundary.getId();
            Data data = bc.getSelectedDataSource();
            double[] dataValues = null;
            String bcMessage = "Boundary condition " + boundary.getName() + ", Constituent: " + constit.getName();
            if (data != null) {
                dataValues = provider.getDataValues(data, wqRTW, boundary.getName(), constit.getDisplayName());
                int dataTypeId = data.getCompType();
                if (data instanceof ConstantData) {
                    this.jniSetBoundaryConcConstant(boundaryId, constitId, dataValues[0], rtnInfo);
                    if (rtnInfo.isSuccess()) continue;
                    throw new WQException("Error setting constant data for " + bcMessage, rtnInfo);
                }
                if (data instanceof AmbientData) {
                    AmbientData ambientData = (AmbientData)data;
                    int ambientBCoption = ambientData.getOptionInt();
                    this.jniSetBoundaryConcAmbient(boundaryId, constitId, ambientBCoption, rtnInfo);
                    if (rtnInfo.isSuccess()) continue;
                    throw new WQException("Error setting ambient data for " + bcMessage, rtnInfo);
                }
                if (data instanceof DssData) {
                    DssData dssData = (DssData)data;
                    String dssFile = dssData.getDssFilePath();
                    String dssPath = dssData.getDssPath();
                    DSSIdentifier dssId = provider.getLocationFileAndPath(dssData, boundary.getName(), constit.getDisplayName());
                    if (dssId != null) {
                        dssFile = dssId.getFileName();
                        dssPath = dssId.getDSSPath();
                    }
                    String dssInfo = "Dss filename: " + dssFile + "\nDss record name: " + dssPath + "\nUnits: " + dssData.getUnits() + "\nWindow start time: " + wqRTW.getStartTimeString() + "\nWindow end time: " + wqRTW.getEndTimeString() + "\n\n";
                    boolean tsCheck = this.checkTimeSeriesValues(dataValues);
                    if (!tsCheck) {
                        String msg = this.reportTimeSeriesProblem(dataValues);
                        throw new WQException("DSS record contains missing data for " + bcMessage + "\n" + msg + "\n" + dssInfo);
                    }
                    if (constitId == 1) {
                        String units = data.getUnits();
                        if (UnitUtil.canConvertBetweenUnits((String)units, (String)"deg C")) {
                            try {
                                UnitUtil.convertUnits((double[])dataValues, (String)units, (String)"deg C");
                            }
                            catch (UnitsConversionException e) {
                                throw new WQException("Units conversion error for " + bcMessage + " Units: " + units);
                            }
                        } else {
                            throw new WQException("Unrecognized units for " + bcMessage + " Units: " + units);
                        }
                    }
                    this.jniSetBoundaryConcTS(boundaryId, constitId, dataValues.length, dataValues, dataTypeId, rtnInfo);
                    if (rtnInfo.isSuccess()) continue;
                    throw new WQException("DSS Data Error for " + bcMessage + "\n" + dssInfo, rtnInfo);
                }
                throw new WQException("Unrecognized data type for " + bcMessage);
            }
            throw new WQException("Null data object found for " + bcMessage);
        }
    }

    public void setDispersionDataReaches(DispersionCoefSettings dispCoefSet, Geometry geo) throws WQException {
        if (geo == null) {
            throw new WQException("Water Quality Geometry object is null");
        }
        if (dispCoefSet == null) {
            throw new WQException("Water Quality Dispersion Coefficient Set is null");
        }
        ReachDispersionSettings reachDispSettings = dispCoefSet.getReachSettings();
        List<SubDomain> subdomList = geo.getSubDomainsInExtent();
        double upstreamDisp = 0.0;
        double downstreamDisp = 0.0;
        List<ReachDispersionValues> valsByReach = reachDispSettings.getReachValues();
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        for (SubDomain subdom : subdomList) {
            if (subdom.getType() != SubDomainType.REACH_1D) continue;
            if (reachDispSettings.getDispersionType() == ReachDispersionType.GLOBAL) {
                upstreamDisp = reachDispSettings.getGlobalValue();
                downstreamDisp = reachDispSettings.getGlobalValue();
            } else if (reachDispSettings.getDispersionType() == ReachDispersionType.BY_REACH) {
                boolean foundReach = false;
                for (ReachDispersionValues rdv : valsByReach) {
                    if (rdv.getReachId() != subdom.getId()) continue;
                    foundReach = true;
                    if (reachDispSettings.getValueByReachType() == ValueByReachType.CONSTANT) {
                        upstreamDisp = rdv.getConstant();
                        downstreamDisp = rdv.getConstant();
                        break;
                    }
                    if (reachDispSettings.getValueByReachType() != ValueByReachType.LINEAR_INTERP) break;
                    upstreamDisp = rdv.getUpperEnd();
                    downstreamDisp = rdv.getLowerEnd();
                    break;
                }
                if (!foundReach) {
                    throw new WQException("Reach dispersion settings not found for: " + subdom.getName() + " Dispersion Coefficient Set: " + dispCoefSet.getName());
                }
            }
            this.jniSetReachDispersionCoefs(subdom.getId(), upstreamDisp, downstreamDisp, rtnInfo);
            if (rtnInfo.isSuccess()) continue;
            throw new WQException(rtnInfo);
        }
    }

    public void setDispersionDataReservoirs(DispersionCoefSettings dispCoefSet, Geometry geo) throws WQException {
        if (geo == null) {
            throw new WQException("Water Quality Geometry object is null");
        }
        if (dispCoefSet == null) {
            throw new WQException("Water Quality Dispersion Coefficient Set is null");
        }
        List<SubDomain> subdomList = geo.getSubDomainsInExtent();
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        for (SubDomain subdom : subdomList) {
            Double mixedLayerTolerance;
            Double maxOutflowEnvelopeHeight;
            Double maxInflowEnvelopeHeight;
            if (subdom.getType() != SubDomainType.RESERVOIR_1DV) continue;
            SubDomainRef sdRef = geo.buildRef(subdom);
            ReservoirDispersionSettings resDispSetting = dispCoefSet.getReservoirSettings(sdRef);
            if (resDispSetting == null) {
                throw new WQException("Reservoir dispersion settings not found for: " + subdom.getName() + " Dispersion Coefficient Set: " + dispCoefSet.getName());
            }
            if (resDispSetting.getAlternateMixingMethod() == AlternateMixingMethod.STABILITY) {
                this.setResDispersionStability(rtnInfo, subdom, resDispSetting);
            } else if (resDispSetting.getAlternateMixingMethod() == AlternateMixingMethod.WIND) {
                this.setResDispersionWind(rtnInfo, subdom, resDispSetting);
            } else if (resDispSetting.getAlternateMixingMethod() == AlternateMixingMethod.MUNK_ANDERSON) {
                this.setResDispersionMunkAnderson(rtnInfo, subdom, resDispSetting);
            }
            ReservoirDispersionEntrainmentSettings resEntrainSetting = resDispSetting.getEntrainmentSettings();
            if (resEntrainSetting == null) {
                throw new WQException("Reservoir entrainment settings not found for: " + subdom.getName() + " Dispersion Coefficient Set: " + dispCoefSet.getName());
            }
            List<ReservoirEntrainmentInflowSetting> entrainmentInflowSettings = resEntrainSetting.getEntrainmentInflowSettings();
            for (ReservoirEntrainmentInflowSetting entrainSetting : entrainmentInflowSettings) {
                if (!entrainSetting.useEntrainment()) continue;
                int bcIdx = entrainSetting.getInflowId();
                double initMixingRatio = entrainSetting.getInitialMixingRatio();
                double entrainmentRate = entrainSetting.getEntrainmentRate();
                double streamSlope = entrainSetting.getStreamSlope();
                double streamHalfAngle = entrainSetting.getStreamCrossSectionHalfAngle();
                this.jniSetResEntrainment(bcIdx, initMixingRatio, entrainmentRate, streamSlope, streamHalfAngle, rtnInfo);
                if (rtnInfo.isSuccess()) continue;
                throw new WQException(rtnInfo);
            }
            if (resDispSetting.useMaxInflowEnvelopeHeight() && (maxInflowEnvelopeHeight = resDispSetting.getMaxInflowEnvelopeHeight()) != null && maxInflowEnvelopeHeight != Double.NEGATIVE_INFINITY) {
                this.jniSetResMaxInflowEnvelopeHeight(subdom.getId(), maxInflowEnvelopeHeight, rtnInfo);
                if (!rtnInfo.isSuccess()) {
                    throw new WQException(rtnInfo);
                }
            }
            if (resDispSetting.useMaxOutflowEnvelopeHeight() && (maxOutflowEnvelopeHeight = resDispSetting.getMaxOutflowEnvelopeHeight()) != null && maxOutflowEnvelopeHeight != Double.NEGATIVE_INFINITY) {
                this.jniSetResMaxOutflowEnvelopeHeight(subdom.getId(), maxOutflowEnvelopeHeight, rtnInfo);
                if (!rtnInfo.isSuccess()) {
                    throw new WQException(rtnInfo);
                }
            }
            if ((mixedLayerTolerance = resDispSetting.getMixedLayerTolerance()) == null || mixedLayerTolerance == Double.NEGATIVE_INFINITY) continue;
            this.jniSetResMixLayerTolerance(subdom.getId(), mixedLayerTolerance, rtnInfo);
            if (rtnInfo.isSuccess()) continue;
            throw new WQException(rtnInfo);
        }
    }

    private void setResDispersionStability(NativeCallRtnInfo rtnInfo, SubDomain subdom, ReservoirDispersionSettings resDispSetting) throws WQException {
        this.jniSetResVertMixingMethod(subdom.getId(), AlternateMixingMethod.STABILITY.getId(), rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        StabilityDispersionData stabData = resDispSetting.getStabilityData();
        this.jniSetDispersionStabilityParameters(subdom.getId(), stabData.getEcrit(), stabData.getA1(), stabData.getA3(), rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        this.jniSetDispersionStabilityParameters(subdom.getId(), stabData.getEcrit(), stabData.getA1(), stabData.getA3(), rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    private void setResDispersionWind(NativeCallRtnInfo rtnInfo, SubDomain subdom, ReservoirDispersionSettings resDispSetting) throws WQException {
        this.jniSetResVertMixingMethod(subdom.getId(), AlternateMixingMethod.WIND.getId(), rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        WindDispersionData windData = resDispSetting.getWindData();
        double dzmax = windData.getDzmax();
        if (!windData.useDzMax() || dzmax == Double.NEGATIVE_INFINITY) {
            dzmax = -9999.0;
        }
        this.jniSetDispersionWindParameters(subdom.getId(), windData.getDzmin(), windData.getA1(), windData.getA2(), dzmax, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    private void setResDispersionMunkAnderson(NativeCallRtnInfo rtnInfo, SubDomain subdom, ReservoirDispersionSettings resDispSetting) throws WQException {
        this.jniSetResVertMixingMethod(subdom.getId(), AlternateMixingMethod.MUNK_ANDERSON.getId(), rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        MunkAndersonDispersionData maData = resDispSetting.getMunkAndersonData();
        this.jniSetDispersionMAParameters(subdom.getId(), maData.getACoeff(), maData.getBCoeff(), maData.getCCoeff(), maData.getDzmin(), rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setMassInjectionData(MassInjectionSet miSet, List<MassInjectionSite> siteList, Geometry geo, ConstituentSet constitSet, DataProvider provider, WQTime wqRTW) throws WQException {
        MassInjectionSiteData siteData;
        if (geo == null) {
            throw new WQException("Water Quality Geometry object is null");
        }
        if (miSet == null) {
            throw new WQException("Water Quality Mass Injection Set is null");
        }
        if (siteList == null) {
            throw new WQException("Water Quality Mass Injection Site List is null");
        }
        ArrayList<MassInjectionSite> filteredSiteList = new ArrayList<MassInjectionSite>();
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        block0: for (MassInjectionSite site : siteList) {
            MassInjectionSiteData siteData2 = miSet.getMassInjectionSiteData(site);
            Set<Integer> constitIds = siteData2.getConstituentIds();
            for (Integer constitId : constitIds) {
                if (!constitSet.hasConstituent(constitId)) continue;
                filteredSiteList.add(site);
                continue block0;
            }
        }
        if (filteredSiteList.isEmpty()) {
            return;
        }
        int nMassInjections = filteredSiteList.size();
        int[] massInjectionIds = new int[nMassInjections];
        for (int j = 0; j < nMassInjections; ++j) {
            MassInjectionSite site = (MassInjectionSite)filteredSiteList.get(j);
            massInjectionIds[j] = site.getId();
        }
        this.jniSetMassInjectionIds(nMassInjections, massInjectionIds, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        for (MassInjectionSite site : filteredSiteList) {
            String miInfo;
            boolean isSubdomain;
            siteData = miSet.getMassInjectionSiteData(site);
            SubDomain subdom = siteData.getSubDomain(geo);
            SubDomainJunction subdomJnct = siteData.getSubDomainJunction(geo);
            boolean isJunction = subdomJnct != null;
            boolean bl = isSubdomain = subdom != null;
            if (isSubdomain) {
                miInfo = "Mass injection site: " + site.getName() + ", Subdomain: " + subdom.getName();
                if (subdom.getType() == SubDomainType.RESERVOIR_1DV) {
                    double depthOrElev;
                    boolean isDepth;
                    MassInjectionReservoirType miType = siteData.getMassInjectionReservoirType();
                    if (miType == MassInjectionReservoirType.Depth) {
                        isDepth = true;
                        depthOrElev = siteData.getReservoirInjectionDepth();
                    } else {
                        isDepth = false;
                        depthOrElev = siteData.getReservoirInjectionElevation();
                    }
                    this.jniSetMIGeometryReservoir(site.getId(), subdom.getId(), isDepth, depthOrElev, rtnInfo);
                    if (rtnInfo.isSuccess()) continue;
                    throw new WQException("Error setting geometry for " + miInfo, rtnInfo);
                }
                if (subdom.getType() != SubDomainType.REACH_1D) continue;
                MassInjectionType miType = siteData.getMassInjectionType();
                boolean isDistributed = miType == MassInjectionType.Distrbuted;
                int icell = geo.findCellForStreamStation(subdom, site.getStreamStation());
                this.jniSetMIGeometryReach(site.getId(), subdom.getId(), isDistributed, icell, rtnInfo);
                if (rtnInfo.isSuccess()) continue;
                throw new WQException("Error setting geometry for " + miInfo, rtnInfo);
            }
            miInfo = "Mass injection site: " + site.getName() + ", Junction: " + subdomJnct.getName();
            this.jniSetMIGeometryJnct(site.getId(), subdomJnct.getId(), rtnInfo);
            if (rtnInfo.isSuccess()) continue;
            throw new WQException("Error setting geometry for " + miInfo, rtnInfo);
        }
        for (MassInjectionSite site : filteredSiteList) {
            siteData = miSet.getMassInjectionSiteData(site);
            Set<Integer> constitIds = siteData.getConstituentIds();
            HashSet<Integer> filteredConstitIds = new HashSet<Integer>();
            for (Integer cId : constitIds) {
                if (!constitSet.hasConstituent(cId)) continue;
                filteredConstitIds.add(cId);
            }
            int nConstit = filteredConstitIds.size();
            int[] cIds = new int[nConstit];
            int count = 0;
            for (Integer cId : filteredConstitIds) {
                cIds[count] = cId;
                ++count;
            }
            this.jniSetMassInjectionConstitIds(site.getId(), nConstit, cIds, rtnInfo);
            if (!rtnInfo.isSuccess()) {
                throw new WQException(rtnInfo);
            }
            Iterator iterator = filteredConstitIds.iterator();
            while (iterator.hasNext()) {
                int cId = (Integer)iterator.next();
                MassInjectionConstituentData micData = siteData.getMassInjectionConstituentData(cId);
                Data data = micData.getSelectedDataSource();
                String constitName = constitSet.getConstituent(cId).getName();
                String miMessage = "Mass injection site " + site.getName() + ", Constituent: " + constitName;
                double[] dataValues = null;
                if (data != null) {
                    dataValues = provider.getDataValues(data, wqRTW, site.getName(), constitName);
                    int dataTypeId = data.getCompType();
                    if (data instanceof ConstantData) {
                        this.jniSetMIConcConstant(site.getId(), cId, dataValues[0], rtnInfo);
                        if (rtnInfo.isSuccess()) continue;
                        throw new WQException("Error setting constant data for " + miMessage, rtnInfo);
                    }
                    if (data instanceof DssData) {
                        DssData dssData = (DssData)data;
                        String dssInfo = "Dss filename: " + dssData.getDssFilePath() + "\nDss record name: " + dssData.getDssPath() + "\nUnits: " + dssData.getUnits() + "\nWindow start time: " + wqRTW.getStartTimeString() + "\nWindow end time: " + wqRTW.getEndTimeString() + "\n\n";
                        this.jniSetMIConcTS(site.getId(), cId, dataValues.length, dataValues, dataTypeId, rtnInfo);
                        if (!rtnInfo.isSuccess()) {
                            throw new WQException("Error setting DSS data for " + miMessage + "\n" + dssInfo, rtnInfo);
                        }
                        boolean tsCheck = this.checkTimeSeriesValues(dataValues);
                        if (tsCheck) continue;
                        String msg = this.reportTimeSeriesProblem(dataValues);
                        throw new WQException("Missing DSS data for " + miMessage + "\n" + msg + "\n" + dssInfo);
                    }
                    throw new WQException("Unrecognized data type for " + miMessage);
                }
                throw new WQException("Null data object found for " + miMessage);
            }
        }
        this.jniInitializeMassInjections(rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void finalizeInitialization() throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniFinalizeInitialization(rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void computeStep(int hydroStep, int wqStep) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniComputeStep(hydroStep, wqStep, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    @Scriptable
    public double[] computeWQCDFlows(SubDomain subdom, WQControlDevice wqControlDevice, Constituent constit, int nInletLevels, double[] inletFlowMin, double[] inletFlowMax, double totalFlow, double targetWQ) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        double[] flows = this.jniComputeTCDFlows(subdom.getId(), wqControlDevice.getId(), constit.getId(), nInletLevels, inletFlowMin, inletFlowMax, totalFlow, targetWQ, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return flows;
    }

    public void saveState(STATE state) throws WQException {
        int id = state.id();
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSaveState(id, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void restoreState(STATE state) throws WQException {
        int id = state.id();
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniRestoreState(id, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void updateTimeOffset(int offset) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniUpdateTimeOffset(offset, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void updateHydro(Geometry geo, int hydroUpdateType) throws WQException {
        if (geo == null) {
            throw new WQException("Water Quality Geometry object is null");
        }
        List<SubDomain> subdomList = geo.getSubDomainsInExtent();
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        for (SubDomain subdom : subdomList) {
            Object wqHydro;
            if (subdom.getTypeId() == SubDomainType.REACH_1D.id()) {
                wqHydro = subdom.getReachHydro();
                double[] q = ((WQReachHydro)wqHydro).getFlow();
                double[] A = ((WQReachHydro)wqHydro).getXSArea();
                double[] sfcW = ((WQReachHydro)wqHydro).getSfcWidth();
                this.jniUpdateReachHydro(subdom.getId(), q.length, q, A, sfcW, hydroUpdateType, rtnInfo);
                if (rtnInfo.isSuccess()) continue;
                throw new WQException(rtnInfo);
            }
            if (subdom.getTypeId() != SubDomainType.RESERVOIR_1DV.id()) continue;
            wqHydro = subdom.getResHydro();
            double stor = ((WQResHydro)wqHydro).getStorage();
            double seep = ((WQResHydro)wqHydro).getSeepage();
            double evapPrecip = ((WQResHydro)wqHydro).getEvapPrecip();
            double[] flows = ((WQResHydro)wqHydro).getFlows();
            double[] outletFlows = ((WQResHydro)wqHydro).getOutletFlows();
            double[] tcdFlows = ((WQResHydro)wqHydro).getTCDFlows();
            this.jniUpdateResHydro(subdom.getId(), stor, seep, evapPrecip, flows.length, flows, outletFlows.length, outletFlows, tcdFlows.length, tcdFlows, hydroUpdateType, rtnInfo);
            if (rtnInfo.isSuccess()) continue;
            throw new WQException(rtnInfo);
        }
        List<SubDomainBoundary> subdomBoundList = geo.getBoundariesInExtent();
        List<BoundaryType> boundList = Arrays.asList(BoundaryType.LOCAL_INFLOW, BoundaryType.LOCAL_DIVERSION, BoundaryType.RIVER_OUTFLOW, BoundaryType.RESERVOIR_OUTFLOW, BoundaryType.RIVER_INFLOW_IN_NETWORK, BoundaryType.RESERVOIR_INFLOW_IN_NETWORK);
        for (SubDomainBoundary sdb : subdomBoundList) {
            if (!boundList.contains((Object)sdb.getBoundaryType())) continue;
            this.jniUpdateBoundaryFlow(sdb.getId(), sdb.getSavedFlow(), hydroUpdateType, rtnInfo);
            if (rtnInfo.isSuccess()) continue;
            throw new WQException(rtnInfo);
        }
    }

    public void setInitialCellVolumes(Geometry geo) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetInitialCellVolumes(rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        List<SubDomain> sdList = geo.getSubDomainsInExtent();
        for (SubDomain sd : sdList) {
            if (sd.getType() != SubDomainType.REACH_1D) continue;
            this.setInitialCellVolumesReach(sd);
        }
    }

    public void setInitialCellVolumesReach(SubDomain sd) throws WQException {
        WQReachHydro reachHydro = sd.getReachHydro();
        double[] cellVols = reachHydro.getCellVol();
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetInitialCellVolumesReach(sd.getId(), sd.getNumCells(), cellVols, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void finalizeCompute() throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniFinalizeCompute(rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setParam(int wqConstitId, double val) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetWQConstituentValAll(wqConstitId, val, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setParam(int wqConstitId, int subdomId, double val) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetWQConstituentValSubDomain(wqConstitId, subdomId, val, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setParam(int wqConstitId, int subdomId, int cellIdx, double val) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetWQConstituentValCell(wqConstitId, subdomId, cellIdx, val, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setBoundaryInflowDepth(int boundId, double val) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetBoundaryInflowDepth(boundId, val, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setMinDz(int subdomId, double val) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetMinDz(subdomId, val, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public void setBoundaryTempSource(int subdomBoundId, double val) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetBoundaryTempSource(subdomBoundId, val, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public double[] getConstitResult(int subdomId, int wqConstitId, int startEndFlag, int numCells) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        double[] result = this.jniGetWQConstituentVal(subdomId, wqConstitId, startEndFlag, numCells, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return result;
    }

    public double[] getPathwayResult(int subdomId, int wqPathwayId, int numCells) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        double[] result = this.jniGetWQPathwayVal(subdomId, wqPathwayId, numCells, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return result;
    }

    public double[] getDerivedVarResult(int subdomId, int wqDerivedVarId, int numCells) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        double[] result = this.jniGetWQDerivedVarVal(subdomId, wqDerivedVarId, numCells, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return result;
    }

    public double getConstitResultAtJnct(int jnctId, int wqConstitId) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        double result = this.jniGetWQConstituentValAtJnct(jnctId, wqConstitId, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return result;
    }

    public double getConstitResultAtReach(int reachId, int wqConstitId) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        double result = this.jniGetWQConstituentValAtReach(reachId, wqConstitId, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return result;
    }

    public double getConstitResultAtReachEnd(int reachId, int wqConstitId) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        double result = this.jniGetWQConstituentValAtReachEnd(reachId, wqConstitId, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return result;
    }

    public double getConstitResultAtBoundary(int boundaryId, int wqConstitId) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        double result = this.jniGetWQConstituentValAtBoundary(boundaryId, wqConstitId, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return result;
    }

    public double[] getConstitResultOutlets(int subdomId, int wqConstitId, int numOutlets) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        double[] result = this.jniGetWQConstituentValOutlets(subdomId, wqConstitId, numOutlets, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return result;
    }

    public double[] getConstitResultTCDInlets(int subdomId, int wqConstitId, int tcdId, int numInlets) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        double[] result = this.jniGetWQConstituentValTCDInlets(subdomId, wqConstitId, tcdId, numInlets, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return result;
    }

    @Scriptable
    public double getWQResultOptimized(SubDomain subdom, WQControlDevice wqControlDevice) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        double result = this.jniGetWQConstituentValTCDOptimized(subdom.getId(), wqControlDevice.getId(), rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return result;
    }

    @Scriptable
    public double getWQResultForReleaseAtElev(SubDomain subdom, Constituent constit, double flow, double elevation) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        double result = this.jniGetWQConstituentValFlowElev(subdom.getId(), constit.getId(), flow, elevation, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return result;
    }

    public double[] getHydroResult(int subdomIdx, int hydroResultType, int startEndFlag, int numCellsOrFaces) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        double[] result = this.jniGetHydroVal(subdomIdx, hydroResultType, startEndFlag, numCellsOrFaces, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return result;
    }

    public int getNumberWQPathways() throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        int result = this.jniGetNumberWQPathways(rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return result;
    }

    public int getNumberWQDerivedVars() throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        int result = this.jniGetNumberWQDerivedVars(rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return result;
    }

    @Scriptable
    public double[] getWQCDInletLevels(SubDomain subdom, WQControlDevice wqControlDevice) throws WQException {
        int sdId = subdom.getId();
        int wqcdId = wqControlDevice.getId();
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        int numInletLevels = this.jniGetNumTCDInletLevels(sdId, wqcdId, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        double[] inletLevels = this.jniGetTCDInletElevs(sdId, wqcdId, numInletLevels, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return inletLevels;
    }

    @Scriptable
    public double[] getReservoirLayerTemperatures(SubDomain subdom) throws WQException {
        int temperatureConstitId = 1;
        return this.getConstitResult(subdom.getId(), temperatureConstitId, WQTime.TIME_STEP_INFO.END_OF_STEP.id(), subdom.getNumCells());
    }

    @Scriptable
    public double[] getReservoirLayerWQResults(SubDomain subdom, Constituent constit) throws WQException {
        return this.getConstitResult(subdom.getId(), constit.getId(), WQTime.TIME_STEP_INFO.END_OF_STEP.id(), subdom.getNumCells());
    }

    public String getVersionNumber() throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        String version = this.jniGetVersionNum(rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
        return version;
    }

    public void setResThermalMixing(boolean useThermalMixing) throws WQException {
        NativeCallRtnInfo rtnInfo = new NativeCallRtnInfo();
        this.jniSetResThermalMixing(useThermalMixing, rtnInfo);
        if (!rtnInfo.isSuccess()) {
            throw new WQException(rtnInfo);
        }
    }

    public static double[] asDouble(Collection<Double> collection) {
        double[] retval = null;
        if (collection != null) {
            retval = new double[collection.size()];
            int i = 0;
            for (Double value : collection) {
                retval[i++] = value;
            }
        }
        return retval;
    }

    public static int[] asInt(Collection<Integer> collection) {
        int[] retval = null;
        if (collection != null) {
            retval = new int[collection.size()];
            int i = 0;
            for (Integer value : collection) {
                retval[i++] = value;
            }
        }
        return retval;
    }

    public static double[] toPrimitive(Double[] array) {
        double[] retval = null;
        if (array != null) {
            retval = new double[array.length];
            for (int i = 0; i < array.length; ++i) {
                retval[i] = array[i];
            }
        }
        return retval;
    }

    public static int[] toPrimitive(Integer[] array) {
        int[] retval = null;
        if (array != null) {
            retval = new int[array.length];
            for (int i = 0; i < array.length; ++i) {
                retval[i] = array[i];
            }
        }
        return retval;
    }

    static {
        WQEngineAdapter.loadLibraries();
    }

    public class NativeCallRtnInfo {
        int id = RTNVAL.OTHER.id();
        String message = " ";

        public boolean isSuccess() {
            return this.id == RTNVAL.SUCCESS.id();
        }

        public int getId() {
            return this.id;
        }

        public String getErrorMessage() {
            return this.message;
        }

        public void setErrorMessage(String errorMessage) {
            this.message = errorMessage;
        }
    }

    public static enum STATE {
        HINDCAST(0),
        OUTERLOOP(1),
        TRIAL(2),
        INNERLOOP(3),
        TIMEBLOCK(4),
        TIMEBLOCK2(5),
        PRECOMPUTE(6);

        private final int id;

        private STATE(int idx) {
            this.id = idx;
        }

        public int id() {
            return this.id;
        }
    }

    public static enum RTNVAL {
        SUCCESS(0),
        FAIL(1),
        OTHER(999);

        private final int id;

        private RTNVAL(int i) {
            this.id = i;
        }

        int id() {
            return this.id;
        }

        public boolean isSuccess() {
            return this == SUCCESS;
        }

        public static boolean isSuccess(int id) {
            return id == RTNVAL.SUCCESS.id;
        }
    }
}

