/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore;

import hec.model.RunTimeWindow;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.OutputVariableOptions;
import hec.wqenginecore.WQEngineAdapter;
import hec.wqenginecore.WQException;
import hec.wqenginecore.WQTime;
import hec.wqenginecore.WqIoHydroType;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainType;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;

public class WQIO {
    public static final Logger logger = Logger.getLogger(WQIO.class.getName());
    public static final double INVALID_DATA_FLAG = -9999.0;
    private int _fileId = -1;
    private int _geomGroupId = -1;
    private int _resultsGroupId = -1;
    private int _resultsSDId = -1;
    private int _resultsTimeId = -1;
    private int _resultsTimeStrId = -1;
    private Map<SubDomain, Integer> _resultsSubdomGroupId;
    private Map<SubDomain, Map<Integer, Integer>> _resultsSubdomDSId;
    private String _hdf5Filename;
    private int _numWQPathways;
    private int _numWQDerivedVars;
    private boolean[] _outputWQpathway;
    private boolean[] _outputWQderivedVar;
    private final int COMPRESSION_LEVEL = 1;
    private final String _resultsGroupName = "Results";
    private final String _subdomainGroupName = "Subdomains";
    private final String _geometryGroupName = "Geometry";
    private final String _timeGroupName = "Time";
    private final String _timeStrGroupName = "Time Date Stamp";
    private final String _unitsAttrName = "Units";
    private final String _constitIdAttrName = "Constituent ID";
    private final String _subdomTypeName = "Subdomain Type";
    private boolean _firstTimeStepSave = true;

    public WQIO(String hdf5Filename) {
        this._hdf5Filename = hdf5Filename;
    }

    private void writeAttribute(int locationId, String attributeName, String attributeVal) throws WQException {
        try {
            int rank = 1;
            long[] dims = new long[]{1L};
            int dataspaceId = H5.H5Screate_simple((int)rank, (long[])dims, null);
            int typeId = H5.H5Tcopy((int)HDF5Constants.H5T_C_S1);
            byte[] bytes = attributeVal.getBytes("UTF8");
            H5.H5Tset_size((int)typeId, (int)bytes.length);
            int attrId = H5.H5Acreate((int)locationId, (String)attributeName, (int)typeId, (int)dataspaceId, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
            int status = H5.H5Awrite((int)attrId, (int)typeId, (byte[])bytes);
            if (status < 0) {
                throw new WQException("Error writing HDF5 Attribute: " + attributeName);
            }
            H5.H5Tclose((int)typeId);
            H5.H5Sclose((int)dataspaceId);
            H5.H5Aclose((int)attrId);
        }
        catch (Exception e) {
            throw new WQException("Exception writing HDF5 Attribute: " + attributeName, e);
        }
    }

    private void writeAttribute(int locationId, String attributeName, double attributeVal) throws WQException {
        try {
            int rank = 1;
            long[] dims = new long[]{1L};
            int dataspaceId = H5.H5Screate_simple((int)rank, (long[])dims, null);
            int typeId = H5.H5Tcopy((int)HDF5Constants.H5T_NATIVE_DOUBLE);
            H5.H5Tset_order((int)typeId, (int)HDF5Constants.H5T_ORDER_LE);
            int attrId = H5.H5Acreate((int)locationId, (String)attributeName, (int)typeId, (int)dataspaceId, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
            double[] attributeValues = new double[]{attributeVal};
            int status = H5.H5Awrite((int)attrId, (int)typeId, (Object)attributeValues);
            if (status < 0) {
                throw new WQException("Error writing HDF5 Attribute: " + attributeName);
            }
            H5.H5Tclose((int)typeId);
            H5.H5Sclose((int)dataspaceId);
            H5.H5Aclose((int)attrId);
        }
        catch (Exception e) {
            throw new WQException("Exception writing HDF5 Attribute: " + attributeName, e);
        }
    }

    private void writeAttribute(int locationId, String attributeName, int attributeVal) throws WQException {
        try {
            int rank = 1;
            long[] dims = new long[]{1L};
            int dataspaceId = H5.H5Screate_simple((int)rank, (long[])dims, null);
            int typeId = H5.H5Tcopy((int)HDF5Constants.H5T_NATIVE_INT);
            H5.H5Tset_order((int)typeId, (int)HDF5Constants.H5T_ORDER_LE);
            int attrId = H5.H5Acreate((int)locationId, (String)attributeName, (int)typeId, (int)dataspaceId, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
            int[] attributeValues = new int[]{attributeVal};
            int status = H5.H5Awrite((int)attrId, (int)typeId, (Object)attributeValues);
            if (status < 0) {
                throw new WQException("Error writing HDF5 Attribute: " + attributeName);
            }
            H5.H5Tclose((int)typeId);
            H5.H5Sclose((int)dataspaceId);
            H5.H5Aclose((int)attrId);
        }
        catch (Exception e) {
            throw new WQException("Exception writing HDF5 Attribute: " + attributeName, e);
        }
    }

    private int createGroup(int locationId, String groupName) throws WQException {
        int newGroupId;
        try {
            newGroupId = H5.H5Gcreate((int)locationId, (String)groupName, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
        }
        catch (Exception e) {
            throw new WQException("Exception creating HDF5 Group: " + groupName, e);
        }
        return newGroupId;
    }

    private void closeGroup(int locationId, String groupName) throws WQException {
        try {
            H5.H5Gclose((int)locationId);
        }
        catch (Exception e) {
            throw new WQException("Exception closing HDF5 Group: " + groupName, e);
        }
    }

    private void closeDataSet(int locationId, String datasetName) throws WQException {
        try {
            int dataspaceId = H5.H5Dget_space((int)locationId);
            H5.H5Sclose((int)dataspaceId);
            H5.H5Dclose((int)locationId);
        }
        catch (Exception e) {
            throw new WQException("Exception closing HDF5 Dataset: " + datasetName, e);
        }
    }

    private void write2DDataSetFull(int locationId, String dsName, long[] dataDims, double[][] data) throws WQException {
        try {
            int rank = 2;
            int dataspaceId = H5.H5Screate_simple((int)rank, (long[])dataDims, null);
            int typeId = H5.H5Tcopy((int)HDF5Constants.H5T_NATIVE_DOUBLE);
            H5.H5Tset_order((int)typeId, (int)HDF5Constants.H5T_ORDER_LE);
            int dsId = H5.H5Dcreate((int)locationId, (String)dsName, (int)typeId, (int)dataspaceId, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
            int status = H5.H5Dwrite((int)dsId, (int)HDF5Constants.H5T_NATIVE_DOUBLE, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5P_DEFAULT, (Object)data);
            if (status < 0) {
                throw new WQException("Error writing HDF5 2D Dataset: " + dsName);
            }
            H5.H5Tclose((int)typeId);
            H5.H5Sclose((int)dataspaceId);
            H5.H5Dclose((int)dsId);
        }
        catch (Exception e) {
            throw new WQException("Exception writing HDF5 2D Dataset: " + dsName, e);
        }
    }

    private int create2DDataSet(int locationId, String dsName, int numCells, int nSteps) throws WQException {
        int dsId;
        try {
            int rank = 2;
            long[] chunkDims = new long[]{1L, numCells};
            long[] dataDims = new long[]{nSteps, numCells};
            int dataspaceId = H5.H5Screate_simple((int)rank, (long[])dataDims, null);
            int typeId = H5.H5Tcopy((int)HDF5Constants.H5T_NATIVE_DOUBLE);
            H5.H5Tset_order((int)typeId, (int)HDF5Constants.H5T_ORDER_LE);
            int propListId = H5.H5Pcreate((int)HDF5Constants.H5P_DATASET_CREATE);
            H5.H5Pset_deflate((int)propListId, (int)1);
            H5.H5Pset_chunk((int)propListId, (int)rank, (long[])chunkDims);
            dsId = H5.H5Dcreate((int)locationId, (String)dsName, (int)typeId, (int)dataspaceId, (int)HDF5Constants.H5P_DEFAULT, (int)propListId, (int)HDF5Constants.H5P_DEFAULT);
            if (dsId < 0) {
                throw new WQException("Error creating HDF5 2D Dataset: " + dsName);
            }
            H5.H5Tclose((int)typeId);
            H5.H5Sclose((int)dataspaceId);
            H5.H5Pclose((int)propListId);
        }
        catch (Exception e) {
            throw new WQException("Exception creating HDF5 2D Dataset: " + dsName, e);
        }
        return dsId;
    }

    private int create1DDataSet(int locationId, String dsName, int nSteps) throws WQException {
        int dsId;
        try {
            int rank = 1;
            long[] chunkDims = new long[]{1L};
            long[] dataDims = new long[]{nSteps};
            int dataspaceId = H5.H5Screate_simple((int)rank, (long[])dataDims, null);
            int typeId = H5.H5Tcopy((int)HDF5Constants.H5T_NATIVE_DOUBLE);
            H5.H5Tset_order((int)typeId, (int)HDF5Constants.H5T_ORDER_LE);
            int propListId = H5.H5Pcreate((int)HDF5Constants.H5P_DATASET_CREATE);
            H5.H5Pset_deflate((int)propListId, (int)1);
            H5.H5Pset_chunk((int)propListId, (int)rank, (long[])chunkDims);
            dsId = H5.H5Dcreate((int)locationId, (String)dsName, (int)typeId, (int)dataspaceId, (int)HDF5Constants.H5P_DEFAULT, (int)propListId, (int)HDF5Constants.H5P_DEFAULT);
            if (dsId < 0) {
                throw new WQException("Error creating HDF5 1D Dataset: " + dsName);
            }
            H5.H5Tclose((int)typeId);
            H5.H5Sclose((int)dataspaceId);
            H5.H5Pclose((int)propListId);
        }
        catch (Exception e) {
            throw new WQException("Exception creating HDF5 1D Dataset: " + dsName, e);
        }
        return dsId;
    }

    private int create1DStrDataSet(int locationId, String dsName, int strLen, int nSteps) throws WQException {
        int dsId;
        try {
            int rank = 1;
            long[] chunkDims = new long[]{1L};
            long[] dataDims = new long[]{nSteps};
            int dataspaceId = H5.H5Screate_simple((int)rank, (long[])dataDims, null);
            int typeId = H5.H5Tcopy((int)HDF5Constants.H5T_C_S1);
            H5.H5Tset_size((int)typeId, (int)strLen);
            int propListId = H5.H5Pcreate((int)HDF5Constants.H5P_DATASET_CREATE);
            H5.H5Pset_deflate((int)propListId, (int)1);
            H5.H5Pset_chunk((int)propListId, (int)rank, (long[])chunkDims);
            dsId = H5.H5Dcreate((int)locationId, (String)dsName, (int)typeId, (int)dataspaceId, (int)HDF5Constants.H5P_DEFAULT, (int)propListId, (int)HDF5Constants.H5P_DEFAULT);
            if (dsId < 0) {
                throw new WQException("Error creating HDF5 1D String Dataset: " + dsName);
            }
            H5.H5Tclose((int)typeId);
            H5.H5Sclose((int)dataspaceId);
            H5.H5Pclose((int)propListId);
        }
        catch (Exception e) {
            throw new WQException("Exception creating HDF5 1D String Dataset: " + dsName, e);
        }
        return dsId;
    }

    private void addTo2DDataSet(int locationId, int numCells, int row, double[][] data) throws WQException {
        try {
            int rank = 2;
            long[] addDataDims = new long[]{1L, numCells};
            long[] offset = new long[]{row, 0L};
            int newDataspaceId = H5.H5Dget_space((int)locationId);
            H5.H5Sselect_hyperslab((int)newDataspaceId, (int)HDF5Constants.H5S_SELECT_SET, (long[])offset, null, (long[])addDataDims, null);
            int slabSpaceId = H5.H5Screate_simple((int)rank, (long[])addDataDims, null);
            H5.H5Dwrite((int)locationId, (int)HDF5Constants.H5T_NATIVE_DOUBLE, (int)slabSpaceId, (int)newDataspaceId, (int)HDF5Constants.H5P_DEFAULT, (Object)data);
            H5.H5Sclose((int)slabSpaceId);
            H5.H5Sclose((int)newDataspaceId);
        }
        catch (Exception e) {
            throw new WQException("Exception adding to HDF5 2D Dataset ", e);
        }
    }

    private void addTo1DDataSet(int locationId, int row, double val) throws WQException {
        try {
            int rank = 1;
            long[] addDataDims = new long[]{1L};
            long[] offset = new long[]{row};
            int newDataspaceId = H5.H5Dget_space((int)locationId);
            H5.H5Sselect_hyperslab((int)newDataspaceId, (int)HDF5Constants.H5S_SELECT_SET, (long[])offset, null, (long[])addDataDims, null);
            int slabSpaceId = H5.H5Screate_simple((int)rank, (long[])addDataDims, null);
            double[] data = new double[]{val};
            H5.H5Dwrite((int)locationId, (int)HDF5Constants.H5T_NATIVE_DOUBLE, (int)slabSpaceId, (int)newDataspaceId, (int)HDF5Constants.H5P_DEFAULT, (Object)data);
            H5.H5Sclose((int)slabSpaceId);
            H5.H5Sclose((int)newDataspaceId);
        }
        catch (Exception e) {
            throw new WQException("Exception adding to HDF5 1D Dataset ", e);
        }
    }

    private void addTo1DStrDataSet(int locationId, int row, String val) throws WQException {
        try {
            int rank = 1;
            long[] addDataDims = new long[]{1L};
            long[] offset = new long[]{row};
            int newDataspaceId = H5.H5Dget_space((int)locationId);
            H5.H5Sselect_hyperslab((int)newDataspaceId, (int)HDF5Constants.H5S_SELECT_SET, (long[])offset, null, (long[])addDataDims, null);
            int slabSpaceId = H5.H5Screate_simple((int)rank, (long[])addDataDims, null);
            byte[] bytes = val.getBytes("UTF8");
            byte[][] data = new byte[1][bytes.length];
            data[0] = bytes;
            int typeId = H5.H5Tcopy((int)HDF5Constants.H5T_C_S1);
            H5.H5Tset_size((int)typeId, (int)bytes.length);
            H5.H5Dwrite((int)locationId, (int)typeId, (int)slabSpaceId, (int)newDataspaceId, (int)HDF5Constants.H5P_DEFAULT, (Object)data);
            H5.H5Tclose((int)typeId);
            H5.H5Sclose((int)slabSpaceId);
            H5.H5Sclose((int)newDataspaceId);
        }
        catch (Exception e) {
            throw new WQException("Exception adding to HDF5 1D String Dataset ", e);
        }
    }

    public void init(String wqEngineVersion) throws WQException {
        this._fileId = -1;
        try {
            this._fileId = H5.H5Fcreate((String)this._hdf5Filename, (int)HDF5Constants.H5F_ACC_TRUNC, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
        }
        catch (Exception e) {
            throw new WQException("Exception creating HDF5 File: " + this._hdf5Filename, e);
        }
        this.writeAttribute(this._fileId, "WQEngine Version", wqEngineVersion);
    }

    public void writeGeoHDF5(Geometry wqGeo) throws WQException {
        this._geomGroupId = this.createGroup(this._fileId, "Geometry");
        this.writeSubDomains(wqGeo);
        this.closeGroup(this._geomGroupId, "Geometry");
    }

    private void writeSubDomains(Geometry wqGeo) throws WQException {
        int subdomId = this.createGroup(this._geomGroupId, "Subdomains");
        for (SubDomain subdom : wqGeo.getSubDomainsInExtent()) {
            this.writeSubDomain(subdomId, subdom);
        }
        this.closeGroup(subdomId, "Subdomains");
    }

    private void writeSubDomain(int subdomGroupId, SubDomain subdom) throws WQException {
        String subdomName = subdom.getName();
        int groupId = this.createGroup(subdomGroupId, subdomName);
        this.writeAttribute(groupId, "Subdomain Type", subdom.getType().name());
        String dataSetName = "Cell Center Coordinate";
        long[] datasetDims = new long[]{subdom.getNumCells(), 3L};
        double[][] cellCenterCoords = subdom.getCellCenterCoordinates();
        this.write2DDataSetFull(groupId, dataSetName, datasetDims, cellCenterCoords);
        String lenDataSetName = "Cell Length";
        long[] lenDatasetDims = new long[]{subdom.getNumCells(), 1L};
        double[] cellLengths = subdom.getCellLength();
        int ncells = subdom.getNumCells();
        double[][] clen = new double[ncells][1];
        for (int i = 0; i < ncells; ++i) {
            clen[i][0] = cellLengths[i];
        }
        this.write2DDataSetFull(groupId, lenDataSetName, lenDatasetDims, clen);
        this.closeGroup(groupId, subdomName);
    }

    public void initHDF5Results(Geometry wqGeo, ConstituentSet wqConstitSet, int unitSystem, OutputVariableOptions outputOpts, WQEngineAdapter wqEngine, RunTimeWindow rtw, int outputInterval, int wqTimeStepMinutes) throws WQException {
        if (this._fileId < 0) {
            throw new WQException("HDF5 file id not found");
        }
        int stepConversion = rtw.getTimeStepMinutes() / wqTimeStepMinutes;
        int nSteps = rtw.getForecastSteps() * stepConversion / outputInterval + 1;
        this._resultsGroupId = this.createGroup(this._fileId, "Results");
        this._resultsSDId = this.createGroup(this._resultsGroupId, "Subdomains");
        this.writeAttribute(this._resultsGroupId, "Invalid data flag", -9999.0);
        this._numWQPathways = wqEngine.getNumberWQPathways();
        this._outputWQpathway = new boolean[this._numWQPathways];
        this._numWQDerivedVars = wqEngine.getNumberWQDerivedVars();
        this._outputWQderivedVar = new boolean[this._numWQDerivedVars];
        this._resultsSubdomGroupId = new HashMap<SubDomain, Integer>();
        this._resultsSubdomDSId = new HashMap<SubDomain, Map<Integer, Integer>>();
        for (SubDomain subdom : wqGeo.getSubDomainsInExtent()) {
            int j;
            int dsId;
            int ncells = subdom.getNumCells();
            int nfaces = subdom.getNumFaces();
            int gId = this.createGroup(this._resultsSDId, subdom.getName());
            this._resultsSubdomGroupId.put(subdom, gId);
            HashMap<Integer, Integer> idMap = new HashMap<Integer, Integer>();
            for (WqIoHydroType wqioType : WqIoHydroType.values()) {
                if (wqioType.getName().contains("Cell")) {
                    boolean b3;
                    boolean b1 = wqioType.getName().contains("volume") && outputOpts.shouldOutputCellVolume();
                    boolean b2 = wqioType.getName().contains("flow") && outputOpts.shouldOutputCellFlow();
                    boolean bl = b3 = wqioType.getName().contains("velocity") && outputOpts.shouldOutputCellVelocity();
                    if (!b1 && !b2 && !b3) continue;
                    dsId = this.create2DDataSet(gId, wqioType.getName(), ncells, nSteps);
                } else if (wqioType.getName().contains("boundary")) {
                    if (subdom.getType() != SubDomainType.RESERVOIR_1DV || !outputOpts.shouldOutputCellFlow()) continue;
                    dsId = this.create2DDataSet(gId, wqioType.getName(), ncells, nSteps);
                } else if (wqioType.getName().contains("Face")) {
                    dsId = this.create2DDataSet(gId, wqioType.getName(), nfaces, nSteps);
                } else {
                    if (subdom.getType() != SubDomainType.RESERVOIR_1DV) continue;
                    dsId = this.create1DDataSet(gId, wqioType.getName(), nSteps);
                }
                idMap.put(wqioType.getId(), dsId);
                String units = wqioType.getUnits(unitSystem);
                this.writeAttribute(dsId, "Units", units);
            }
            for (Constituent wqConstit : wqConstitSet.getConstituentList()) {
                String name = wqConstit.getDisplayName();
                dsId = this.create2DDataSet(gId, name, ncells, nSteps);
                int constituentId = wqConstit.getId();
                idMap.put(constituentId, dsId);
                String units = wqConstit.getUnit();
                this.writeAttribute(dsId, "Units", units);
                this.writeAttribute(dsId, "Constituent ID", constituentId);
            }
            for (j = 0; j < this._numWQPathways; ++j) {
                String name = wqEngine.getPathwayName(j);
                String units = wqEngine.getPathwayUnits(j);
                if (!units.trim().isEmpty()) {
                    this._outputWQpathway[j] = true;
                    dsId = this.create2DDataSet(gId, name, ncells, nSteps);
                    int pathwayId = this.getPathwayId(j);
                    idMap.put(pathwayId, dsId);
                    this.writeAttribute(dsId, "Units", units);
                    continue;
                }
                this._outputWQpathway[j] = false;
            }
            for (j = 0; j < this._numWQDerivedVars; ++j) {
                String name = wqEngine.getDerivedVarName(j);
                String units = wqEngine.getDerivedVarUnits(j);
                if (!units.trim().isEmpty()) {
                    this._outputWQderivedVar[j] = true;
                    dsId = this.create2DDataSet(gId, name, ncells, nSteps);
                    int derivedVarId = this.getDerivedVarId(j);
                    idMap.put(derivedVarId, dsId);
                    this.writeAttribute(dsId, "Units", units);
                    continue;
                }
                this._outputWQderivedVar[j] = false;
            }
            this._resultsSubdomDSId.put(subdom, idMap);
        }
        this._resultsTimeId = this.create1DDataSet(this._resultsSDId, "Time", nSteps);
        int strLen = WQTime.getDateTimeStrLen();
        this._resultsTimeStrId = this.create1DStrDataSet(this._resultsSDId, "Time Date Stamp", strLen, nSteps);
    }

    public void saveSnapshot(WQEngineAdapter wqEngine, Geometry wqGeo, ConstituentSet wqConstitSet, WQTime wqTime, WQTime.TIME_STEP_INFO tsInfoFlag, int row, OutputVariableOptions outputOpts) throws WQException {
        for (SubDomain subdom : wqGeo.getSubDomainsInExtent()) {
            int j;
            Integer dsId;
            int nCells = subdom.getNumCells();
            int nFaces = subdom.getNumFaces();
            for (WqIoHydroType wqioType : WqIoHydroType.values()) {
                if (wqioType.getName().contains("Cell")) {
                    boolean b3;
                    boolean b1 = wqioType.getName().contains("volume") && outputOpts.shouldOutputCellVolume();
                    boolean b2 = wqioType.getName().contains("flow") && outputOpts.shouldOutputCellFlow();
                    boolean bl = b3 = wqioType.getName().contains("velocity") && outputOpts.shouldOutputCellVelocity();
                    if (!b1 && !b2 && !b3) continue;
                    double[][] vals = new double[1][nCells];
                    vals[0] = wqEngine.getHydroResult(subdom.getId(), wqioType.getId(), tsInfoFlag.id, nCells);
                    dsId = this._resultsSubdomDSId.get(subdom).get(wqioType.getId());
                    if (dsId == null) continue;
                    this.addTo2DDataSet(dsId, nCells, row, vals);
                    continue;
                }
                if (wqioType.getName().contains("boundary")) {
                    if (subdom.getType() != SubDomainType.RESERVOIR_1DV || !outputOpts.shouldOutputCellFlow()) continue;
                    double[][] vals = new double[1][nCells];
                    vals[0] = wqEngine.getHydroResult(subdom.getId(), wqioType.getId(), tsInfoFlag.id, nCells);
                    dsId = this._resultsSubdomDSId.get(subdom).get(wqioType.getId());
                    if (dsId == null) continue;
                    this.addTo2DDataSet(dsId, nCells, row, vals);
                    continue;
                }
                if (wqioType.getName().contains("Face")) {
                    double[][] vals = new double[1][nFaces];
                    vals[0] = wqEngine.getHydroResult(subdom.getId(), wqioType.getId(), tsInfoFlag.id, nFaces);
                    dsId = this._resultsSubdomDSId.get(subdom).get(wqioType.getId());
                    if (dsId == null) continue;
                    this.addTo2DDataSet(dsId, nFaces, row, vals);
                    continue;
                }
                if (subdom.getType() != SubDomainType.RESERVOIR_1DV) continue;
                int ncols = 1;
                double[][] vals = new double[1][ncols];
                vals[0] = wqEngine.getHydroResult(subdom.getId(), wqioType.getId(), tsInfoFlag.id, ncols);
                dsId = this._resultsSubdomDSId.get(subdom).get(wqioType.getId());
                if (dsId == null) continue;
                this.addTo1DDataSet(dsId, row, vals[0][0]);
            }
            double[][] vals = new double[1][nCells];
            for (Constituent wqConstit : wqConstitSet.getConstituentList()) {
                int wqConstitId = wqConstit.getId();
                vals[0] = wqEngine.getConstitResult(subdom.getId(), wqConstitId, tsInfoFlag.id, nCells);
                dsId = this._resultsSubdomDSId.get(subdom).get(wqConstitId);
                if (dsId == null) continue;
                this.addTo2DDataSet(dsId, nCells, row, vals);
            }
            for (j = 0; j < this._numWQPathways; ++j) {
                if (!this._outputWQpathway[j]) continue;
                int pathwayId = this.getPathwayId(j);
                vals[0] = wqEngine.getPathwayResult(subdom.getId(), j, nCells);
                dsId = this._resultsSubdomDSId.get(subdom).get(pathwayId);
                if (dsId == null) continue;
                this.addTo2DDataSet(dsId, nCells, row, vals);
            }
            for (j = 0; j < this._numWQDerivedVars; ++j) {
                if (!this._outputWQderivedVar[j]) continue;
                int derivedVarId = this.getDerivedVarId(j);
                vals[0] = wqEngine.getDerivedVarResult(subdom.getId(), j, nCells);
                dsId = this._resultsSubdomDSId.get(subdom).get(derivedVarId);
                if (dsId == null) continue;
                this.addTo2DDataSet(dsId, nCells, row, vals);
            }
        }
        double timeInDays = wqTime.getCurrentTimeDays();
        String timeStrArray = wqTime.getCurrentTimeString();
        this.addTo1DDataSet(this._resultsTimeId, row, timeInDays);
        this.addTo1DStrDataSet(this._resultsTimeStrId, row, timeStrArray);
        if (this._firstTimeStepSave) {
            this._firstTimeStepSave = false;
        }
    }

    private int getPathwayId(int counter) {
        return -100 - counter;
    }

    private int getDerivedVarId(int counter) {
        return -1000 - counter;
    }

    public void closeFile() throws WQException {
        if (this._fileId < 0) {
            return;
        }
        this.closeResultDatasets();
        this.closeResultSubDomainGroups();
        if (this._resultsSDId > 0) {
            this.closeGroup(this._resultsSDId, "Subdomains");
        }
        if (this._resultsTimeId > 0) {
            this.closeDataSet(this._resultsTimeId, "Time");
        }
        if (this._resultsTimeStrId > 0) {
            this.closeDataSet(this._resultsTimeStrId, "Time Date Stamp");
        }
        if (this._resultsGroupId > 0) {
            this.closeGroup(this._resultsGroupId, "Results");
        }
        this.closeAllOpenResources();
        try {
            H5.H5Fclose((int)this._fileId);
        }
        catch (Exception e) {
            throw new WQException("Unexpected Exception closing HDF5 file", e);
        }
        this._fileId = -1;
    }

    private void closeResultSubDomainGroups() throws WQException {
        if (this._resultsSubdomGroupId != null) {
            for (Integer groupId : this._resultsSubdomGroupId.values()) {
                if (groupId == -1) continue;
                this.closeGroup(groupId, " ");
            }
        }
    }

    private void closeResultDatasets() throws WQException {
        if (this._resultsSubdomDSId != null) {
            for (Map<Integer, Integer> dsIdMap : this._resultsSubdomDSId.values()) {
                for (Integer dsId : dsIdMap.values()) {
                    this.closeDataSet(dsId, " ");
                }
            }
        }
    }

    private void closeAllOpenResources() throws WQException {
        try {
            int numOpenObjects = H5.H5Fget_obj_count((int)this._fileId, (int)HDF5Constants.H5F_OBJ_ALL);
            if (numOpenObjects > 0) {
                int[] objectIds = new int[numOpenObjects];
                H5.H5Fget_obj_ids((int)this._fileId, (int)HDF5Constants.H5F_OBJ_ALL, (int)numOpenObjects, (int[])objectIds);
                for (int i = 0; i < numOpenObjects; ++i) {
                    int objectType = H5.H5Iget_type((int)objectIds[i]);
                    if (objectType == HDF5Constants.H5I_DATASET) {
                        H5.H5Dclose((int)objectIds[i]);
                        continue;
                    }
                    if (objectType == HDF5Constants.H5I_GROUP) {
                        H5.H5Gclose((int)objectIds[i]);
                        continue;
                    }
                    if (objectType == HDF5Constants.H5I_DATATYPE) {
                        H5.H5Tclose((int)objectIds[i]);
                        continue;
                    }
                    if (objectType != HDF5Constants.H5I_ATTR) continue;
                    H5.H5Aclose((int)objectIds[i]);
                }
            }
            H5.H5Fflush((int)this._fileId, (int)HDF5Constants.H5F_SCOPE_GLOBAL);
        }
        catch (Exception e) {
            throw new WQException("Exception closing all HDF5 resources: ", e);
        }
    }
}

