/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore;

import hec.model.Interpolate;
import hec.wqenginecore.WQEngineAdapter;
import hec.wqenginecore.geometry.SubDomain;

public class WQReachHydro {
    private double[] _flow;
    private double[] _cellVol;
    private double[] _xsArea;
    private double[] _sfcWidth;
    private double[][] _subreachFlowArray;
    private double[][] _cellVolArray;
    private double[] _subreachFlow;
    private double[] _xFaceLoc;
    private double[] _xSubReachLoc;
    public static final int DEFAULT_NUM_SUBREACHES = 1;

    public void init(SubDomain wqgeosd, int numSubreaches, int numElemStates) {
        int j;
        int nf = wqgeosd.getNumFaces();
        this._flow = new double[nf];
        this._xsArea = new double[nf];
        this._sfcWidth = new double[nf];
        int nc = wqgeosd.getNumCells();
        this._xFaceLoc = new double[nc + 1];
        for (j = 0; j < nc + 1; ++j) {
            this._xFaceLoc[j] = (double)j / (double)nc;
        }
        this._cellVol = new double[nc];
        this._subreachFlow = new double[numSubreaches + 1];
        this._xSubReachLoc = new double[numSubreaches + 1];
        for (j = 0; j < numSubreaches + 1; ++j) {
            this._xSubReachLoc[j] = (double)j / (double)numSubreaches;
        }
        this._subreachFlowArray = new double[numElemStates][numSubreaches + 1];
        this._cellVolArray = new double[numElemStates][nc];
    }

    public double[] interpolateHydro(double[] srq1) {
        double[] qWQfaces = new double[this._xFaceLoc.length];
        for (int j = 0; j < this._xFaceLoc.length; ++j) {
            qWQfaces[j] = Interpolate.linearInterpolate((double[])this._xSubReachLoc, (double[])srq1, (double)this._xFaceLoc[j], (int)this._xSubReachLoc.length);
        }
        return qWQfaces;
    }

    public void setFlowFace(int j, double flow) {
        this._flow[j] = flow;
    }

    public void setCellVol(double[] vols) {
        System.arraycopy(vols, 0, this._cellVol, 0, vols.length);
    }

    public double[] getCellVol() {
        return this._cellVol;
    }

    public void setXSAreaFace(int j, double xsarea) {
        this._xsArea[j] = xsarea;
    }

    public void setSfcWidthFace(int j, double sfcWidth) {
        this._sfcWidth[j] = sfcWidth;
    }

    public void saveElementState(WQEngineAdapter.STATE state) {
        int stateId = state.id();
        System.arraycopy(this._subreachFlow, 0, this._subreachFlowArray[stateId], 0, this._subreachFlow.length);
        System.arraycopy(this._cellVol, 0, this._cellVolArray[stateId], 0, this._cellVol.length);
    }

    public void restoreElementState(WQEngineAdapter.STATE state) {
        int stateId = state.id();
        System.arraycopy(this._subreachFlowArray[stateId], 0, this._subreachFlow, 0, this._subreachFlow.length);
        System.arraycopy(this._cellVolArray[stateId], 0, this._cellVol, 0, this._cellVol.length);
    }

    public void setSubreachFlow(double[] srFlows) {
        System.arraycopy(srFlows, 0, this._subreachFlow, 0, srFlows.length);
    }

    public double[] getFlow() {
        return this._flow;
    }

    public double getFlow(int faceIdx) {
        return this._flow[faceIdx];
    }

    public double[] getXSArea() {
        return this._xsArea;
    }

    public double[] getSfcWidth() {
        return this._sfcWidth;
    }

    public double[] getSubreachFlow() {
        int n = this._subreachFlowArray[0].length;
        double[] da = new double[n];
        System.arraycopy(this._subreachFlow, 0, da, 0, n);
        return da;
    }
}

