/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore;

import hec.wqenginecore.WQEngineAdapter;
import hec.wqenginecore.WQException;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.WQControlDevice;
import java.util.List;

public class WQResHydro {
    private double _storage;
    private double _seepage;
    private double _evapPrecip;
    private double[] _flows;
    private double[] _outletFlows;
    private double[] _tcdFlows;
    private double[] _tcdFlowRatios;
    private double[] _savedStorage;
    private double[] _savedSeepage;
    private double[] _savedEvapPrecip;
    private double[][] _savedFlows;
    private double[][] _savedOutletFlows;
    private double[][] _savedTCDFlows;
    private double[][] _savedTCDFlowRatios;
    private int[] _tcdStartIdx;
    private boolean _init = false;

    public void init(SubDomain wqgeosd, int numElemStates, WQEngineAdapter wqEngine) throws WQException {
        if (!this._init) {
            int nff = wqgeosd.getNumFacesFlow();
            int noutlets = wqgeosd.getNumOutlets();
            int nTCDinlets = 0;
            if (wqgeosd.getWqControlDevices() != null) {
                List<WQControlDevice> wqControlDevices = wqgeosd.getWqControlDevices();
                this._tcdStartIdx = new int[wqControlDevices.size()];
                this._tcdStartIdx[0] = 0;
                for (int j = 0; j < wqControlDevices.size(); ++j) {
                    WQControlDevice wqControlDevice = wqControlDevices.get(j);
                    double[] inletElevs = wqEngine.getWQCDInletLevels(wqgeosd, wqControlDevice);
                    nTCDinlets += inletElevs.length;
                    if (j >= wqControlDevices.size() - 1) continue;
                    this._tcdStartIdx[j + 1] = this._tcdStartIdx[j] + inletElevs.length;
                }
            }
            this._flows = new double[nff];
            this._outletFlows = new double[noutlets];
            this._tcdFlows = new double[nTCDinlets];
            this._tcdFlowRatios = new double[nTCDinlets];
            this._savedStorage = new double[numElemStates];
            this._savedSeepage = new double[numElemStates];
            this._savedEvapPrecip = new double[numElemStates];
            this._savedFlows = new double[numElemStates][nff];
            this._savedOutletFlows = new double[numElemStates][noutlets];
            this._savedTCDFlows = new double[numElemStates][nTCDinlets];
            this._savedTCDFlowRatios = new double[numElemStates][nTCDinlets];
            this._init = true;
        }
    }

    public void setStorage(double stor) {
        this._storage = stor;
    }

    public void setSeepage(double seep) {
        this._seepage = seep;
    }

    public void setEvapPrecip(double evapPrecip) {
        this._evapPrecip = evapPrecip;
    }

    public void setFlows(double[] flows) {
        this._flows = flows;
    }

    public void setOutletFlows(List<Double> outletFlows) {
        for (int j = 0; j < outletFlows.size(); ++j) {
            this._outletFlows[j] = outletFlows.get(j);
        }
    }

    public void setTCDFlows(double[] tcdFlows, int tcdIdx) {
        int startIdx = this._tcdStartIdx[tcdIdx];
        for (int i = 0; i < tcdFlows.length; ++i) {
            int j = startIdx + i;
            this._tcdFlows[j] = tcdFlows[i];
        }
    }

    public void setTCDFlowRatios(double[] tcdFlowRatios, int tcdIdx) {
        int startIdx = this._tcdStartIdx[tcdIdx];
        for (int i = 0; i < tcdFlowRatios.length; ++i) {
            int j = startIdx + i;
            this._tcdFlowRatios[j] = tcdFlowRatios[i];
        }
    }

    public void setTCDFlowFromRatios(double totalTcdFlow, int tcdIdx) {
        int startIdx = this._tcdStartIdx[tcdIdx];
        int endIdx = this.getTcdArrayEndIdx(tcdIdx);
        for (int j = startIdx; j < endIdx; ++j) {
            this._tcdFlows[j] = this._tcdFlowRatios[j] * totalTcdFlow;
        }
    }

    private int getTcdArrayEndIdx(int tcdIdx) {
        int endIdx = tcdIdx == this._tcdStartIdx.length - 1 ? this._tcdFlows.length : this._tcdStartIdx[tcdIdx + 1];
        return endIdx;
    }

    public double getStorage() {
        return this._storage;
    }

    public double getSeepage() {
        return this._seepage;
    }

    public double getEvapPrecip() {
        return this._evapPrecip;
    }

    public double[] getFlows() {
        return this._flows;
    }

    public double[] getOutletFlows() {
        return this._outletFlows;
    }

    public double[] getTCDFlows(int tcdIdx) {
        int startIdx = this._tcdStartIdx[tcdIdx];
        int endIdx = this.getTcdArrayEndIdx(tcdIdx);
        int size = endIdx - startIdx;
        double[] tFlows = new double[size];
        for (int i = 0; i < size; ++i) {
            int j = i + startIdx;
            tFlows[i] = this._tcdFlows[j];
        }
        return tFlows;
    }

    public double[] getTCDFlows() {
        return this._tcdFlows;
    }

    public double[] getTCDFlowRatios() {
        return this._tcdFlowRatios;
    }

    public double getTotalTCDFlowRatios(int tcdIdx) {
        double totalRatio = 0.0;
        int startIdx = this._tcdStartIdx[tcdIdx];
        int endIdx = this.getTcdArrayEndIdx(tcdIdx);
        for (int j = startIdx; j < endIdx; ++j) {
            totalRatio += this._tcdFlowRatios[j];
        }
        return totalRatio;
    }

    public void saveElementState(WQEngineAdapter.STATE state) {
        int stateId = state.id();
        this._savedStorage[stateId] = this._storage;
        this._savedSeepage[stateId] = this._seepage;
        this._savedEvapPrecip[stateId] = this._evapPrecip;
        System.arraycopy(this._flows, 0, this._savedFlows[stateId], 0, this._flows.length);
        System.arraycopy(this._outletFlows, 0, this._savedOutletFlows[stateId], 0, this._outletFlows.length);
        System.arraycopy(this._tcdFlows, 0, this._savedTCDFlows[stateId], 0, this._tcdFlows.length);
        System.arraycopy(this._tcdFlowRatios, 0, this._savedTCDFlowRatios[stateId], 0, this._tcdFlowRatios.length);
    }

    public void restoreElementState(WQEngineAdapter.STATE state) {
        int stateId = state.id();
        this._storage = this._savedStorage[stateId];
        this._seepage = this._savedSeepage[stateId];
        this._evapPrecip = this._savedEvapPrecip[stateId];
        System.arraycopy(this._savedFlows[stateId], 0, this._flows, 0, this._flows.length);
        System.arraycopy(this._savedOutletFlows[stateId], 0, this._outletFlows, 0, this._outletFlows.length);
        System.arraycopy(this._savedTCDFlows[stateId], 0, this._tcdFlows, 0, this._tcdFlows.length);
        System.arraycopy(this._savedTCDFlowRatios[stateId], 0, this._tcdFlowRatios, 0, this._tcdFlowRatios.length);
    }
}

