/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore;

public enum WqIoHydroType {
    CELL_VOLUME("Cell volume", "m3", "ft3", -1),
    CELL_FLOW("Cell flow", "m3/s", "cfs", -2),
    CELL_INFLOW("Total boundary inflow", "m3/s", "cfs", -3),
    CELL_OUTFLOW("Total boundary outflow", "m3/s", "cfs", -4),
    CELL_VELOCITY("Cell velocity", "m/s", "ft/s", -5),
    WATER_SFC_ELEV("Water Surface Elevation", "m", "ft", -8),
    SFC_AREA("Surface area", "m2", "ft2", -9);

    private final String _name;
    private final String _units_SI;
    private final String _units_English;
    private final int _id;

    private WqIoHydroType(String name, String unitsSI, String unitsEnglish, int id) {
        this._name = name;
        this._units_SI = unitsSI;
        this._units_English = unitsEnglish;
        this._id = id;
    }

    public String getName() {
        return this._name;
    }

    public String getUnits(int unitSystem) {
        if (unitSystem == 1) {
            return this._units_English;
        }
        return this._units_SI;
    }

    public int getId() {
        return this._id;
    }

    public String toString() {
        return this._name;
    }
}

