/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.dataSource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.WQFlowComputeType;
import hec.wqenginecore.jackson.TypeResolver;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
@JsonPropertyOrder(value={"name", "description", "units", "availableUnits", "compType"})
public class Data {
    @JsonIgnore
    protected final String _type;
    @JsonProperty(value="units")
    private String _units;
    @JsonProperty(value="name")
    private String _name;
    @JsonProperty(value="description")
    private String _description;
    @JsonProperty(value="compType")
    protected int _compType;
    String[] _availableUnits = new String[0];

    protected Data(String type) {
        this._type = type;
        this._name = "";
        this._description = "";
    }

    protected Data(String type, String name) {
        this(type);
        this._name = name;
    }

    protected Data(Data copyFrom) {
        this(copyFrom.getType(), copyFrom.getName());
        String[] availUnits;
        this._description = copyFrom.getDescription();
        this._units = copyFrom.getUnits();
        String[] inputAvailableUnits = copyFrom.getAvailableUnits();
        if (inputAvailableUnits != null && inputAvailableUnits.length > 0) {
            this._availableUnits = new String[inputAvailableUnits.length];
            System.arraycopy(inputAvailableUnits, 0, this._availableUnits, 0, inputAvailableUnits.length);
        }
        this._compType = copyFrom.getCompType();
        if (this._units == null && (availUnits = this.getAvailableUnits()).length > 0) {
            this.setUnits(availUnits[0]);
        }
    }

    @JsonIgnore
    public String getType() {
        return this._type;
    }

    public final void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String getUnits() {
        return this._units;
    }

    public void setUnits(String units) {
        this._units = units;
    }

    public String[] getAvailableUnits() {
        return this._availableUnits;
    }

    public void setAvailableUnits(String[] availableUnits) {
        this._availableUnits = availableUnits;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public int getCompType() {
        return WQFlowComputeType.INSTANTANEOUS.id();
    }

    public void setCompType(int compType) {
        this._compType = compType;
    }

    @JsonIgnore
    public boolean isDefined() {
        return this._units != null && !this._units.isEmpty();
    }

    @JsonIgnore
    public boolean isEmpty() {
        return false;
    }

    @JsonIgnore
    public Data copy() {
        return new Data(this);
    }
}

