/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.dataSource.ambient;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.jackson.TypeResolver;
import java.util.HashMap;
import java.util.Map;
import rma.services.annotations.ServiceProvider;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AmbientData
extends Data {
    public static final String TYPE = "AmbientData";
    public static final String NAME = "Ambient Value";
    public static final String AVERAGE_AT_JUNCTION = "AVERAGE_AT_JUNCTION";
    public static final String AVERAGE_RECIEVING_WATER = "AVERAGE_RECIEVING_WATER";
    public static final Map<String, Integer> OPTION_MAP = new HashMap<String, Integer>(){
        {
            this.put(AmbientData.AVERAGE_AT_JUNCTION, 1);
            this.put(AmbientData.AVERAGE_RECIEVING_WATER, 2);
        }
    };
    @JsonProperty(value="OptionType")
    String _optionType = "AVERAGE_AT_JUNCTION";

    public AmbientData() {
        super(TYPE, NAME);
    }

    public AmbientData(AmbientData ambientData) {
        this();
        this._optionType = ambientData._optionType;
    }

    public void setOptionType(String value) {
        if (!AVERAGE_AT_JUNCTION.equalsIgnoreCase(value) && !AVERAGE_RECIEVING_WATER.equalsIgnoreCase(value)) {
            String msg = "Invalid value passed into AmbientData.setOptionType(). Valid values are:\nAVERAGE_AT_JUNCTION,\nAVERAGE_RECIEVING_WATER";
            throw new IllegalArgumentException(msg);
        }
        this._optionType = value;
    }

    @JsonIgnore
    public String getOptionType() {
        return this._optionType;
    }

    @JsonIgnore
    public Integer getOptionInt() {
        return OPTION_MAP.get(this._optionType);
    }

    @Override
    @JsonIgnore
    public AmbientData copy() {
        return new AmbientData(this);
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class AmbientDataTypeResolverRegistration
    implements TypeResolver.TypeResolverRegistration {
        public Class getTypeClass() {
            return AmbientData.class;
        }

        @Override
        public String getTypeId() {
            return AmbientData.class.getSimpleName();
        }
    }
}

