/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.dataSource.constant;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.jackson.TypeResolver;
import rma.services.annotations.ServiceProvider;
import rma.util.RMAConst;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ConstantData
extends Data {
    public static final String TYPE = "ConstantData";
    public static final String NAME = "Constant Value";
    @JsonProperty(value="value")
    private double _constantValue = Double.NEGATIVE_INFINITY;

    public ConstantData() {
        super(TYPE, NAME);
    }

    public ConstantData(ConstantData constantData) {
        super(constantData);
        this.setConstantValue(constantData.getConstantValue());
        this.setAvailableUnits(constantData.getAvailableUnits());
        this.setUnits(constantData.getUnits());
        this.setCompType(this.getCompType());
    }

    @JsonIgnore
    public double getConstantValue() {
        return this._constantValue;
    }

    public void setConstantValue(double constantValue) {
        this._constantValue = constantValue;
    }

    @Override
    @JsonIgnore
    public boolean isDefined() {
        return super.isDefined() && RMAConst.isValidValue((double)this._constantValue);
    }

    @Override
    @JsonIgnore
    public boolean isEmpty() {
        return this.getConstantValue() == Double.NEGATIVE_INFINITY || !RMAConst.isValidValue((double)this.getConstantValue());
    }

    @Override
    @JsonIgnore
    public ConstantData copy() {
        return new ConstantData(this);
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class ConstantDataTypeResolverRegistration
    implements TypeResolver.TypeResolverRegistration {
        public Class getTypeClass() {
            return ConstantData.class;
        }

        @Override
        public String getTypeId() {
            return ConstantData.class.getSimpleName();
        }
    }
}

