/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.dataSource.excel;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.jackson.TypeResolver;
import java.nio.file.Path;
import java.nio.file.Paths;
import rma.services.annotations.ServiceProvider;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExcelData
extends Data {
    @JsonProperty(value="filePath")
    Path _excelFilePath;
    @JsonProperty(value="worksheetName")
    String _worksheetName = "";
    @JsonProperty(value="timeColumn")
    String _timeColumn = "";
    @JsonProperty(value="valueColumn")
    String _valueColumn = "";
    @JsonProperty(value="topRow")
    int _topRow = 0;
    @JsonProperty(value="bottomRow")
    int _bottomRow = 0;
    public static final String TYPE = "ExcelData";
    public static final String NAME = "Excel Worksheet";

    public ExcelData() {
        super(TYPE, NAME);
    }

    public ExcelData(ExcelData excelData) {
        super(excelData);
        this.setBottomRow(excelData.getBottomRow());
        this.setExcelFilePath(excelData.getExcelFilePath());
        this.setTimeColumn(excelData.getTimeColumn());
        this.setTopRow(excelData.getTopRow());
        this.setValueColumn(excelData.getValueColumn());
        this.setWorksheetName(excelData.getWorksheetName());
        this.setAvailableUnits(excelData.getAvailableUnits());
        this.setUnits(excelData.getUnits());
    }

    @JsonIgnore
    public String getExcelFilePath() {
        return this._excelFilePath != null ? this._excelFilePath.toFile().getAbsolutePath() : "";
    }

    public void setExcelFilePath(String excelFilePath) {
        this._excelFilePath = excelFilePath != null && !excelFilePath.isEmpty() ? Paths.get(excelFilePath, new String[0]) : null;
    }

    @Override
    @JsonIgnore
    public boolean isEmpty() {
        return this.getExcelFilePath() == null || this.getExcelFilePath().isEmpty();
    }

    @JsonIgnore
    public String getWorksheetName() {
        return this._worksheetName;
    }

    public void setWorksheetName(String worksheetName) {
        this._worksheetName = worksheetName;
    }

    @JsonIgnore
    public String getTimeColumn() {
        return this._timeColumn;
    }

    public void setTimeColumn(String timeColumn) {
        this._timeColumn = timeColumn;
    }

    @JsonIgnore
    public String getValueColumn() {
        return this._valueColumn;
    }

    public void setValueColumn(String valueColumn) {
        this._valueColumn = valueColumn;
    }

    @JsonIgnore
    public int getTopRow() {
        return this._topRow;
    }

    public void setTopRow(int topRow) {
        this._topRow = topRow;
    }

    @JsonIgnore
    public int getBottomRow() {
        return this._bottomRow;
    }

    public void setBottomRow(int bottomRow) {
        this._bottomRow = bottomRow;
    }

    @Override
    @JsonIgnore
    public boolean isDefined() {
        boolean defined = super.isDefined();
        if (!defined) {
            return false;
        }
        defined &= !this._worksheetName.isEmpty();
        defined &= !this._timeColumn.isEmpty();
        defined &= !this._valueColumn.isEmpty();
        defined &= this._topRow > 0;
        return defined &= this._bottomRow > 0;
    }

    @Override
    @JsonIgnore
    public ExcelData copy() {
        return new ExcelData(this);
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class ExcelDataTypeResolverRegistration
    implements TypeResolver.TypeResolverRegistration {
        public Class getTypeClass() {
            return ExcelData.class;
        }

        @Override
        public String getTypeId() {
            return ExcelData.class.getSimpleName();
        }
    }
}

