/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.dataSource.latlong;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import hec.wqenginecore.WQFlowComputeType;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqenginecore.metstation.MetStation;
import rma.services.annotations.ServiceProvider;
import rma.util.RMAConst;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LatLongData
extends Data {
    public static final String C_PART = "Irrad";
    public static final double DEFAULT_COMPUTE_INTERVAL_MINUTES = 60.0;
    public static final double DEFAULT_DUST_COEFFICIENT = 0.04;
    public static final String TYPE = "LatLongData";
    public static final String NAME = "Lat-Long";
    @JsonProperty(value="dustCoefficient")
    private double _dustCoefficient = 0.04;
    @JsonProperty(value="interval")
    private double _computeIntrval = 60.0;
    private double _latitude;
    private double _longitude;
    private int _nearestMeridian;

    public LatLongData(LatLongData latLongData) {
        super(latLongData);
        this._dustCoefficient = latLongData.getDustCoefficient();
        this._computeIntrval = latLongData.getComputeInterval();
        this._latitude = latLongData.getLatitude();
        this._longitude = latLongData.getLongitude();
        this._nearestMeridian = latLongData.getNearestMeridian();
    }

    public LatLongData() {
        super(TYPE, NAME);
    }

    @JsonIgnore
    public double getDustCoefficient() {
        return this._dustCoefficient;
    }

    public void setDustCoefficient(double dustCoefficient) {
        this._dustCoefficient = dustCoefficient;
    }

    @JsonIgnore
    public double getComputeInterval() {
        return this._computeIntrval;
    }

    public void setComputeIntrval(double computeIntrval) {
        this._computeIntrval = computeIntrval;
    }

    public double getLatitude() {
        return this._latitude;
    }

    public void setLatitude(double latitude) {
        this._latitude = latitude;
    }

    public double getLongitude() {
        return this._longitude;
    }

    public void setLongitude(double longitude) {
        this._longitude = longitude;
    }

    public int getNearestMeridian() {
        return this._nearestMeridian;
    }

    public void setNearestMeridian(int nearestMeridian) {
        this._nearestMeridian = nearestMeridian;
    }

    @Override
    @JsonIgnore
    public boolean isDefined() {
        return super.isDefined() && RMAConst.isValidValue((double)this._dustCoefficient);
    }

    @Override
    @JsonIgnore
    public LatLongData copy() {
        return new LatLongData(this);
    }

    @Override
    public int getCompType() {
        return WQFlowComputeType.PERIOD_AVERAGE.id();
    }

    public static LatLongData createLatLongData(MetStation metStation) {
        LatLongData latLongData = new LatLongData();
        latLongData.setLatitude(metStation.getLatitude());
        latLongData.setLongitude(metStation.getLongitude());
        latLongData.setNearestMeridian(metStation.getNearestMeridian());
        latLongData.setDustCoefficient(0.04);
        latLongData.setComputeIntrval(60.0);
        return latLongData;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class LatLongDataTypeResolverRegistration
    implements TypeResolver.TypeResolverRegistration {
        public Class getTypeClass() {
            return LatLongData.class;
        }

        @Override
        public String getTypeId() {
            return LatLongData.class.getSimpleName();
        }
    }
}

