/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.dataSource.pairedData;

import hec.wqenginecore.dataSource.pairedData.SelectionType;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.jackson.TypeResolver;
import rma.services.annotations.ServiceProvider;

public class PairedCurveData
extends DssData {
    public static final String TYPE = "PairedCurveData";
    public static final String NAME = "DSS Paired Data Container";
    int _curve = 0;
    private SelectionType _selectionType;

    public PairedCurveData() {
    }

    public PairedCurveData(DssData dssData, int curve) {
        super(dssData);
        this._curve = curve;
    }

    public PairedCurveData(PairedCurveData pairedCurveData) {
        super(pairedCurveData);
        this._curve = pairedCurveData.getCurve();
        this._selectionType = pairedCurveData.getSelectionType();
    }

    public int getCurve() {
        return this._curve;
    }

    public void setCurve(int curve) {
        this._curve = curve;
    }

    @Override
    public PairedCurveData copy() {
        return new PairedCurveData(this);
    }

    public SelectionType getSelectionType() {
        return this._selectionType;
    }

    public void setSelectionType(SelectionType selectionType) {
        this._selectionType = selectionType;
    }

    public String toString() {
        return "PairedCurveData{filePath='" + this.getDssFilePath() + "', dssPath=" + this.getDssPath() + ", curve=" + this._curve + ", selectionType=" + this._selectionType + "}";
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(PairedCurveData.class);
        }
    }
}

